/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.storage;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.Set;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.StoredFileException;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;

public interface StoredFileHandler {
    public static final String SKIP_LOCK_PROPERTY = "cyclos.skipStorageLocks";
    public static final boolean SKIP_LOCK = Boolean.getBoolean("cyclos.skipStorageLocks");

    public static Set<String> getStorageDirectories(CyclosProperties cyclosProperties) {
        String string = cyclosProperties.getStoredFileContentManagerProperties().getProperty("directories", "");
        return CollectionHelper.asSet((Iterable)StringHelper.splitTrimming((String)string, (String)","));
    }

    public void copy(StoredFile var1, StoredFile var2) throws StoredFileException;

    public BooleanExpression customFieldEquals(EntityPath<?> var1, CustomField<?, ?, ?> var2);

    public <T extends StoredFile> T find(Class<T> var1, long var2) throws StoredFileException, EntityNotFoundException;

    public byte[] getBytes(StoredFile var1) throws StoredFileException, EntityNotFoundException;

    public SerializableInputStream getContent(StoredFile var1) throws StoredFileException, EntityNotFoundException;

    public Set<String> getStorageDirectories();

    public String getStorageDirectory(StoredFile var1);

    public boolean isStoredOnDB();

    public void move(StoredFile var1, StoredFile var2) throws StoredFileException;

    public void remove(long var1) throws StoredFileException, EntityNotFoundException;

    public void save(StoredFile var1, SerializableInputStream var2) throws StoredFileException;

    public boolean supportStorageDirectories();
}

