/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.sql.CachingPreparedStatement;
import org.cyclos.impl.sql.DatabaseCachingMetadata;
import org.cyclos.impl.sql.ProfilingPreparedStatement;
import org.cyclos.impl.sql.ProfilingStatement;
import org.cyclos.impl.sql.TableCacheKey;
import org.cyclos.impl.sql.TableCacheValue;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.model.system.profiling.StartProfilingParams;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.springframework.jdbc.core.ConnectionCallback;

public class CachingConnection
implements Connection {
    private static final Pattern ALIAS_PATTERN = Pattern.compile("(\\w+) (\\w+)");
    private static final Logger LOG = LogManager.getLogger(CachingConnection.class);
    private static final Set<String> LOW_LEVEL_QUERIES = Set.of("select lastval()", "select pg_try_advisory_xact_lock(?)");
    private final DatabaseCachingMetadata metadata;
    private final CacheHandler cacheHandler;
    private final JsonConverter jsonConverter;
    private final ConnectionSupplier supplier;
    private Connection _delegate;
    private boolean closed;
    private Boolean autoCommit;
    private String catalog;
    private Properties clientInfo;
    private Integer holdability;
    private Executor networkTimeoutExecutor;
    private Integer networkTimeoutMilliseconds;
    private Boolean readOnly;
    private String schema;
    private Integer transactionIsolation;
    private Map<String, Class<?>> typeMap;

    public static boolean isLowLevelQuery(String string) {
        return LOW_LEVEL_QUERIES.contains(string.trim().toLowerCase());
    }

    private static boolean isTableNameCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    public CachingConnection(DatabaseCachingMetadata databaseCachingMetadata, CacheHandler cacheHandler, JsonConverter jsonConverter, ConnectionSupplier connectionSupplier) {
        this.metadata = databaseCachingMetadata;
        this.cacheHandler = cacheHandler;
        this.jsonConverter = jsonConverter;
        this.supplier = connectionSupplier;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.getDelegate().abort(executor);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getDelegate().clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        if (this._delegate == null) {
            this.closed = true;
        } else {
            this._delegate.close();
        }
    }

    @Override
    public void commit() throws SQLException {
        this.getDelegate().commit();
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        return this.getDelegate().createArrayOf(string, objectArray);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.getDelegate().createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.getDelegate().createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.getDelegate().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.getDelegate().createSQLXML();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.doCreateStatement((ConnectionCallback<Statement>)((ConnectionCallback)Connection::createStatement));
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return this.doCreateStatement((ConnectionCallback<Statement>)((ConnectionCallback)connection -> connection.createStatement(n, n2)));
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return this.doCreateStatement((ConnectionCallback<Statement>)((ConnectionCallback)connection -> connection.createStatement(n, n2, n3)));
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        return this.getDelegate().createStruct(string, objectArray);
    }

    public PreparedStatement doPrepareStatement(String string, boolean bl) throws SQLException {
        return this.doPrepareStatement((ConnectionCallback<PreparedStatement>)((ConnectionCallback)connection -> connection.prepareStatement(string)), string, bl);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this._delegate == null ? Boolean.TRUE.equals(this.autoCommit) : this._delegate.getAutoCommit();
    }

    public CacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this._delegate == null) {
            return this.catalog;
        }
        return this._delegate.getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this._delegate == null) {
            return this.clientInfo == null ? new Properties() : this.clientInfo;
        }
        return this._delegate.getClientInfo();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        if (this._delegate == null) {
            return this.clientInfo == null ? null : this.clientInfo.getProperty(string);
        }
        return this._delegate.getClientInfo(string);
    }

    public Connection getDelegate() throws SQLException {
        if (this._delegate == null) {
            if (this.closed) {
                throw new SQLException("Connection already closed");
            }
            this._delegate = this.supplier.get();
            if (this.autoCommit != null) {
                this._delegate.setAutoCommit(this.autoCommit);
                this.autoCommit = null;
            }
            if (this.catalog != null) {
                this._delegate.setCatalog(this.catalog);
                this.catalog = null;
            }
            if (this.clientInfo != null) {
                this._delegate.setClientInfo(this.clientInfo);
                this.clientInfo = null;
            }
            if (this.holdability != null) {
                this._delegate.setHoldability(this.holdability);
                this.holdability = null;
            }
            if (this.networkTimeoutExecutor != null) {
                this._delegate.setNetworkTimeout(this.networkTimeoutExecutor, this.networkTimeoutMilliseconds);
                this.networkTimeoutExecutor = null;
                this.networkTimeoutMilliseconds = null;
            }
            if (this.readOnly != null) {
                this._delegate.setReadOnly(this.readOnly);
                this.readOnly = null;
            }
            if (this.schema != null) {
                this._delegate.setSchema(this.schema);
                this.schema = null;
            }
            if (this.transactionIsolation != null) {
                this._delegate.setTransactionIsolation(this.transactionIsolation);
                this.transactionIsolation = null;
            }
            if (this.typeMap != null) {
                this._delegate.setTypeMap(this.typeMap);
                this.typeMap = null;
            }
        }
        return this._delegate;
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this._delegate == null) {
            return this.holdability == null ? 2 : this.holdability;
        }
        return this._delegate.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getDelegate().getMetaData();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this._delegate == null) {
            return this.networkTimeoutMilliseconds == null ? 0 : this.networkTimeoutMilliseconds;
        }
        return this._delegate.getNetworkTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        if (this._delegate == null) {
            return this.schema;
        }
        return this._delegate.getSchema();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this._delegate == null) {
            return this.transactionIsolation == null ? 2 : this.transactionIsolation;
        }
        return this._delegate.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        if (this._delegate == null) {
            return this.typeMap;
        }
        return this._delegate.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getDelegate().getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this._delegate == null) {
            return this.closed;
        }
        return this.getDelegate().isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this._delegate == null) {
            return Boolean.TRUE.equals(this.readOnly);
        }
        return this._delegate.isReadOnly();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        return this.getDelegate().isValid(n);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return this.getDelegate().isWrapperFor(clazz);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return this.getDelegate().nativeSQL(string);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.getDelegate().prepareCall(string);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.getDelegate().prepareCall(string, n, n2);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return this.getDelegate().prepareCall(string, n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        CacheAction cacheAction = this.getCacheAction(string);
        if (cacheAction == null) {
            LOG.debug("Not cacheable SQL: {}", (Object)string);
        } else {
            if (cacheAction.isWrite()) {
                InvocationContext.markWrite();
            }
            if (cacheAction.hasTables()) {
                for (String string2 : cacheAction.getTables()) {
                    CacheType<TableCacheKey, TableCacheValue> cacheType = CacheType.forTable(string2);
                    if (cacheAction.isClearTableCache()) {
                        LOG.debug("Clearing table cache for {}", (Object)string2);
                        this.cacheHandler.scheduleClear(cacheType);
                        continue;
                    }
                    if (!cacheAction.isReadFromTableCache()) continue;
                    LOG.trace("Executing a cacheable sql for {}: {}", (Object)string2, (Object)string);
                    return new CachingPreparedStatement(this, cacheType, string, this.jsonConverter);
                }
            }
        }
        return this.doPrepareStatement(string, false);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.doPrepareStatement((ConnectionCallback<PreparedStatement>)((ConnectionCallback)connection -> connection.prepareStatement(string, n)), string, false);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.doPrepareStatement((ConnectionCallback<PreparedStatement>)((ConnectionCallback)connection -> connection.prepareStatement(string, n, n2)), string, false);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.doPrepareStatement((ConnectionCallback<PreparedStatement>)((ConnectionCallback)connection -> connection.prepareStatement(string, n, n2, n3)), string, false);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.doPrepareStatement((ConnectionCallback<PreparedStatement>)((ConnectionCallback)connection -> connection.prepareStatement(string, nArray)), string, false);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.doPrepareStatement((ConnectionCallback<PreparedStatement>)((ConnectionCallback)connection -> connection.prepareStatement(string, stringArray)), string, false);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.getDelegate().releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        if (this._delegate != null) {
            this._delegate.rollback();
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.getDelegate().rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (this._delegate == null) {
            this.autoCommit = bl;
        } else {
            this._delegate.setAutoCommit(bl);
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        if (this._delegate == null) {
            this.catalog = string;
        } else {
            this._delegate.setCatalog(string);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this._delegate == null) {
            this.clientInfo = properties;
        } else {
            this._delegate.setClientInfo(properties);
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (this._delegate == null) {
            if (this.clientInfo == null) {
                this.clientInfo = new Properties();
            }
            this.clientInfo.setProperty(string, string2);
        } else {
            this._delegate.setClientInfo(string, string2);
        }
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        if (this._delegate == null) {
            this.holdability = n;
        } else {
            this._delegate.setHoldability(n);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        if (this._delegate == null) {
            this.networkTimeoutExecutor = executor;
            this.networkTimeoutMilliseconds = n;
        } else {
            this._delegate.setNetworkTimeout(executor, n);
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        if (this._delegate == null) {
            this.readOnly = bl;
        } else {
            this._delegate.setReadOnly(bl);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.getDelegate().setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        return this.getDelegate().setSavepoint(string);
    }

    @Override
    public void setSchema(String string) throws SQLException {
        if (this._delegate == null) {
            this.schema = string;
        } else {
            this._delegate.setSchema(string);
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        if (this._delegate == null) {
            this.transactionIsolation = n;
        } else {
            this._delegate.setTransactionIsolation(n);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (this._delegate == null) {
            this.typeMap = map;
        } else {
            this._delegate.setTypeMap(map);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return this.getDelegate().unwrap(clazz);
    }

    private Statement doCreateStatement(ConnectionCallback<Statement> connectionCallback) throws SQLException {
        RequestContext requestContext = RequestContext.get();
        StartProfilingParams startProfilingParams = requestContext == null ? null : requestContext.getProfilingParams();
        ProfilingEntry profilingEntry = requestContext == null ? null : requestContext.getProfilingEntry();
        Statement statement = (Statement)connectionCallback.doInConnection(this.getDelegate());
        if (startProfilingParams != null && profilingEntry != null) {
            return new ProfilingStatement(startProfilingParams, profilingEntry, statement);
        }
        return statement;
    }

    private PreparedStatement doPrepareStatement(ConnectionCallback<PreparedStatement> connectionCallback, String string, boolean bl) throws SQLException {
        RequestContext requestContext = RequestContext.get();
        StartProfilingParams startProfilingParams = requestContext == null ? null : requestContext.getProfilingParams();
        ProfilingEntry profilingEntry = requestContext == null ? null : requestContext.getProfilingEntry();
        PreparedStatement preparedStatement = (PreparedStatement)connectionCallback.doInConnection(this.getDelegate());
        if (startProfilingParams != null && profilingEntry != null) {
            boolean bl2 = CachingConnection.isLowLevelQuery(string);
            if (bl && startProfilingParams.isIncludeCacheableQueries() || bl2 && startProfilingParams.isIncludeLowLevelQueries() || !bl && !bl2) {
                return new ProfilingPreparedStatement(startProfilingParams, profilingEntry, string, preparedStatement, bl, this.jsonConverter);
            }
        }
        return preparedStatement;
    }

    private CacheAction getCacheAction(String string) {
        try {
            int n;
            int n2;
            int n3 = string.length();
            for (n2 = 0; n2 < n3 - 1 && Character.isWhitespace(string.charAt(n2)); ++n2) {
            }
            for (n = n2; n < n3 - 1 && Character.isLetter(string.charAt(n)); ++n) {
            }
            String string2 = string.substring(n2, n).toLowerCase();
            String string3 = null;
            Boolean bl = null;
            switch (string2) {
                case "insert": {
                    int n4 = StringUtils.indexOfIgnoreCase((CharSequence)string, (CharSequence)"into", (int)n);
                    n2 = n4 + "into".length() + 1;
                    for (n = n2 + 1; n < n3 && CachingConnection.isTableNameCharacter(string.charAt(n)); ++n) {
                    }
                    string3 = string.substring(n2, n).trim();
                    bl = true;
                    break;
                }
                case "update": {
                    for (n2 = n + 1; n2 < n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
                    }
                    for (n = n2 + 1; n < n3 && CachingConnection.isTableNameCharacter(string.charAt(n)); ++n) {
                    }
                    string3 = string.substring(n2, n).trim();
                    bl = true;
                    break;
                }
                case "delete": {
                    int n5 = StringUtils.indexOfIgnoreCase((CharSequence)string, (CharSequence)"from", (int)n);
                    n2 = n5 + "from".length() + 1;
                    for (n = n2 + 1; n < n3 && CachingConnection.isTableNameCharacter(string.charAt(n)); ++n) {
                    }
                    string3 = string.substring(n2, n).trim();
                    bl = true;
                    break;
                }
                case "select": {
                    int n6 = StringUtils.indexOfIgnoreCase((CharSequence)string, (CharSequence)"/* table: ", (int)n);
                    if (n6 >= 0) {
                        int n7 = string.indexOf("*/", n6);
                        string3 = string.substring(n6 + "/* table: ".length(), n7).trim();
                    } else {
                        String string4;
                        int n8 = StringUtils.indexOfIgnoreCase((CharSequence)string, (CharSequence)" from ", (int)n);
                        n2 = n8 + " from ".length();
                        int n9 = StringUtils.indexOfIgnoreCase((CharSequence)string, (CharSequence)"where", (int)n8);
                        if (n9 >= 0) {
                            n = n9;
                        } else {
                            int n10 = StringUtils.indexOfIgnoreCase((CharSequence)string, (CharSequence)"order by", (int)n8);
                            if (n10 >= 0) {
                                n = n10;
                            } else {
                                int n11 = StringUtils.indexOfIgnoreCase((CharSequence)string, (CharSequence)"limit", (int)n8);
                                if (n11 >= 0) {
                                    n = n11;
                                } else {
                                    return null;
                                }
                            }
                        }
                        string3 = string.substring(n2, n).trim();
                        Matcher matcher = ALIAS_PATTERN.matcher(string3);
                        if (matcher.matches()) {
                            String string5 = matcher.group(2).toLowerCase();
                            if (ObjectHelper.isOneOf((Object)string5, (Object[])new Object[]{"left", "right", "join"})) {
                                return null;
                            }
                            string3 = string4 = matcher.group(1);
                        } else {
                            n3 = string3.length();
                            for (n = 0; n < n3 && CachingConnection.isTableNameCharacter(string3.charAt(n)); ++n) {
                            }
                            string4 = string3.substring(0, n);
                        }
                        if (string3.contains(",") || StringUtils.containsIgnoreCase((CharSequence)string3, (CharSequence)"join") || StringUtils.containsIgnoreCase((CharSequence)string.substring(n2), (CharSequence)"select")) {
                            if (this.metadata.isManyToManyCacheable(string4)) {
                                string3 = string4;
                            } else {
                                return null;
                            }
                        }
                    }
                    bl = false;
                }
            }
            if (bl == null || string3 == null || !this.metadata.isCacheable(string3)) {
                return null;
            }
            Object object = null;
            if (string3 != null) {
                object = new ArrayList();
                object.add(string3);
                List<String> list = this.metadata.getInverseDependencies(string3);
                if (list != null) {
                    object.addAll(list);
                }
            }
            return new CacheAction(Boolean.TRUE.equals(bl), (List<String>)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @FunctionalInterface
    public static interface ConnectionSupplier {
        public Connection get() throws SQLException;
    }

    public static class CacheAction {
        private final boolean clear;
        private final List<String> tables;

        private CacheAction(boolean bl, List<String> list) {
            this.clear = bl;
            this.tables = list;
        }

        public List<String> getTables() {
            return this.tables;
        }

        public boolean hasTables() {
            return CollectionHelper.isNotEmpty(this.tables);
        }

        public boolean isClearTableCache() {
            return this.hasTables() && this.clear;
        }

        public boolean isReadFromTableCache() {
            return this.hasTables() && !this.clear;
        }

        public boolean isWrite() {
            return this.clear;
        }

        public String toString() {
            if (this.hasTables()) {
                if (this.clear) {
                    return "Writing on db";
                }
                return "Reading from db";
            }
            if (this.clear) {
                return "Clear " + String.valueOf(this.tables);
            }
            return "Cache " + String.valueOf(this.tables);
        }
    }
}

