/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.mobile;

import java.util.function.Consumer;
import org.cyclos.entities.contentmanagement.BaseHelpContent;
import org.cyclos.entities.contentmanagement.BaseStaticContent;
import org.cyclos.entities.contentmanagement.HomeContent;
import org.cyclos.entities.contentmanagement.MobileHelpContent;
import org.cyclos.entities.contentmanagement.MobilePosHelpContent;
import org.cyclos.entities.contentmanagement.WelcomeContent;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.InternalUiServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.model.TranslatableUIElementResultVO;
import org.cyclos.model.TranslatableVersionedVO;
import org.cyclos.model.VersionedVO;
import org.cyclos.model.contentmanagement.BaseGetVersionedDataParams;
import org.cyclos.model.contentmanagement.GetMobileUserDataParams;
import org.cyclos.model.contentmanagement.GetVersionedDataParams;
import org.cyclos.model.contentmanagement.ThemeResultVO;

public class ContentHelper {
    private ConfigurationAccessor configuration;
    private TranslatableVersionedVO headerIf;
    private TranslatableVersionedVO footerIf;
    private VersionedVO themeIf;
    private TranslatableVersionedVO welcomePageIf;
    private TranslatableVersionedVO homePageIf;
    private TranslatableVersionedVO mobileHelpIf;
    private TranslatableVersionedVO posHelpIf;
    private String cyclosVersion;
    private boolean isLoggedIn;
    private InternalUiServiceLocal internalUiService;

    ContentHelper(BaseGetVersionedDataParams baseGetVersionedDataParams, SessionData sessionData, InternalUiServiceLocal internalUiServiceLocal) {
        if (baseGetVersionedDataParams instanceof GetVersionedDataParams) {
            GetVersionedDataParams getVersionedDataParams = (GetVersionedDataParams)baseGetVersionedDataParams;
            this.headerIf = getVersionedDataParams.getHeader();
            this.footerIf = getVersionedDataParams.getFooter();
            this.welcomePageIf = getVersionedDataParams.getWelcomePage();
        } else if (baseGetVersionedDataParams instanceof GetMobileUserDataParams) {
            GetMobileUserDataParams getMobileUserDataParams = (GetMobileUserDataParams)baseGetVersionedDataParams;
            this.homePageIf = getMobileUserDataParams.getHomePage();
            this.mobileHelpIf = getMobileUserDataParams.getMobileHelp();
            this.posHelpIf = getMobileUserDataParams.getPosHelp();
        }
        this.themeIf = baseGetVersionedDataParams.getTheme();
        this.cyclosVersion = baseGetVersionedDataParams.getCyclosVersion();
        this.internalUiService = internalUiServiceLocal;
        this.configuration = sessionData.getConfiguration();
        this.isLoggedIn = sessionData.isLoggedIn();
    }

    public ContentHelper setFooter(Consumer<TranslatableUIElementResultVO> consumer) {
        if (!this.isLoggedIn) {
            TranslatableUIElementResultVO translatableUIElementResultVO = this.internalUiService.toTranslatableUIElementResultVO((BaseStaticContent)this.configuration.getLoginFooterContent(), this.footerIf);
            consumer.accept(translatableUIElementResultVO);
        }
        return this;
    }

    public ContentHelper setHeader(Consumer<TranslatableUIElementResultVO> consumer) {
        if (!this.isLoggedIn) {
            TranslatableUIElementResultVO translatableUIElementResultVO = this.internalUiService.toTranslatableUIElementResultVO((BaseStaticContent)this.configuration.getLoginHeaderContent(), this.headerIf);
            consumer.accept(translatableUIElementResultVO);
        }
        return this;
    }

    public ContentHelper setHomePage(Consumer<TranslatableUIElementResultVO> consumer) {
        HomeContent homeContent;
        if (this.isLoggedIn && (homeContent = this.configuration.getHomeContent()) != null && homeContent.isEnabled()) {
            TranslatableUIElementResultVO translatableUIElementResultVO = this.internalUiService.toTranslatableUIElementResultVO((BaseStaticContent)homeContent, this.homePageIf);
            consumer.accept(translatableUIElementResultVO);
        }
        return this;
    }

    public ContentHelper setMobileHelp(Consumer<TranslatableUIElementResultVO> consumer) {
        MobileHelpContent mobileHelpContent = this.configuration.getMobileHelpContent();
        if (this.isLoggedIn && mobileHelpContent != null) {
            TranslatableUIElementResultVO translatableUIElementResultVO = this.internalUiService.toTranslatableUIElementResultVO((BaseHelpContent)mobileHelpContent, this.mobileHelpIf);
            consumer.accept(translatableUIElementResultVO);
        }
        return this;
    }

    public ContentHelper setPosHelp(Consumer<TranslatableUIElementResultVO> consumer) {
        MobilePosHelpContent mobilePosHelpContent = this.configuration.getMobilePosHelpContent();
        if (this.isLoggedIn && mobilePosHelpContent != null) {
            TranslatableUIElementResultVO translatableUIElementResultVO = this.internalUiService.toTranslatableUIElementResultVO((BaseHelpContent)mobilePosHelpContent, this.posHelpIf);
            consumer.accept(translatableUIElementResultVO);
        }
        return this;
    }

    public ContentHelper setTheme(Consumer<ThemeResultVO> consumer, boolean bl) {
        ThemeResultVO themeResultVO = this.internalUiService.toThemeResultVO(this.configuration.getMobileTheme(), bl, this.themeIf, this.cyclosVersion);
        consumer.accept(themeResultVO);
        return this;
    }

    public ContentHelper setWelcomePage(Consumer<TranslatableUIElementResultVO> consumer) {
        WelcomeContent welcomeContent;
        if (!this.isLoggedIn && (welcomeContent = this.configuration.getWelcomeContent()) != null && welcomeContent.isEnabled()) {
            TranslatableUIElementResultVO translatableUIElementResultVO = this.internalUiService.toTranslatableUIElementResultVO((BaseStaticContent)welcomeContent, this.welcomePageIf);
            consumer.accept(translatableUIElementResultVO);
        }
        return this;
    }
}

