/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentTransferTypeQuery;
import org.cyclos.impl.banking.PrepareValidationParameter;
import org.cyclos.impl.banking.TransactionValidationData;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.AbstractPaymentTypeData;
import org.cyclos.model.banking.transactions.BasePaymentPreviewVO;
import org.cyclos.model.banking.transactions.InstallmentStatus;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.banking.transactions.TransactionStatus;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.utils.Pair;

public interface TransactionServiceLocal
extends TransactionService {
    public static final String FOR_POS = "forPOS";
    public static final String ATTR_PERFORM_TRANSACTION = "performTransaction";
    public static final String ATTR_TRANSACTION = "transaction";
    public static final String ATTR_INSTALLMENT = "installment";
    public static final String ATTR_PREVIEW = "preview";
    public static final String ATTR_PAYMENT_TYPE = "paymentType";
    public static final String ATTR_FROM_ACCOUNT = "fromAccount";
    public static final String ATTR_TO_ACCOUNT = "toAccount";
    public static final String ATTR_FROM_OWNER = "fromOwner";
    public static final String ATTR_TO_OWNER = "toOwner";
    public static final String ATTR_FROM_OWNER_RESULT = "fromOwnerResult";
    public static final String ATTR_TO_OWNER_RESULT = "toOwnerResult";
    public static final String ATTR_AUTHORIZATION_TYPE = "authorizationType";
    public static final String ATTR_AUTHORIZATION_LEVEL = "authorizationLevel";
    public static final String ATTR_OLD_STATUS = "oldStatus";
    public static final String ATTR_NEW_STATUS = "newStatus";

    public OperatorVO convertToOperatorVO(Operator var1);

    public Pair<Integer, PaymentTransferType> countPaymentTypes(PaymentCreationType var1, PaymentTransferTypeQuery var2);

    public PaymentTransferType fill(AbstractPaymentTypeData var1, LocateAccountOwnerResult var2, LocateAccountOwnerResult var3, PaymentTransferType var4);

    public <D extends TransactionData> D fill(D var1, Transaction var2, boolean var3);

    public void fill(Transaction var1, TransferType var2, PaymentCreationType var3, Account var4, Account var5, BasicUser var6, String var7, String var8, BigDecimal var9, String var10, Collection<CustomFieldValueDTO> var11);

    public Transaction findByTransactionNumber(String var1);

    public Map<String, Object> getCustomFieldValidationBindings(LocateAccountOwnerResult var1, LocateAccountOwnerResult var2, PaymentTransferType var3);

    public TransactionData getData(Transaction var1, boolean var2);

    public Transaction getGeneratedBy(Transaction var1);

    public boolean isCheckConfirmation(PaymentTransferType var1, InternalAccountOwner var2, BigDecimal var3, Date var4);

    public List<PaymentTransferType> listPaymentTypes(LocateAccountOwnerResult var1, LocateAccountOwnerResult var2, Currency var3, boolean var4);

    public LocateAccountOwnerResult locateForPayment(InternalAccountOwner var1);

    public LocateAccountOwnerResult locateForReceiving(InternalAccountOwner var1);

    public <D extends TransactionData> D newData(Transaction var1, boolean var2);

    public void persist(Transaction var1);

    public TransactionValidationData prepareValidation(PrepareValidationParameter var1);

    public <T> T receive(InternalAccountOwner var1, Callable<T> var2);

    public PaymentTransferType resolvePaymentType(InternalAccountOwner var1, AccountOwner var2, Currency var3, Channel var4, PrincipalType var5, PaymentCreationType var6);

    public ExtensionPointAccessor setStatusAndGetExtensionPoint(Installment var1, InstallmentStatus var2);

    public <T extends Transaction, S extends TransactionStatus> ExtensionPointAccessor setStatusAndGetExtensionPoint(T var1, S var2);

    public void updatePreviewAndPayment(BasePaymentPreviewVO var1, PerformTransactionDTO var2, LocateAccountOwnerResult var3, LocateAccountOwnerResult var4, TransferType var5, SessionData var6);

    public void validateMinTimeBetweenPayments(LocateAccountOwnerResult var1, PaymentTransferType var2);

    public void validatePaymentAmount(LocateAccountOwnerResult var1, LocateAccountOwnerResult var2, PaymentTransferType var3, BigDecimal var4, Date var5);
}

