/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.util.HashMap;
import java.util.Map;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.ExternalAccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SingletonAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;

public class LocateAccountOwnerResult {
    private static final LocateAccountOwnerResult EMPTY = new LocateAccountOwnerResult();
    private static final LocateAccountOwnerResult SYSTEM = new LocateAccountOwnerResult((SingletonAccountOwner)SystemAccountOwner.instance());
    private static final LocateAccountOwnerResult EXTERNAL = new LocateAccountOwnerResult((SingletonAccountOwner)ExternalAccountOwner.instance());
    private AccountOwner accountOwner;
    private LocateUserResult locateUserResult;
    private PrincipalType principalType;
    private Map<AccountType, Account> locatedAccounts = new HashMap<AccountType, Account>();
    private AccountServiceLocal accountService_;
    private TransactionServiceLocal transactionService_;

    public static LocateAccountOwnerResult empty() {
        return EMPTY;
    }

    public static LocateAccountOwnerResult external() {
        return EXTERNAL;
    }

    public static LocateAccountOwnerResult instance(SingletonAccountOwner singletonAccountOwner) {
        if (singletonAccountOwner == null) {
            return EMPTY;
        }
        if (singletonAccountOwner instanceof SystemAccountOwner) {
            return SYSTEM;
        }
        if (singletonAccountOwner instanceof ExternalAccountOwner) {
            return EXTERNAL;
        }
        return new LocateAccountOwnerResult(singletonAccountOwner);
    }

    public static LocateAccountOwnerResult system() {
        return SYSTEM;
    }

    public LocateAccountOwnerResult(LocateUserResult locateUserResult) {
        this.accountOwner = locateUserResult.getBasicUser();
        this.locateUserResult = locateUserResult;
        this.principalType = locateUserResult.getPrincipalType();
        if (this.principalType == null) {
            this.principalType = InvocationContext.bean(PrincipalTypeServiceLocal.class).getUsername();
        }
    }

    private LocateAccountOwnerResult() {
    }

    private LocateAccountOwnerResult(SingletonAccountOwner singletonAccountOwner) {
        this.accountOwner = singletonAccountOwner;
    }

    public UserAccount getAccount() {
        if (this.locateUserResult != null) {
            return (UserAccount)this.getAccount((AccountType)this.locateUserResult.getAccountType());
        }
        return null;
    }

    public Account getAccount(AccountType accountType) {
        if (this.locatedAccounts.containsKey(accountType)) {
            return this.locatedAccounts.get(accountType);
        }
        try {
            Object a = this.getAccountService().load(this.getInternalAccountOwner(), accountType);
            this.locatedAccounts.put(accountType, (Account)a);
            return a;
        }
        catch (EntityNotFoundException entityNotFoundException) {
            this.locatedAccounts.put(accountType, null);
            return null;
        }
    }

    public AccountOwner getAccountOwner() {
        return this.isOperator() ? ((Operator)this.accountOwner).getUser() : this.accountOwner;
    }

    public BasicUser getBasicUser() {
        return this.accountOwner instanceof BasicUser ? (BasicUser)this.accountOwner : null;
    }

    public InternalAccountOwner getInternalAccountOwner() {
        AccountOwner accountOwner = this.getAccountOwner();
        return (InternalAccountOwner)(accountOwner instanceof InternalAccountOwner ? accountOwner : null);
    }

    public InternalAccountOwner getInternalVO() {
        AccountOwner accountOwner = this.getVO();
        if (accountOwner instanceof InternalAccountOwner) {
            return (InternalAccountOwner)accountOwner;
        }
        return null;
    }

    public LocateUserResult getLocateUserResult() {
        return this.locateUserResult;
    }

    public Operator getOperator() {
        BasicUser basicUser = this.getBasicUser();
        if (basicUser instanceof Operator) {
            return (Operator)basicUser;
        }
        return null;
    }

    public PrincipalType getPrincipalType() {
        return this.principalType;
    }

    public User getUser() {
        BasicUser basicUser = this.getBasicUser();
        return basicUser == null ? null : basicUser.getUser();
    }

    public AccountOwner getVO() {
        if (this.accountOwner instanceof SingletonAccountOwner) {
            return this.accountOwner;
        }
        ConversionHandler conversionHandler = InvocationContext.bean(ConversionHandler.class);
        if (this.locateUserResult != null) {
            OperatorVO operatorVO = this.isOperator() ? this.getTransactionService().convertToOperatorVO((Operator)this.accountOwner) : conversionHandler.convert(BasicUserVO.class, this.accountOwner);
            operatorVO.setLocator((UserLocatorVO)this.locateUserResult.getLocator());
            return operatorVO;
        }
        if (this.accountOwner instanceof User) {
            return (AccountOwner)conversionHandler.convert(UserVO.class, this.accountOwner);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.accountOwner == null;
    }

    public boolean isExternal() {
        return this.accountOwner instanceof ExternalAccountOwner;
    }

    public boolean isOperator() {
        return this.accountOwner instanceof Operator;
    }

    public boolean isSystem() {
        return this.accountOwner instanceof SystemAccountOwner;
    }

    public boolean isUser() {
        return this.accountOwner instanceof IUser;
    }

    private AccountServiceLocal getAccountService() {
        if (this.accountService_ == null) {
            this.accountService_ = InvocationContext.bean(AccountServiceLocal.class);
        }
        return this.accountService_;
    }

    private TransactionServiceLocal getTransactionService() {
        if (this.transactionService_ == null) {
            this.transactionService_ = InvocationContext.bean(TransactionServiceLocal.class);
        }
        return this.transactionService_;
    }
}

