/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ChannelSettingsAccessor;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.impl.access.AbstractSessionData;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.SessionDataSubjectId;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.model.access.InvalidSessionDataException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.login.UserAuthVO;

public class ScriptSessionData
extends AbstractSessionData {
    private SessionData delegate;
    private SessionData permissionsDelegate;

    ScriptSessionData(SessionData sessionData, boolean bl) {
        super(sessionData.getRequestData());
        this.delegate = sessionData;
        this.permissionsDelegate = bl ? SessionDataFactory.system(sessionData.getRequestData(), sessionData.getChannelName()) : sessionData;
    }

    @Override
    public void checkConsistency() throws InvalidSessionDataException {
        this.delegate.checkConsistency();
    }

    @Override
    public String getAccessChannelName() {
        return this.delegate.getAccessChannelName();
    }

    @Override
    public AccessClient getAccessClient() {
        return this.delegate.getAccessClient();
    }

    @Override
    public Set<BasicGroup> getAccessibleBasicGroups() {
        return this.permissionsDelegate.getAccessibleBasicGroups();
    }

    @Override
    public OidcAccessToken getAccessToken() {
        return this.delegate.getAccessToken();
    }

    @Override
    public UserAuthVO getAuthenticatedUser() {
        return this.delegate.getAuthenticatedUser();
    }

    @Override
    public BasicUser getBasicUser() {
        return this.delegate.getBasicUser();
    }

    @Override
    public ChannelAccessAccessor getChannelAccessAccessor() {
        return this.delegate.getChannelAccessAccessor();
    }

    @Override
    public String getChannelName() {
        return this.delegate.getChannelName();
    }

    @Override
    public ChannelSettingsAccessor getChannelSettingsAccessor() {
        return this.delegate.getChannelSettingsAccessor();
    }

    public SessionData getDelegate() {
        return this.delegate;
    }

    @Override
    public Group getGroup() {
        return this.delegate.getGroup();
    }

    @Override
    public BasicUser getLoggedBasicUser() {
        return this.delegate.getLoggedBasicUser();
    }

    @Override
    public Pin getPin() {
        return this.delegate.getPin();
    }

    @Override
    public String getPrincipal() {
        return this.delegate.getPrincipal();
    }

    @Override
    public PrincipalType getPrincipalType() {
        return this.delegate.getPrincipalType();
    }

    @Override
    public String getRemoteAddress() {
        return this.delegate.getRemoteAddress();
    }

    @Override
    public Session getSession() {
        return this.delegate.getSession();
    }

    @Override
    public SessionDataSubjectId getSubjectId() {
        return this.delegate.getSubjectId();
    }

    @Override
    public Token getToken() {
        return this.delegate.getToken();
    }

    @Override
    public TrustedDevice getTrustedDevice() {
        return this.delegate.getTrustedDevice();
    }

    @Override
    public boolean hasRequiredValue(Permission permission, Object object) {
        return this.permissionsDelegate.hasRequiredValue(permission, object);
    }

    @Override
    public boolean isAdmin() {
        return this.delegate.isAdmin();
    }

    @Override
    public boolean isAdminOf(BasicUser basicUser) {
        return this.delegate.isAdminOf(basicUser);
    }

    @Override
    public boolean isAliasOperator() {
        return this.delegate.isAliasOperator();
    }

    @Override
    public boolean isBroker() {
        return this.delegate.isBroker();
    }

    @Override
    public boolean isBrokerOf(BasicUser basicUser) {
        return this.delegate.isBrokerOf(basicUser);
    }

    @Override
    public boolean isGlobalAdmin() {
        return this.delegate.isGlobalAdmin();
    }

    @Override
    public boolean isGlobalAdminInNetwork() {
        return this.delegate.isGlobalAdminInNetwork();
    }

    @Override
    public boolean isGuest() {
        return this.delegate.isGuest();
    }

    @Override
    public boolean isLoggedIn() {
        return this.delegate.isLoggedIn();
    }

    @Override
    public boolean isManagerOf(BasicUser basicUser) {
        return this.delegate.isManagerOf(basicUser);
    }

    @Override
    public boolean isMember() {
        return this.delegate.isMember();
    }

    @Override
    public boolean isMemberOnly() {
        return this.delegate.isMemberOnly();
    }

    @Override
    public boolean isNetworkAdmin() {
        return this.delegate.isNetworkAdmin();
    }

    @Override
    public boolean isOperator() {
        return this.delegate.isOperator();
    }

    @Override
    public boolean isOwnerOf(BasicUser basicUser) {
        return this.delegate.isOwnerOf(basicUser);
    }

    @Override
    public boolean isRestrictedOperator() {
        return this.delegate.isRestrictedOperator();
    }

    @Override
    public boolean isScript() {
        return true;
    }

    @Override
    public boolean isSystem() {
        return this.delegate.isSystem() || this.permissionsDelegate.isSystem();
    }

    @Override
    public boolean isUserManager() {
        return this.delegate.isUserManager();
    }

    @Override
    public boolean isVisible(EntityCheck<SimpleEntity> entityCheck, SimpleEntity simpleEntity) {
        return this.permissionsDelegate.isVisible(entityCheck, simpleEntity);
    }

    @Override
    public boolean manages(BasicUser basicUser) {
        return this.permissionsDelegate.manages(basicUser);
    }

    @Override
    public boolean relatesTo(BasicUser basicUser) {
        return this.permissionsDelegate.relatesTo(basicUser);
    }

    @Override
    public SessionData unwrap() {
        return this.delegate;
    }

    @Override
    protected Long doGetConfigurationId() {
        return this.delegate.getConfiguration().getConfiguration().getId();
    }

    @Override
    protected List<String> doGetPreferredLocales() {
        if (this.delegate instanceof AbstractSessionData) {
            return ((AbstractSessionData)this.delegate).doGetPreferredLocales();
        }
        return Collections.emptyList();
    }

    @Override
    protected ProductsAccessor doGetProducts() {
        return this.permissionsDelegate.getProducts();
    }

    @Override
    protected SessionDataSubjectId doGetSubjectId() {
        return this.permissionsDelegate.getSubjectId();
    }

    @Override
    protected boolean doHasPermission(Permission permission) {
        return this.permissionsDelegate.hasPermission(permission);
    }
}

