/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.archive.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Page<T> {
    public static final int DEFAULT_PAGE_SIZE = 40;
    private List<T> pageItems = Collections.emptyList();
    private int currentPage;
    private int pageSize;
    private Long totalCount;
    private boolean hasNextPage;

    public static <I, T> Page<T> page(T t) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.add(t);
        Page<T> page = new Page<T>();
        page.setPageItems(arrayList);
        page.setCurrentPage(0);
        page.setPageSize(1);
        page.setTotalCount(1L);
        page.setHasNextPage(false);
        return page;
    }

    public static <I, T> Page<T> transformed(Page<I> page, Function<I, T> function) {
        Page page2 = new Page();
        page2.setPageItems(page.stream().map(function).collect(Collectors.toList()));
        page2.setCurrentPage(page.getCurrentPage());
        page2.setPageSize(page.getPageSize());
        page2.setTotalCount(page.getTotalCount());
        page2.setHasNextPage(page.isHasNextPage());
        return page2;
    }

    protected static int getPageCount(int n, long l) {
        return n == 0 ? 0 : (int)Math.ceil((double)l / (double)n);
    }

    protected Page() {
    }

    public void fill(List<T> list, int n, int n2, Long l) {
        boolean bl = l == null ? list != null && list.size() > n : l > (long)(n * (n2 + 1));
        this.setPageItems(list == null ? null : list.subList(0, Math.min(list.size(), n)));
        this.setPageSize(n);
        this.setCurrentPage(n2);
        this.setTotalCount(l);
        this.setHasNextPage(bl);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public Integer getPageCount() {
        return this.totalCount == null ? null : Integer.valueOf(Page.getPageCount(this.pageSize, this.totalCount));
    }

    public List<T> getPageItems() {
        return this.pageItems;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public Iterator<T> iterator() {
        return this.pageItems == null ? Collections.emptyList().iterator() : this.pageItems.iterator();
    }

    public void setCurrentPage(int n) {
        Integer n2 = this.getPageCount();
        this.currentPage = n2 == null ? n : Math.min(n, n2);
    }

    public void setHasNextPage(boolean bl) {
        this.hasNextPage = bl;
    }

    public void setPageItems(List<T> list) {
        this.pageItems = list;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public void setTotalCount(Long l) {
        this.totalCount = l;
    }

    public Stream<T> stream() {
        return this.pageItems == null ? Collections.emptyList().stream() : this.pageItems.stream();
    }

    public String toString() {
        return "Page [pageItems=" + this.pageItems + ", currentPage=" + this.currentPage + ", pageSize=" + this.pageSize + ", totalCount=" + this.totalCount + ", hasNextPage=" + this.hasNextPage + "]";
    }
}

