/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import com.googlecode.pngtastic.core.PngChunk;
import com.googlecode.pngtastic.core.PngImage;
import com.googlecode.pngtastic.core.PngOptimizer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclos.model.EntityVO;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.contentmanagement.themes.ThemeImageType;
import org.cyclos.model.contentmanagement.themes.ThemeImageVO;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.configurations.ConfigurationImageVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.web.util.UriComponentsBuilder;

public class ServerImageHelper {
    public static final IOFileFilter FILE_CONTENT_FILTER = new AbstractFileFilter(){

        public boolean accept(File file) {
            try {
                ImageType.getByContent(file);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    };
    private static final ImageWriterSpi JPEG_IMAGE_WRITER_SPI;
    private static final byte[] GIF_SIGNATURE;
    private static final byte[] JPEG_SIGNATURE;
    private static final byte[] PNG_SIGNATURE;
    private static final byte[] WEBP_SIGNATURE;
    private static final Object[] PRESET_POINTS;

    public static Dimension getActualSize(Dimension dimension, Integer n, Integer n2) {
        int n3;
        int n4;
        int n5 = (int)dimension.getWidth();
        int n6 = (int)dimension.getHeight();
        if (n == null && n2 == null) {
            n4 = n5;
            n3 = n6;
        } else {
            if (n == null) {
                n = (int)((double)n2.intValue() * ((double)n5 / (double)n6));
            } else if (n2 == null) {
                n2 = (int)((double)n.intValue() / ((double)n5 / (double)n6));
            }
            Dimension dimension2 = ServerImageHelper.thumbnailSize(dimension, new Dimension(n, n2));
            n4 = (int)dimension2.getWidth();
            n3 = (int)dimension2.getHeight();
        }
        return new Dimension(n4, n3);
    }

    public static String getConfigurationImageUrl(RequestData requestData, ConfigurationImageVO configurationImageVO, String string) {
        String string2 = (String)ObjectHelper.defaultValue((Object)configurationImageVO.getLastModifiedInMillis(), (Object)string);
        if (string2 == null) {
            string2 = string;
        }
        StringBuilder stringBuilder = new StringBuilder(StringHelper.removeEnd((String)requestData.getBaseUrl(), (String)"/"));
        stringBuilder.append("/content/images");
        Long l = EntityVO.id((EntityVO)configurationImageVO.getConfiguration());
        if (l == null) {
            stringBuilder.append("/configurationDefault");
        } else {
            stringBuilder.append("/configuration/").append(l);
        }
        stringBuilder.append('/').append(configurationImageVO.getType()).append("?mod=").append(string2);
        return stringBuilder.toString();
    }

    public static BufferedImage gradient(int n, int n2, Color[] colorArray) {
        return ServerImageHelper.gradient(n, n2, colorArray, null);
    }

    public static BufferedImage gradient(int n, int n2, Color[] colorArray, float[] fArray) {
        if (CollectionHelper.isEmpty((Object[])colorArray) || fArray != null && colorArray.length != fArray.length) {
            return null;
        }
        if (fArray == null) {
            int n3 = colorArray.length;
            fArray = n3 <= PRESET_POINTS.length ? (float[])PRESET_POINTS[n3 - 1] : ServerImageHelper.gradientPoints(n3);
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, n2, fArray, colorArray));
        graphics2D.fillRect(0, 0, n, n2);
        return bufferedImage;
    }

    public static URI imageURI(ImageVO imageVO, RequestData requestData, String string) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)requestData.getApiUrl());
        if (imageVO instanceof ConfigurationImageVO) {
            ConfigurationImageVO configurationImageVO = (ConfigurationImageVO)imageVO;
            String string2 = (String)ObjectHelper.defaultValue((Object)configurationImageVO.getLastModifiedInMillis(), (Object)string);
            String string3 = ModelHelper.stringOrIdFromVO((EntityVO)configurationImageVO.getConfiguration());
            uriComponentsBuilder.pathSegment(new String[]{"logos"});
            if (string3 != null) {
                uriComponentsBuilder.pathSegment(new String[]{string3});
            }
            uriComponentsBuilder.pathSegment(new String[]{ServerImageHelper.toLogoKind(configurationImageVO.getType())});
            uriComponentsBuilder.queryParam("mod", new Object[]{string2});
        } else if (imageVO instanceof ThemeImageVO) {
            ThemeImageVO themeImageVO = (ThemeImageVO)imageVO;
            String string4 = ModelHelper.stringOrIdFromVO((EntityVO)themeImageVO.getTheme());
            String string5 = ServerImageHelper.toThemeImageKind(themeImageVO.getType());
            uriComponentsBuilder.pathSegment(new String[]{"themes"});
            if (string4 != null) {
                uriComponentsBuilder.pathSegment(new String[]{string4});
            }
            uriComponentsBuilder.pathSegment(new String[]{"images", string5, themeImageVO.getName()});
        } else if (imageVO != null && imageVO.getKey() != null) {
            uriComponentsBuilder.pathSegment(new String[]{"images", "content", imageVO.getKey()});
        } else {
            return null;
        }
        return uriComponentsBuilder.build().toUri();
    }

    public static Dimension rescaleKeepingProportions(Dimension dimension, Dimension dimension2, @Nullable Dimension dimension3) {
        int n;
        int n2;
        int n3 = (int)dimension.getWidth();
        int n4 = (int)dimension.getHeight();
        int n5 = (int)dimension2.getHeight();
        int n6 = (int)dimension2.getWidth();
        double d = (double)n3 / (double)n4;
        if (n6 == n3 || n5 == n4) {
            return dimension;
        }
        if (dimension3 != null) {
            n2 = (int)dimension3.getHeight();
            n = (int)dimension3.getWidth();
            if (n5 > n2 || n6 > n) {
                if (n6 != 0 && n5 != 0) {
                    dimension2 = ServerImageHelper.thumbnailSize(dimension2, dimension3);
                    n5 = (int)dimension2.getHeight();
                    n6 = (int)dimension2.getWidth();
                } else if (n6 != 0) {
                    n6 = n;
                } else {
                    n5 = n2;
                }
            }
        }
        if (n6 <= 0 && n5 <= 0) {
            n2 = n4;
            n = n3;
        } else if (d > 1.0) {
            if (n5 > 0) {
                int n7;
                n6 = (int)((double)n5 * d);
                if (dimension3 != null && n6 > (n7 = (int)dimension3.getWidth())) {
                    n6 = n7;
                }
            }
            n = n6;
            n2 = (int)((double)n / d);
        } else {
            if (n6 > 0) {
                int n8;
                n5 = (int)((double)n6 / d);
                if (dimension3 != null && n5 > (n8 = (int)dimension3.getHeight())) {
                    n5 = n8;
                }
            }
            n2 = n5;
            n = (int)((double)n2 * d);
        }
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        return new Dimension(n, n2);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, Dimension dimension) {
        Dimension dimension2 = ServerImageHelper.thumbnailSize(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()), dimension);
        return ServerImageHelper.resize(bufferedImage, (int)dimension2.getWidth(), (int)dimension2.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage resize(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage == null) {
            return null;
        }
        Image image = bufferedImage.getScaledInstance(n, n2, 4);
        int n3 = bufferedImage.getColorModel().hasAlpha() ? 2 : 1;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.drawImage(image, 0, 0, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public static Dimension thumbnailSize(Dimension dimension, Dimension dimension2) {
        int n;
        int n2;
        int n3 = (int)dimension.getWidth();
        int n4 = (int)dimension.getHeight();
        int n5 = (int)dimension2.getHeight();
        int n6 = (int)dimension2.getWidth();
        if (n6 >= n3 && n5 >= n4) {
            return dimension;
        }
        double d = (double)n3 / (double)n4;
        if (n6 <= 0 && n5 <= 0) {
            n2 = n4;
            n = n3;
        } else if (d > 1.0) {
            if (n5 > 0) {
                n6 = n6 == 0 ? (int)((double)n5 * d) : Math.min(n6, (int)((double)n5 * d));
            }
            n = n6;
            n2 = (int)((double)n / d);
        } else {
            if (n6 > 0) {
                n5 = n5 == 0 ? (int)((double)n6 / d) : Math.min(n5, (int)((double)n6 / d));
            }
            n2 = n5;
            n = (int)((double)n2 * d);
        }
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        return new Dimension(n, n2);
    }

    public static byte[] toBytes(BufferedImage bufferedImage, ImageType imageType, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        try {
            ServerImageHelper.write(bufferedImage, imageType, (OutputStream)byteArrayOutputStream, n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String toLogoKind(ConfigurationImageType configurationImageType) {
        if (configurationImageType != null) {
            switch (configurationImageType) {
                case APP_LOGO: {
                    return "frontend";
                }
                case MASKABLE_LOGO: {
                    return "maskable";
                }
                case MOBILE_LOGO: {
                    return "mobile";
                }
                case PAY_LOGO: {
                    return "pay";
                }
                case REPORTS_LOGO: {
                    return "report";
                }
                case SHORTCUT_ICON: {
                    return "classicShortcut";
                }
                case SYSTEM_LOGO: {
                    return "classic";
                }
            }
        }
        return null;
    }

    public static String toThemeImageKind(ThemeImageType themeImageType) {
        if (themeImageType != null) {
            switch (themeImageType) {
                case BACKGROUND: {
                    return "background";
                }
                case CUSTOM: {
                    return "custom";
                }
                case MAP_MARKER: {
                    return "mapMarker";
                }
                case MOBILE: {
                    return "mobile";
                }
            }
        }
        return null;
    }

    public static void write(BufferedImage bufferedImage, ImageType imageType, File file, int n) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ServerImageHelper.write(bufferedImage, imageType, fileOutputStream, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void write(BufferedImage var0, ImageType var1_1, OutputStream var2_2, int var3_3) throws IOException {
        if (var0 == null) {
            return;
        }
        switch (var1_1.ordinal()) {
            case 1: {
                var4_4 = ServerImageHelper.JPEG_IMAGE_WRITER_SPI.createWriterInstance();
                var5_5 = new JPEGImageWriteParam(null);
                var5_5.setCompressionMode(2);
                var5_5.setCompressionQuality((float)var3_3 / 100.0f);
                var4_4.setOutput(new MemoryCacheImageOutputStream(var2_2));
                if (!ServerImageHelper.hasAlpha(var0)) ** GOTO lbl25
                var6_6 = var0.getWidth();
                var7_8 = var0.getHeight();
                var8_10 = new BufferedImage(var6_6, var7_8, 1);
                var9_11 = var8_10.createGraphics();
                try {
                    var9_11.setBackground(Color.WHITE);
                    var9_11.clearRect(0, 0, var6_6, var7_8);
                    var9_11.drawImage((Image)var0, 0, 0, null);
                }
                finally {
                    var9_11.dispose();
                }
                var0 = var8_10;
lbl25:
                // 2 sources

                var4_4.write(null, new IIOImage(var0, null, null), var5_5);
                break;
            }
            case 2: {
                if (var3_3 > 50) {
                    var6_7 = new ByteArrayOutputStream(2048);
                    ImageIO.write((RenderedImage)var0, var1_1.getExtension(), (OutputStream)var6_7);
                    var7_9 = new PngImage((InputStream)new ByteArrayInputStream(var6_7.toByteArray()));
                    var7_9 = ServerImageHelper.optimizePng(var7_9);
                    ServerImageHelper.writePngImage(var7_9, var2_2);
                    break;
                }
                ImageIO.write((RenderedImage)var0, var1_1.getExtension(), var2_2);
                break;
            }
            case 0: 
            case 3: {
                ImageIO.write((RenderedImage)var0, var1_1.getExtension(), var2_2);
            }
        }
    }

    private static float[] gradientPoints(int n) {
        float[] fArray = new float[n];
        float f = 1.0f / (float)n;
        for (int i = 0; i < n; ++i) {
            float f2 = i == 0 ? 0.0f : (i == n - 1 ? 1.0f : (float)i * f);
            fArray[i] = f2;
        }
        return fArray;
    }

    private static boolean hasAlpha(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    private static PngImage optimizePng(PngImage pngImage) throws IOException {
        return new PngOptimizer().optimize(pngImage, Integer.valueOf(9));
    }

    private static void writePngImage(PngImage pngImage, OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeLong(-8552249625308161526L);
        for (PngChunk pngChunk : pngImage.getChunks()) {
            dataOutputStream.writeInt(pngChunk.getLength());
            dataOutputStream.write(pngChunk.getType());
            dataOutputStream.write(pngChunk.getData());
            dataOutputStream.writeInt((int)pngChunk.getCRC());
        }
    }

    static {
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        Iterator<ImageWriterSpi> iterator = iIORegistry.getServiceProviders(ImageWriterSpi.class, object -> {
            if (object instanceof ImageWriterSpi) {
                ImageWriterSpi imageWriterSpi = (ImageWriterSpi)object;
                for (String string : imageWriterSpi.getFormatNames()) {
                    if (!string.equalsIgnoreCase("jpeg")) continue;
                    return true;
                }
            }
            return false;
        }, true);
        JPEG_IMAGE_WRITER_SPI = iterator.hasNext() ? iterator.next() : null;
        GIF_SIGNATURE = new byte[]{71, 73, 70};
        JPEG_SIGNATURE = new byte[]{-1, -40, -1};
        PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        WEBP_SIGNATURE = new byte[]{82, 73, 70, 70, 0, 0, 87, 69, 66, 80};
        PRESET_POINTS = new Object[10];
        for (int i = 0; i < PRESET_POINTS.length; ++i) {
            ServerImageHelper.PRESET_POINTS[i] = ServerImageHelper.gradientPoints(i + 1);
        }
    }

    public static enum ImageType {
        GIF(GIF_SIGNATURE, new String[]{"image/gif"}, new String[]{"gif"}),
        JPEG(JPEG_SIGNATURE, new String[]{"image/jpeg", "image/pjpeg"}, new String[]{"jpeg", "jpg"}),
        PNG(PNG_SIGNATURE, new String[]{"image/png", "image/x-png"}, new String[]{"png"}),
        WEBP(WEBP_SIGNATURE, new String[]{"image/webp"}, new String[]{"webp"});

        private final byte[] signature;
        private final String[] contentTypes;
        private final String[] extensions;

        public static ImageType getByContent(byte[] byArray) throws IllegalArgumentException {
            for (ImageType imageType : ImageType.values()) {
                byte[] byArray2 = imageType.getSignature();
                if (byArray2 == null || byArray.length < byArray2.length) continue;
                boolean bl = true;
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] <= 0 || byArray2[i] == byArray[i]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return imageType;
            }
            throw new IllegalArgumentException("Unknown image type");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ImageType getByContent(File file) throws IOException, IllegalArgumentException {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                byte[] byArray = new byte[10];
                fileInputStream.read(byArray);
                ImageType imageType = ImageType.getByContent(byArray);
                return imageType;
            }
        }

        public static ImageType getByContentType(String string) throws IllegalArgumentException {
            for (ImageType imageType : ImageType.values()) {
                List<String> list = Arrays.asList(imageType.contentTypes);
                if (!list.contains(string)) continue;
                return imageType;
            }
            throw new IllegalArgumentException("Unknown image type");
        }

        public static ImageType getByFileName(String string) throws IllegalArgumentException {
            String string2 = FilenameUtils.getExtension((String)string).toLowerCase();
            for (ImageType imageType : ImageType.values()) {
                if (!ArrayUtils.contains((Object[])imageType.extensions, (Object)string2)) continue;
                return imageType;
            }
            throw new IllegalArgumentException("Unknown image type");
        }

        public static boolean hasImageExtension(String string) {
            String string2 = FilenameUtils.getExtension((String)string).toLowerCase();
            if (!string2.isEmpty()) {
                for (ImageType imageType : ImageType.values()) {
                    if (!ArrayUtils.contains((Object[])imageType.extensions, (Object)string2)) continue;
                    return true;
                }
            }
            return false;
        }

        private ImageType(byte[] byArray, String[] stringArray, String[] stringArray2) {
            this.signature = byArray;
            this.contentTypes = stringArray;
            this.extensions = stringArray2;
        }

        public String getContentType() {
            return this.contentTypes[0];
        }

        public String[] getContentTypes() {
            return this.contentTypes;
        }

        public String getExtension() {
            return this.extensions[0];
        }

        public String[] getExtensions() {
            return this.extensions;
        }

        public byte[] getSignature() {
            return this.signature;
        }
    }
}

