/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils.springframework.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.annotation.Nullable;
import nl.basjes.parse.useragent.utils.springframework.core.NativeDetector;
import nl.basjes.parse.useragent.utils.springframework.util.ConcurrentReferenceHashMap;
import nl.basjes.parse.useragent.utils.springframework.util.ObjectUtils;
import nl.basjes.parse.useragent.utils.springframework.util.ReflectionUtils;

final class SerializableTypeWrapper {
    private static final Class<?>[] SUPPORTED_SERIALIZABLE_TYPES = new Class[]{GenericArrayType.class, ParameterizedType.class, TypeVariable.class, WildcardType.class};
    static final ConcurrentReferenceHashMap<Type, Type> CACHE = new ConcurrentReferenceHashMap(256);

    private SerializableTypeWrapper() {
    }

    public static <T extends Type> T unwrap(T type) {
        Type unwrapped = null;
        if (type instanceof SerializableTypeProxy) {
            unwrapped = ((SerializableTypeProxy)((Object)type)).getTypeProvider().getType();
        }
        return (T)(unwrapped != null ? unwrapped : (Type)type);
    }

    @Nullable
    static Type forTypeProvider(TypeProvider provider) {
        Type providedType = provider.getType();
        if (providedType == null || providedType instanceof Serializable) {
            return providedType;
        }
        if (NativeDetector.inNativeImage() || !Serializable.class.isAssignableFrom(Class.class)) {
            return providedType;
        }
        Type cached = CACHE.get(providedType);
        if (cached != null) {
            return cached;
        }
        for (Class<?> type : SUPPORTED_SERIALIZABLE_TYPES) {
            if (!type.isInstance(providedType)) continue;
            ClassLoader classLoader = provider.getClass().getClassLoader();
            Class[] interfaces = new Class[]{type, SerializableTypeProxy.class, Serializable.class};
            TypeProxyInvocationHandler handler = new TypeProxyInvocationHandler(provider);
            cached = (Type)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
            CACHE.put(providedType, cached);
            return cached;
        }
        throw new IllegalArgumentException("Unsupported Type class: " + providedType.getClass().getName());
    }

    static interface SerializableTypeProxy {
        public TypeProvider getTypeProvider();
    }

    static interface TypeProvider
    extends Serializable {
        @Nullable
        public Type getType();
    }

    private static class TypeProxyInvocationHandler
    implements InvocationHandler,
    Serializable {
        private final TypeProvider provider;

        TypeProxyInvocationHandler(TypeProvider provider) {
            this.provider = provider;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "equals": {
                    Object other = args[0];
                    if (other instanceof Type) {
                        other = SerializableTypeWrapper.unwrap((Type)other);
                    }
                    return ObjectUtils.nullSafeEquals(this.provider.getType(), other);
                }
                case "hashCode": {
                    return ObjectUtils.nullSafeHashCode(this.provider.getType());
                }
                case "getTypeProvider": {
                    return this.provider;
                }
            }
            if (Type.class == method.getReturnType() && ObjectUtils.isEmpty(args)) {
                return SerializableTypeWrapper.forTypeProvider(new MethodInvokeTypeProvider(this.provider, method, -1));
            }
            if (Type[].class == method.getReturnType() && ObjectUtils.isEmpty(args)) {
                Type[] result = new Type[((Type[])method.invoke((Object)this.provider.getType(), new Object[0])).length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = SerializableTypeWrapper.forTypeProvider(new MethodInvokeTypeProvider(this.provider, method, i));
                }
                return result;
            }
            try {
                return method.invoke((Object)this.provider.getType(), args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    static class MethodInvokeTypeProvider
    implements TypeProvider {
        private final TypeProvider provider;
        private final String methodName;
        private final Class<?> declaringClass;
        private final int index;
        private transient Method method;
        @Nullable
        private volatile transient Object result;

        MethodInvokeTypeProvider(TypeProvider provider, Method method, int index) {
            this.provider = provider;
            this.methodName = method.getName();
            this.declaringClass = method.getDeclaringClass();
            this.index = index;
            this.method = method;
        }

        @Override
        @Nullable
        public Type getType() {
            Object resulT = this.result;
            if (resulT == null) {
                this.result = resulT = ReflectionUtils.invokeMethod(this.method, this.provider.getType());
            }
            return resulT instanceof Type[] ? ((Type[])resulT)[this.index] : (Type)resulT;
        }

        private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
            inputStream.defaultReadObject();
            Method methoD = ReflectionUtils.findMethod(this.declaringClass, this.methodName);
            if (methoD == null) {
                throw new IllegalStateException("Cannot find method on deserialization: " + this.methodName);
            }
            if (methoD.getReturnType() != Type.class && methoD.getReturnType() != Type[].class) {
                throw new IllegalStateException("Invalid return type on deserialized method - needs to be Type or Type[]: " + methoD);
            }
            this.method = methoD;
        }
    }
}

