/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.ReflectiveMethodResolver;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.spring5.expression.IThymeleafEvaluationContext;
import org.thymeleaf.spring5.expression.SPELContextPropertyAccessor;
import org.thymeleaf.util.ExpressionUtils;
import org.thymeleaf.util.Validate;

public final class ThymeleafEvaluationContext
extends StandardEvaluationContext
implements IThymeleafEvaluationContext {
    public static final String THYMELEAF_EVALUATION_CONTEXT_CONTEXT_VARIABLE_NAME = "thymeleaf::EvaluationContext";
    private static final ReflectivePropertyAccessor REFLECTIVE_PROPERTY_ACCESSOR_INSTANCE = new ThymeleafEvaluationContextACLPropertyAccessor();
    private static final MapAccessor MAP_ACCESSOR_INSTANCE = new MapAccessor();
    private static final TypeLocator TYPE_LOCATOR = new ThymeleafEvaluationContextACLTypeLocator();
    private static final List<MethodResolver> METHOD_RESOLVERS = Collections.singletonList(new ThymeleafEvaluationContextACLMethodResolver());
    private final ApplicationContext applicationContext;
    private IExpressionObjects expressionObjects = null;
    private boolean variableAccessRestricted = false;

    public ThymeleafEvaluationContext(ApplicationContext applicationContext, ConversionService conversionService) {
        Validate.notNull((Object)applicationContext, (String)"Application Context cannot be null");
        this.applicationContext = applicationContext;
        this.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        if (conversionService != null) {
            this.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
        }
        ArrayList<SPELContextPropertyAccessor> propertyAccessors = new ArrayList<SPELContextPropertyAccessor>(5);
        propertyAccessors.add(SPELContextPropertyAccessor.INSTANCE);
        propertyAccessors.add((SPELContextPropertyAccessor)MAP_ACCESSOR_INSTANCE);
        propertyAccessors.add((SPELContextPropertyAccessor)REFLECTIVE_PROPERTY_ACCESSOR_INSTANCE);
        this.setPropertyAccessors(propertyAccessors);
        this.setTypeLocator(TYPE_LOCATOR);
        this.setMethodResolvers(METHOD_RESOLVERS);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Object lookupVariable(String name) {
        Object result;
        if (this.expressionObjects != null && this.expressionObjects.containsObject(name) && (result = this.expressionObjects.getObject(name)) != null) {
            return result;
        }
        return super.lookupVariable(name);
    }

    @Override
    public boolean isVariableAccessRestricted() {
        return this.variableAccessRestricted;
    }

    @Override
    public void setVariableAccessRestricted(boolean restricted) {
        this.variableAccessRestricted = restricted;
    }

    @Override
    public IExpressionObjects getExpressionObjects() {
        return this.expressionObjects;
    }

    @Override
    public void setExpressionObjects(IExpressionObjects expressionObjects) {
        this.expressionObjects = expressionObjects;
    }

    static final class ThymeleafEvaluationContextACLPropertyAccessor
    extends ReflectivePropertyAccessor {
        private final ReflectivePropertyAccessor propertyAccessor;

        ThymeleafEvaluationContextACLPropertyAccessor() {
            this(null);
        }

        ThymeleafEvaluationContextACLPropertyAccessor(ReflectivePropertyAccessor propertyAccessor) {
            super(false);
            this.propertyAccessor = propertyAccessor;
        }

        public boolean canRead(EvaluationContext context, Object targetObject, String name) throws AccessException {
            boolean canRead = this.propertyAccessor != null ? this.propertyAccessor.canRead(context, targetObject, name) : super.canRead(context, targetObject, name);
            if (canRead) {
                String methodEquiv;
                String string = methodEquiv = "empty".equals(name) || "blank".equals(name) ? "is" + Character.toUpperCase(name.charAt(0)) + name.substring(1) : "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
                if (!ExpressionUtils.isMemberAllowed((Object)targetObject, (String)methodEquiv)) {
                    throw new EvaluationException(String.format("Accessing member '%s' is forbidden for type '%s' in this expression context.", name, targetObject.getClass()));
                }
            }
            return canRead;
        }
    }

    static final class ThymeleafEvaluationContextACLTypeLocator
    implements TypeLocator {
        private final TypeLocator typeLocator;

        ThymeleafEvaluationContextACLTypeLocator() {
            this((TypeLocator)new StandardTypeLocator());
        }

        ThymeleafEvaluationContextACLTypeLocator(TypeLocator typeLocator) {
            this.typeLocator = typeLocator;
            if (this.typeLocator instanceof StandardTypeLocator) {
                ((StandardTypeLocator)this.typeLocator).removeImport("java.lang");
            }
        }

        public Class<?> findType(String typeName) throws EvaluationException {
            if (this.typeLocator == null) {
                throw new EvaluationException("Type could not be located (no type locator configured): " + typeName);
            }
            if (!ExpressionUtils.isTypeAllowed((String)typeName)) {
                throw new EvaluationException(String.format("Access is forbidden for type '%s' in this expression context.", typeName));
            }
            return this.typeLocator.findType(typeName);
        }
    }

    static final class ThymeleafEvaluationContextACLMethodResolver
    extends ReflectiveMethodResolver {
        private final ReflectiveMethodResolver methodResolver;

        ThymeleafEvaluationContextACLMethodResolver() {
            this(null);
        }

        ThymeleafEvaluationContextACLMethodResolver(ReflectiveMethodResolver methodResolver) {
            this.methodResolver = methodResolver;
        }

        public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
            MethodExecutor methodExecutor = this.methodResolver != null ? this.methodResolver.resolve(context, targetObject, name, argumentTypes) : super.resolve(context, targetObject, name, argumentTypes);
            if (methodExecutor != null && !ExpressionUtils.isMemberAllowed((Object)targetObject, (String)name)) {
                throw new EvaluationException(String.format("Calling method '%s' is forbidden for type '%s' in this expression context.", name, targetObject.getClass()));
            }
            return methodExecutor;
        }
    }
}

