/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.jpa.QueryHandler;
import com.querydsl.jpa.TransformingIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.Cursor;

class EclipseLinkHandler
implements QueryHandler {
    EclipseLinkHandler() {
    }

    @Override
    public void addEntity(Query query, String alias, Class<?> type) {
    }

    @Override
    public void addScalar(Query query, String alias, Class<?> type) {
    }

    @Override
    public boolean createNativeQueryTyped() {
        return true;
    }

    @Override
    public <T> CloseableIterator<T> iterate(Query query, FactoryExpression<?> projection) {
        boolean canUseCursor = false;
        try {
            canUseCursor = query.unwrap(Query.class) instanceof JpaQuery;
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        Iterator iterator = null;
        Closeable closeable = null;
        if (canUseCursor) {
            query.setHint("eclipselink.cursor", (Object)"True");
            final Cursor cursor = (Cursor)query.getSingleResult();
            final int pageSize = cursor.getPageSize();
            closeable = new Closeable(){

                @Override
                public void close() throws IOException {
                    cursor.close();
                }
            };
            iterator = new Iterator<T>(){
                private int rowsSinceLastClear = 0;

                @Override
                public boolean hasNext() {
                    return cursor.hasNext();
                }

                @Override
                public T next() {
                    if (this.rowsSinceLastClear++ == pageSize) {
                        this.rowsSinceLastClear = 0;
                        cursor.clear();
                    }
                    return cursor.next();
                }
            };
        } else {
            iterator = query.getResultList().iterator();
        }
        if (projection != null) {
            return new TransformingIterator(iterator, closeable, projection);
        }
        return new IteratorAdapter(iterator, closeable);
    }

    @Override
    public boolean transform(Query query, FactoryExpression<?> projection) {
        return false;
    }

    @Override
    public boolean wrapEntityProjections() {
        return false;
    }
}

