/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PngImageType {
    GREYSCALE(0),
    TRUECOLOR(2),
    INDEXED_COLOR(3),
    GREYSCALE_ALPHA(4),
    TRUECOLOR_ALPHA(6);

    private int colorType;

    private PngImageType(int colorType) {
        this.colorType = colorType;
    }

    public static PngImageType forColorType(int colorType) {
        switch (colorType) {
            case 0: {
                return GREYSCALE;
            }
            case 2: {
                return TRUECOLOR;
            }
            case 3: {
                return INDEXED_COLOR;
            }
            case 4: {
                return GREYSCALE_ALPHA;
            }
            case 6: {
                return TRUECOLOR_ALPHA;
            }
        }
        throw new IllegalArgumentException();
    }

    public int channelCount() {
        switch (this.colorType) {
            case 0: 
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 6: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }
}

