/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.file;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.opensearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.opensearch.index.store.remote.file.OnDemandBlockIndexInput;
import org.opensearch.index.store.remote.utils.TransferManager;

public class OnDemandVirtualFileSnapshotIndexInput
extends OnDemandBlockIndexInput {
    private static final Logger logger = LogManager.getLogger(OnDemandVirtualFileSnapshotIndexInput.class);
    private static final int BLOCK_SIZE_SHIFT = 30;
    private final TransferManager transferManager;
    private final BlobStoreIndexShardSnapshot.FileInfo fileInfo;
    protected final FSDirectory directory;
    protected final String fileName;

    public OnDemandVirtualFileSnapshotIndexInput(BlobStoreIndexShardSnapshot.FileInfo fileInfo, FSDirectory directory, TransferManager transferManager) {
        this("VirtualFileSnapshotIndexInput(path=\"" + directory.getDirectory().toString() + "/" + fileInfo.physicalName() + "\", offset=0, length= " + fileInfo.length() + ")", fileInfo, directory, transferManager, fileInfo.physicalName(), 0L, fileInfo.length(), false);
    }

    public OnDemandVirtualFileSnapshotIndexInput(String resourceDescription, BlobStoreIndexShardSnapshot.FileInfo fileInfo, FSDirectory directory, TransferManager transferManager, String fileName, long offset, long length, boolean isClone) {
        super(OnDemandBlockIndexInput.builder().resourceDescription(resourceDescription).isClone(isClone).offset(offset).length(length).blockSizeShift(30));
        this.fileInfo = fileInfo;
        this.directory = directory;
        this.fileName = fileName;
        this.transferManager = transferManager;
    }

    @Override
    protected OnDemandVirtualFileSnapshotIndexInput buildSlice(String sliceDescription, long offset, long length) {
        return new OnDemandVirtualFileSnapshotIndexInput(sliceDescription, this.fileInfo, this.directory, this.transferManager, this.fileName, offset, length, true);
    }

    @Override
    public OnDemandVirtualFileSnapshotIndexInput clone() {
        OnDemandVirtualFileSnapshotIndexInput clone = this.buildSlice("clone", 0L, this.length);
        if (this.currentBlock != null) {
            clone.currentBlock = this.currentBlock.clone();
            clone.currentBlockId = this.currentBlockId;
        }
        return clone;
    }

    @Override
    protected IndexInput fetchBlock(int blockId) throws IOException {
        Path filePath = this.directory.getDirectory().resolve(this.fileName);
        try {
            return this.transferManager.asyncFetchBlob(filePath, () -> new ByteArrayIndexInput(this.fileName, this.fileInfo.metadata().hash().bytes)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error(() -> new ParameterizedMessage("unexpected failure while fetching [{}]", (Object)filePath), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }
}

