/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.BaseIndexStore;
import com.hazelcast.query.impl.BaseSingleValueIndexStore;
import com.hazelcast.query.impl.Comparables;
import com.hazelcast.query.impl.Comparison;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexKeyEntries;
import com.hazelcast.query.impl.MultiResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class OrderedIndexStore
extends BaseSingleValueIndexStore {
    public static final Comparator<Data> DATA_COMPARATOR = new DataComparator();
    private final ConcurrentSkipListMap<Comparable, NavigableMap<Data, QueryableEntry>> recordMap = new ConcurrentSkipListMap(Comparables.COMPARATOR);
    private final BaseIndexStore.IndexFunctor<Comparable, QueryableEntry> addFunctor;
    private final BaseIndexStore.IndexFunctor<Comparable, Data> removeFunctor;
    private volatile SortedMap<Data, QueryableEntry> recordsWithNullValue;

    public OrderedIndexStore(IndexCopyBehavior copyOn) {
        super(copyOn, true);
        assert (copyOn != null);
        if (copyOn == IndexCopyBehavior.COPY_ON_WRITE) {
            this.addFunctor = new CopyOnWriteAddFunctor();
            this.removeFunctor = new CopyOnWriteRemoveFunctor();
            this.recordsWithNullValue = new TreeMap<Data, QueryableEntry>(DATA_COMPARATOR);
        } else {
            this.addFunctor = new AddFunctor();
            this.removeFunctor = new RemoveFunctor();
            this.recordsWithNullValue = new ConcurrentSkipListMap<Data, QueryableEntry>(DATA_COMPARATOR);
        }
    }

    @Override
    Object insertInternal(Comparable value, QueryableEntry record) {
        return this.addFunctor.invoke(value, record);
    }

    @Override
    Object removeInternal(Comparable value, Data recordKey) {
        return this.removeFunctor.invoke(value, recordKey);
    }

    @Override
    public Comparable canonicalizeQueryArgumentScalar(Comparable value) {
        return Comparables.canonicalizeForHashLookup(value);
    }

    @Override
    public Comparable canonicalizeScalarForStorage(Comparable value) {
        return value;
    }

    @Override
    public void clear() {
        this.takeWriteLock();
        try {
            this.recordsWithNullValue.clear();
            this.recordMap.clear();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public boolean isEvaluateOnly() {
        return false;
    }

    @Override
    public boolean canEvaluate(Class<? extends Predicate> predicateClass) {
        return false;
    }

    @Override
    public Set<QueryableEntry> evaluate(Predicate predicate, TypeConverter converter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(boolean descending) {
        return new IteratorFromBatch(this.getSqlRecordIteratorBatch(descending));
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable value) {
        return new IteratorFromBatch(this.getSqlRecordIteratorBatch(value));
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparison comparison, Comparable searchedValue, boolean descending) {
        return new IteratorFromBatch(this.getSqlRecordIteratorBatch(comparison, searchedValue, descending));
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        return new IteratorFromBatch(this.getSqlRecordIteratorBatch(from, fromInclusive, to, toInclusive, descending));
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable value) {
        if (value == AbstractIndex.NULL) {
            return Stream.of(new IndexKeyEntries(value, this.recordsWithNullValue.values().iterator())).iterator();
        }
        Map entries = this.recordMap.get(value);
        if (entries == null) {
            return Collections.emptyIterator();
        }
        return Stream.of(new IndexKeyEntries(value, entries.values().iterator())).iterator();
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(boolean descending) {
        Stream<IndexKeyEntries> nullStream = Stream.of(new IndexKeyEntries(null, this.recordsWithNullValue.values().iterator()));
        if (descending) {
            Stream<IndexKeyEntries> nonNullStream = this.recordMap.descendingMap().entrySet().stream().map(es -> new IndexKeyEntries((Comparable)es.getKey(), ((NavigableMap)es.getValue()).descendingMap().values().iterator()));
            return Stream.concat(nonNullStream, nullStream).iterator();
        }
        Stream<IndexKeyEntries> nonNullStream = this.recordMap.entrySet().stream().map(es -> new IndexKeyEntries((Comparable)es.getKey(), ((NavigableMap)es.getValue()).values().iterator()));
        return Stream.concat(nullStream, nonNullStream).iterator();
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparison comparison, Comparable searchedValue, boolean descending) {
        NavigableMap navigableMap = descending ? this.recordMap.descendingMap() : this.recordMap;
        switch (comparison) {
            case LESS: {
                if (descending) {
                    navigableMap = navigableMap.tailMap(searchedValue, false);
                    break;
                }
                navigableMap = navigableMap.headMap(searchedValue, false);
                break;
            }
            case LESS_OR_EQUAL: {
                if (descending) {
                    navigableMap = navigableMap.tailMap(searchedValue, true);
                    break;
                }
                navigableMap = navigableMap.headMap(searchedValue, true);
                break;
            }
            case GREATER: {
                if (descending) {
                    navigableMap = navigableMap.headMap(searchedValue, false);
                    break;
                }
                navigableMap = navigableMap.tailMap(searchedValue, false);
                break;
            }
            case GREATER_OR_EQUAL: {
                if (descending) {
                    navigableMap = navigableMap.headMap(searchedValue, true);
                    break;
                }
                navigableMap = navigableMap.tailMap(searchedValue, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized comparison: " + (Object)((Object)comparison));
            }
        }
        if (descending) {
            return navigableMap.entrySet().stream().map(es -> new IndexKeyEntries((Comparable)es.getKey(), ((NavigableMap)es.getValue()).descendingMap().values().iterator())).iterator();
        }
        return navigableMap.entrySet().stream().map(es -> new IndexKeyEntries((Comparable)es.getKey(), ((NavigableMap)es.getValue()).values().iterator())).iterator();
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        boolean toInclusive0;
        int order = Comparables.compare(from, to);
        if (order == 0) {
            if (!fromInclusive || !toInclusive) {
                return Collections.emptyIterator();
            }
            Map res = this.recordMap.get(from);
            if (res == null) {
                return Collections.emptyIterator();
            }
            return Stream.of(new IndexKeyEntries(from, res.values().iterator())).iterator();
        }
        if (order > 0) {
            return Collections.emptyIterator();
        }
        NavigableMap navigableMap = descending ? this.recordMap.descendingMap() : this.recordMap;
        Comparable from0 = descending ? to : from;
        boolean fromInclusive0 = descending ? toInclusive : fromInclusive;
        Comparable to0 = descending ? from : to;
        boolean bl = toInclusive0 = descending ? fromInclusive : toInclusive;
        if (descending) {
            return navigableMap.subMap(from0, fromInclusive0, to0, toInclusive0).entrySet().stream().map(es -> new IndexKeyEntries((Comparable)es.getKey(), ((NavigableMap)es.getValue()).descendingMap().values().iterator())).iterator();
        }
        return navigableMap.subMap(from0, fromInclusive0, to0, toInclusive0).entrySet().stream().map(es -> new IndexKeyEntries((Comparable)es.getKey(), ((NavigableMap)es.getValue()).values().iterator())).iterator();
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        this.takeReadLock();
        try {
            if (value == AbstractIndex.NULL) {
                Set<QueryableEntry> set = this.toSingleResultSet(this.recordsWithNullValue);
                return set;
            }
            Set<QueryableEntry> set = this.toSingleResultSet((Map<Data, QueryableEntry>)this.recordMap.get(value));
            return set;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getRecords(Set<Comparable> values) {
        this.takeReadLock();
        try {
            MultiResultSet results = this.createMultiResultSet();
            for (Comparable value : values) {
                Map records = value == AbstractIndex.NULL ? this.recordsWithNullValue : (Map)this.recordMap.get(value);
                if (records == null) continue;
                this.copyToMultiResultSet(results, records);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getRecords(Comparison comparison, Comparable searchedValue) {
        this.takeReadLock();
        try {
            NavigableMap subMap;
            MultiResultSet results = this.createMultiResultSet();
            switch (comparison) {
                case LESS: {
                    subMap = this.recordMap.headMap((Object)searchedValue, false);
                    break;
                }
                case LESS_OR_EQUAL: {
                    subMap = this.recordMap.headMap((Object)searchedValue, true);
                    break;
                }
                case GREATER: {
                    subMap = this.recordMap.tailMap((Object)searchedValue, false);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    subMap = this.recordMap.tailMap((Object)searchedValue, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized comparison: " + (Object)((Object)comparison));
                }
            }
            for (Map value : subMap.values()) {
                this.copyToMultiResultSet(results, value);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getRecords(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive) {
        this.takeReadLock();
        try {
            int order = Comparables.compare(from, to);
            if (order == 0) {
                if (!fromInclusive || !toInclusive) {
                    Set<QueryableEntry> set = Collections.emptySet();
                    return set;
                }
                Set<QueryableEntry> set = this.toSingleResultSet((Map<Data, QueryableEntry>)this.recordMap.get(from));
                return set;
            }
            if (order > 0) {
                Set<QueryableEntry> set = Collections.emptySet();
                return set;
            }
            MultiResultSet results = this.createMultiResultSet();
            NavigableMap subMap = this.recordMap.subMap((Object)from, fromInclusive, (Object)to, toInclusive);
            for (Map value : subMap.values()) {
                this.copyToMultiResultSet(results, value);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private static class DataComparator
    implements Comparator<Data> {
        private DataComparator() {
        }

        @Override
        public int compare(Data o1, Data o2) {
            byte[] thisBytes = o1.toByteArray();
            byte[] thatBytes = o2.toByteArray();
            int minLen = Math.min(thisBytes.length, thatBytes.length);
            for (int i = 0; i < minLen; ++i) {
                int diff = thisBytes[i] - thatBytes[i];
                if (diff == 0) continue;
                return diff;
            }
            return thisBytes.length - thatBytes.length;
        }
    }

    private static final class IteratorFromBatch
    implements Iterator<QueryableEntry> {
        private final Iterator<IndexKeyEntries> iterator;
        private Iterator<QueryableEntry> indexKeyIterator;

        private IteratorFromBatch(@Nonnull Iterator<IndexKeyEntries> iterator) {
            this.iterator = iterator;
            this.indexKeyIterator = iterator.hasNext() ? iterator.next().getEntries() : null;
        }

        @Override
        public boolean hasNext() {
            if (this.indexKeyIterator == null) {
                return false;
            }
            if (this.indexKeyIterator.hasNext()) {
                return true;
            }
            while (this.iterator.hasNext()) {
                this.indexKeyIterator = this.iterator.next().getEntries();
                if (!this.indexKeyIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public QueryableEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.indexKeyIterator.next();
        }
    }

    private class CopyOnWriteRemoveFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, Data> {
        private CopyOnWriteRemoveFunctor() {
        }

        @Override
        public Object invoke(Comparable value, Data indexKey) {
            Object oldValue;
            if (value == AbstractIndex.NULL) {
                TreeMap copy = new TreeMap(OrderedIndexStore.this.recordsWithNullValue);
                oldValue = copy.remove(indexKey);
                OrderedIndexStore.this.recordsWithNullValue = copy;
            } else {
                TreeMap records = (TreeMap)OrderedIndexStore.this.recordMap.get(value);
                if (records != null) {
                    records = new TreeMap(records);
                    oldValue = records.remove(indexKey);
                    if (records.isEmpty()) {
                        OrderedIndexStore.this.recordMap.remove(value);
                    } else {
                        OrderedIndexStore.this.recordMap.put(value, records);
                    }
                } else {
                    oldValue = null;
                }
            }
            return oldValue;
        }
    }

    private class RemoveFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, Data> {
        private RemoveFunctor() {
        }

        @Override
        public Object invoke(Comparable value, Data indexKey) {
            Object oldValue;
            if (value == AbstractIndex.NULL) {
                oldValue = OrderedIndexStore.this.recordsWithNullValue.remove(indexKey);
            } else {
                Map records = (Map)OrderedIndexStore.this.recordMap.get(value);
                if (records != null) {
                    oldValue = records.remove(indexKey);
                    if (records.isEmpty()) {
                        OrderedIndexStore.this.recordMap.remove(value);
                    }
                } else {
                    oldValue = null;
                }
            }
            return oldValue;
        }
    }

    private class CopyOnWriteAddFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, QueryableEntry> {
        private CopyOnWriteAddFunctor() {
        }

        @Override
        public Object invoke(Comparable value, QueryableEntry entry) {
            QueryableEntry oldValue;
            if (value == AbstractIndex.NULL) {
                TreeMap<Data, QueryableEntry> copy = new TreeMap<Data, QueryableEntry>(OrderedIndexStore.this.recordsWithNullValue);
                oldValue = copy.put(entry.getKeyData(), entry);
                OrderedIndexStore.this.recordsWithNullValue = copy;
            } else {
                TreeMap records = (TreeMap)OrderedIndexStore.this.recordMap.get(value);
                if (records == null) {
                    records = new TreeMap(DATA_COMPARATOR);
                }
                records = new TreeMap(records);
                oldValue = records.put(entry.getKeyData(), entry);
                OrderedIndexStore.this.recordMap.put(value, records);
            }
            return oldValue;
        }
    }

    private class AddFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, QueryableEntry> {
        private AddFunctor() {
        }

        @Override
        public Object invoke(Comparable value, QueryableEntry entry) {
            if (value == AbstractIndex.NULL) {
                return OrderedIndexStore.this.recordsWithNullValue.put(entry.getKeyData(), entry);
            }
            ConcurrentSkipListMap<Data, QueryableEntry> records = (ConcurrentSkipListMap<Data, QueryableEntry>)OrderedIndexStore.this.recordMap.get(value);
            if (records == null) {
                records = new ConcurrentSkipListMap<Data, QueryableEntry>(DATA_COMPARATOR);
                OrderedIndexStore.this.recordMap.put(value, records);
            }
            return records.put(entry.getKeyData(), entry);
        }
    }
}

