/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.metrics;

import com.hazelcast.jet.impl.metrics.JetMetricsDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class RawJobMetrics
implements IdentifiedDataSerializable {
    private long timestamp;
    private byte[] blob;

    RawJobMetrics() {
    }

    private RawJobMetrics(long timestamp, byte[] blob) {
        this.timestamp = timestamp;
        this.blob = blob;
    }

    public static RawJobMetrics empty() {
        return RawJobMetrics.of(null);
    }

    public static RawJobMetrics of(@Nullable byte[] blob) {
        return new RawJobMetrics(System.currentTimeMillis(), blob);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public byte[] getBlob() {
        return this.blob;
    }

    @Override
    public int getFactoryId() {
        return JetMetricsDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeByteArray(this.blob);
        out.writeLong(this.timestamp);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.blob = in.readByteArray();
        this.timestamp = in.readLong();
    }

    public int hashCode() {
        return (int)this.timestamp * 31 + Arrays.hashCode(this.blob);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RawJobMetrics that = (RawJobMetrics)obj;
        return Arrays.equals(this.blob, that.blob) && this.timestamp == that.timestamp;
    }

    public String toString() {
        return Arrays.toString(this.blob) + " @ " + this.timestamp;
    }
}

