/*
 * Decompiled with CFR 0.152.
 */
package org.stro.dbdiff.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.stro.dbdiff.model.AddedDiffResultDescriptor;
import org.stro.dbdiff.model.DatabaseChanges;
import org.stro.dbdiff.model.DatabaseMetadata;
import org.stro.dbdiff.model.MultiChanges;
import org.stro.dbdiff.model.SingleChanges;
import org.stro.dbdiff.model.TableChanges;
import org.stro.dbdiff.model.TableMetadata;

public class DatabaseDiffResult {
    private DatabaseMetadata actual;
    private DatabaseMetadata added;
    private DatabaseMetadata removed;
    private DatabaseChanges changed;

    public static final DatabaseDiffResult empty() {
        DatabaseMetadata emptyMetadata = new DatabaseMetadata();
        return new DatabaseDiffResult(emptyMetadata, emptyMetadata, emptyMetadata, new DatabaseChanges());
    }

    public DatabaseDiffResult() {
    }

    public DatabaseDiffResult(DatabaseMetadata actual, DatabaseMetadata added, DatabaseMetadata removed, DatabaseChanges changed) {
        this.actual = actual;
        this.added = added;
        this.removed = removed;
        this.changed = changed;
    }

    public AddedDiffResultDescriptor clearAdded() {
        AddedDiffResultDescriptor result = new AddedDiffResultDescriptor();
        result.setFunctions(this.added.getFunctions().size());
        result.setSequences(this.added.getSequences().size());
        result.setTables(this.added.getTables().size());
        result.setViews(this.added.getViews().size());
        this.added.clear();
        this.changed.getTables().forEach((k, v) -> {
            v.getColumns().getAdded().clear();
            v.getfKConstraints().getAdded().clear();
            v.getIndexes().getAdded().clear();
            v.getPkConstraint().setAdded(null);
            v.getTriggers().getAdded().clear();
            v.getUniqueConstraints().getAdded().clear();
        });
        Map<String, TableChanges> tables = this.changed.getTables().entrySet().stream().filter(e -> !((TableChanges)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.changed.setTables(tables);
        return result;
    }

    public void clearEmpty() {
        this.setActual(this.clearEmpty(this.actual));
        this.setAdded(this.clearEmpty(this.added));
        this.setRemoved(this.clearEmpty(this.removed));
        this.setChanged(this.clearEmpty(this.changed));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatabaseDiffResult other = (DatabaseDiffResult)obj;
        return this.bothEqualsOrEmpty(this.added, other.added) && this.bothEqualsOrEmpty(this.changed, other.changed) && this.bothEqualsOrEmpty(this.removed, other.removed);
    }

    public DatabaseMetadata getActual() {
        return this.actual;
    }

    public DatabaseMetadata getAdded() {
        return this.added;
    }

    public DatabaseChanges getChanged() {
        return this.changed;
    }

    public DatabaseMetadata getRemoved() {
        return this.removed;
    }

    public int hashCode() {
        return Objects.hash(this.added, this.changed, this.removed);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return !(this.added != null && !this.added.isEmpty() || this.removed != null && !this.removed.isEmpty() || this.changed != null && !this.changed.isEmpty());
    }

    public void setActual(DatabaseMetadata actual) {
        this.actual = actual;
    }

    public void setAdded(DatabaseMetadata added) {
        this.added = added;
    }

    public void setChanged(DatabaseChanges changed) {
        this.changed = changed;
    }

    public void setRemoved(DatabaseMetadata removed) {
        this.removed = removed;
    }

    public String toString() {
        return "DatabaseDiffResult [actual=" + this.actual + ", added=" + this.added + ", removed=" + this.removed + ", changed=" + this.changed + "]";
    }

    private boolean bothEqualsOrEmpty(DatabaseChanges changes, DatabaseChanges other) {
        return Objects.equals(changes, other) || changes == null && other.isEmpty() || other == null && changes.isEmpty();
    }

    private boolean bothEqualsOrEmpty(DatabaseMetadata metadata, DatabaseMetadata other) {
        return Objects.equals(metadata, other) || metadata == null && other.isEmpty() || other == null && metadata.isEmpty();
    }

    private DatabaseChanges clearEmpty(DatabaseChanges changes) {
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Map<String, TableChanges> tables = changes.getTables().entrySet().stream().filter(e -> {
            TableChanges v = (TableChanges)e.getValue();
            v.setColumns(this.nullIfEmpty((SingleChanges)((Object)v.getColumns())));
            v.setfKConstraints(this.nullIfEmpty((SingleChanges)((Object)v.getfKConstraints())));
            v.setIndexes(this.nullIfEmpty((SingleChanges)((Object)v.getIndexes())));
            v.setPkConstraint(this.nullIfEmpty(v.getPkConstraint()));
            v.setTriggers(this.nullIfEmpty((SingleChanges)((Object)v.getTriggers())));
            v.setUniqueConstraints(this.nullIfEmpty((SingleChanges)((Object)v.getUniqueConstraints())));
            return !v.isEmpty();
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        changes.setTables(tables);
        return changes.isEmpty() ? null : changes;
    }

    private DatabaseMetadata clearEmpty(DatabaseMetadata metadata) {
        if (metadata == null || metadata.isEmpty()) {
            return null;
        }
        metadata.setFunctions(this.nullIfEmpty((SingleChanges)((Object)metadata.getFunctions())));
        metadata.setSequences(this.nullIfEmpty((SingleChanges)((Object)metadata.getSequences())));
        metadata.setTables(this.nullIfEmpty((SingleChanges)((Object)metadata.getTables())));
        metadata.setViews(this.nullIfEmpty((SingleChanges)((Object)metadata.getViews())));
        Map<String, TableMetadata> tables = metadata.getTables();
        if (tables != null) {
            tables.entrySet().stream().filter(e -> {
                TableMetadata v = (TableMetadata)e.getValue();
                v.setColumns(this.nullIfEmpty((SingleChanges)((Object)v.getColumns())));
                v.setfKConstraints(this.nullIfEmpty((SingleChanges)((Object)v.getfKConstraints())));
                v.setIndexes(this.nullIfEmpty((SingleChanges)((Object)v.getIndexes())));
                v.setTriggers(this.nullIfEmpty((SingleChanges)((Object)v.getTriggers())));
                v.setUniqueConstraints(this.nullIfEmpty((SingleChanges)((Object)v.getUniqueConstraints())));
                return !v.isEmpty();
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            metadata.setTables(tables);
        }
        return metadata.isEmpty() ? null : metadata;
    }

    private <M extends Map<?, ?>> M nullIfEmpty(M map) {
        return MapUtils.isEmpty(map) ? null : (M)map;
    }

    private <M extends MultiChanges<?>> M nullIfEmpty(M multi) {
        return multi == null || multi.isEmpty() ? null : (M)multi;
    }

    private <S extends SingleChanges<?>> S nullIfEmpty(S single) {
        return single == null || single.isEmpty() ? null : (S)single;
    }
}

