/*
 * Decompiled with CFR 0.152.
 */
package org.stro.dbdiff.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.stro.dbdiff.model.DefinableMetadata;

public abstract class BaseDatabaseMetadata {
    protected String productName;
    protected String productVersion;
    protected int productVersionCode;
    protected Map<String, DefinableMetadata> functions = new HashMap<String, DefinableMetadata>();
    protected Map<String, DefinableMetadata> views = new HashMap<String, DefinableMetadata>();
    protected Map<String, DefinableMetadata> sequences = new HashMap<String, DefinableMetadata>();

    public void clear() {
        this.productName = null;
        this.productVersion = null;
        this.productVersionCode = 0;
        this.functions.clear();
        this.views.clear();
        this.sequences.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseDatabaseMetadata other = (BaseDatabaseMetadata)obj;
        return this.bothEqualsOrEmpty(this.functions, other.functions) && this.bothEqualsOrEmpty(this.sequences, other.sequences) && this.bothEqualsOrEmpty(this.views, other.views);
    }

    public Map<String, DefinableMetadata> getFunctions() {
        return this.functions;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public int getProductVersionCode() {
        return this.productVersionCode;
    }

    public Map<String, DefinableMetadata> getSequences() {
        return this.sequences;
    }

    public Map<String, DefinableMetadata> getViews() {
        return this.views;
    }

    public int hashCode() {
        return Objects.hash(this.functions, this.sequences, this.views);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.productName) && StringUtils.isBlank((CharSequence)this.productVersion) && this.productVersionCode == 0 && MapUtils.isEmpty(this.functions) && MapUtils.isEmpty(this.views) && MapUtils.isEmpty(this.sequences);
    }

    public void setFunctions(Map<String, DefinableMetadata> functions) {
        this.functions = functions;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setProductVersionCode(int productVersionCode) {
        this.productVersionCode = productVersionCode;
    }

    public void setSequences(Map<String, DefinableMetadata> sequences) {
        this.sequences = sequences;
    }

    public void setViews(Map<String, DefinableMetadata> views) {
        this.views = views;
    }

    protected boolean bothEqualsOrEmpty(Map<?, ?> map, Map<?, ?> other) {
        return Objects.equals(map, other) || map == null && other.isEmpty() || other == null && map.isEmpty();
    }
}

