/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityVO;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.contentmanagement.contentitems.MenuItemVO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueCategoryVO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueVO;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.wizards.CustomWizardAction;
import org.cyclos.model.system.wizards.CustomWizardBackParams;
import org.cyclos.model.system.wizards.CustomWizardExecutionData;
import org.cyclos.model.system.wizards.CustomWizardNature;
import org.cyclos.model.system.wizards.CustomWizardResultType;
import org.cyclos.model.system.wizards.CustomWizardTransitionParams;
import org.cyclos.model.system.wizards.CustomWizardTransitionVO;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.system.wizards.CustomWizardVerificationCodeParams;
import org.cyclos.model.system.wizards.RunExternalRedirectCallbackParams;
import org.cyclos.model.system.wizards.StartCustomWizardParams;
import org.cyclos.model.system.wizardsteps.CustomWizardStepDetailedVO;
import org.cyclos.model.system.wizardsteps.CustomWizardStepFieldDefinitionType;
import org.cyclos.model.system.wizardsteps.CustomWizardStepNature;
import org.cyclos.model.system.wizardsteps.CustomWizardStepVO;
import org.cyclos.model.system.wizardsteps.FormFieldsWizardStepFieldVO;
import org.cyclos.model.system.wizardsteps.FormFieldsWizardStepVO;
import org.cyclos.model.system.wizardsteps.GroupSelectionWizardStepVO;
import org.cyclos.model.system.wizardsteps.IdentityProviderWizardStepVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.users.AbstractSimpleRegistrationData;
import org.cyclos.model.users.users.AbstractSimpleUserRegistrationDTO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.IdentityProvidersApiHelper;
import org.cyclos.web.rest.helpers.PhonesApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.BasicProfileFieldEnum;
import org.cyclos.web.rest.model.HttpRequestData;
import org.cyclos.web.rest.model.PhoneKind;
import org.cyclos.web.rest.model.Wizard;
import org.cyclos.web.rest.model.WizardActionEnum;
import org.cyclos.web.rest.model.WizardExecutionData;
import org.cyclos.web.rest.model.WizardKind;
import org.cyclos.web.rest.model.WizardResultTypeEnum;
import org.cyclos.web.rest.model.WizardStep;
import org.cyclos.web.rest.model.WizardStepDetailed;
import org.cyclos.web.rest.model.WizardStepField;
import org.cyclos.web.rest.model.WizardStepFieldKind;
import org.cyclos.web.rest.model.WizardStepKind;
import org.cyclos.web.rest.model.WizardStepTransition;
import org.cyclos.web.rest.model.WizardTransitionParams;
import org.cyclos.web.rest.model.WizardVerificationCodeParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WizardsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private IdentityProvidersApiHelper identityProvidersApiHelper;
    @Autowired
    private PhonesApiHelper phonesApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public CustomWizardBackParams toCustomWizardBackParams(String string, Integer n) {
        CustomWizardBackParams customWizardBackParams = new CustomWizardBackParams();
        customWizardBackParams.setKey(string);
        customWizardBackParams.setSteps(n);
        return customWizardBackParams;
    }

    public CustomWizardVerificationCodeParams toCustomWizardVerificationCodeParams(String string, WizardVerificationCodeParams wizardVerificationCodeParams) {
        CustomWizardVerificationCodeParams customWizardVerificationCodeParams = new CustomWizardVerificationCodeParams();
        customWizardVerificationCodeParams.setKey(string);
        customWizardVerificationCodeParams.setMedium(this.apiHelper.toSendMedium(wizardVerificationCodeParams.getMedium()));
        customWizardVerificationCodeParams.setTo(wizardVerificationCodeParams.getTo());
        return customWizardVerificationCodeParams;
    }

    public RunExternalRedirectCallbackParams toRunExternalRedirectCallbackParams(String string, HttpRequestData httpRequestData) {
        RunExternalRedirectCallbackParams runExternalRedirectCallbackParams = new RunExternalRedirectCallbackParams();
        runExternalRedirectCallbackParams.setKey(string);
        runExternalRedirectCallbackParams.setRequest(this.apiHelper.toRequestInfo(httpRequestData));
        return runExternalRedirectCallbackParams;
    }

    public StartCustomWizardParams toStartCustomWizardParams(String string, String string2, String string3, String string4, String string5, String string6) {
        StartCustomWizardParams startCustomWizardParams = new StartCustomWizardParams();
        startCustomWizardParams.setWizard((CustomWizardVO)ModelHelper.voFromString(CustomWizardVO.class, (String)string));
        startCustomWizardParams.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
        startCustomWizardParams.setMenuItem((MenuItemVO)ModelHelper.voFromString(MenuItemVO.class, (String)string3));
        startCustomWizardParams.setInviteToken(string4);
        startCustomWizardParams.setExternalPaymentToken(string5);
        startCustomWizardParams.setUserAgentId(string6);
        return startCustomWizardParams;
    }

    public Wizard toWizard(CustomWizardVO customWizardVO) {
        if (customWizardVO == null) {
            return null;
        }
        Wizard wizard = this.apiHelper.newEntity(Wizard.class, customWizardVO);
        wizard.setKind(this.toWizardKind(customWizardVO.getNature()));
        wizard.setLabel(customWizardVO.getLabel());
        this.apiHelper.setIconOrCustomSVG(customWizardVO.getIcon(), wizard);
        wizard.setSvgIcon(customWizardVO.getSvgIcon());
        wizard.setAdminMenu(this.apiHelper.toAdminMenuEnum(customWizardVO.getAdminMenu()));
        wizard.setUserMenu(this.apiHelper.toUserMenuEnum(customWizardVO.getUserMenu()));
        wizard.setUserProfileSection(this.apiHelper.toUserProfileSectionEnum(customWizardVO.getProfileSection()));
        return wizard;
    }

    public WizardExecutionData toWizardExecutionData(CustomWizardExecutionData customWizardExecutionData) {
        Object object;
        if (customWizardExecutionData == null) {
            return null;
        }
        WizardExecutionData wizardExecutionData = new WizardExecutionData();
        wizardExecutionData.setKey(customWizardExecutionData.getKey());
        wizardExecutionData.setWizard(this.toWizard(customWizardExecutionData.getWizard()));
        wizardExecutionData.setUser(this.usersApiHelper.toUser((BasicUserVO)customWizardExecutionData.getUser()));
        wizardExecutionData.setMenuItem(this.apiHelper.toReference((EntityModel)customWizardExecutionData.getMenuItem()));
        CollectionHelper.orEmpty((List)customWizardExecutionData.getPath()).stream().map(this::toWizardStep).forEach(wizardExecutionData.getPath()::add);
        CustomWizardTransitionParams customWizardTransitionParams = customWizardExecutionData.getParams();
        if (customWizardExecutionData.getStep() instanceof FormFieldsWizardStepVO && (object = (FormFieldsWizardStepVO)customWizardExecutionData.getStep()).getRegistrationData() != null) {
            object.getRegistrationData().setDto((EntityDTO)customWizardTransitionParams.getUser());
        }
        wizardExecutionData.setStep(this.toWizardStepDetailed(customWizardExecutionData.getStep()));
        if (wizardExecutionData.getStep() != null && wizardExecutionData.getStep().getDataForNew() != null) {
            wizardExecutionData.getStep().getDataForNew().setUser(null);
        }
        wizardExecutionData.setStepNumber(customWizardExecutionData.getStepNumber());
        wizardExecutionData.setStepCount(customWizardExecutionData.getStepCount());
        CollectionHelper.orEmpty((List)customWizardExecutionData.getTransitions()).stream().map(this::toWizardStepTransition).forEach(wizardExecutionData.getTransitions()::add);
        wizardExecutionData.setAction(this.toWizardActionEnum(customWizardExecutionData.getAction()));
        wizardExecutionData.setNotificationLevel(this.apiHelper.toNotificationLevelEnum(customWizardExecutionData.getNotificationLevel()));
        wizardExecutionData.setNotification(customWizardExecutionData.getNotification());
        wizardExecutionData.setResultType(this.toWizardResultTypeEnum(customWizardExecutionData.getResultType()));
        wizardExecutionData.setResultTitle(customWizardExecutionData.getResultTitle());
        wizardExecutionData.setResult(customWizardExecutionData.getResult());
        wizardExecutionData.setRegistrationResult(this.usersApiHelper.toUserRegistrationResult(customWizardExecutionData.getRegistrationResult()));
        wizardExecutionData.setParams(this.toWizardTransitionParams(customWizardTransitionParams));
        if (customWizardExecutionData.getParams() != null) {
            object = customWizardExecutionData.getParams().getCustomValues();
            wizardExecutionData.setBinaryValues(this.apiHelper.toCustomFieldBinaryValues(object));
        }
        wizardExecutionData.setCodeSentToEmail(customWizardExecutionData.getCodeSentToEmail());
        wizardExecutionData.setCodeSentToPhone(customWizardExecutionData.getCodeSentToPhone());
        wizardExecutionData.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)customWizardExecutionData.getConfirmationPasswordInput()));
        return wizardExecutionData;
    }

    public CustomWizardTransitionParams toWizardTransitionParams(String string, WizardTransitionParams wizardTransitionParams, String string2) {
        CustomWizardTransitionParams customWizardTransitionParams = new CustomWizardTransitionParams();
        customWizardTransitionParams.setKey(string);
        customWizardTransitionParams.setTransition(string2);
        customWizardTransitionParams.setGroup((GroupVO)ModelHelper.voFromString(GroupVO.class, (String)wizardTransitionParams.getGroup()));
        customWizardTransitionParams.setUser((PublicRegistrationDTO)this.usersApiHelper.toUserRegistrationDTO(wizardTransitionParams.getUser()));
        customWizardTransitionParams.setEmailVerification(wizardTransitionParams.getEmailVerification());
        customWizardTransitionParams.setSmsVerification(wizardTransitionParams.getSmsVerification());
        customWizardTransitionParams.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(wizardTransitionParams.getCustomValues()));
        customWizardTransitionParams.setConfirmationPassword(wizardTransitionParams.getConfirmationPassword());
        return customWizardTransitionParams;
    }

    private <S extends WizardStep> S newWizardStep(Class<S> clazz, CustomWizardStepVO customWizardStepVO) {
        WizardStep wizardStep = (WizardStep)this.apiHelper.newEntity(clazz, customWizardStepVO);
        wizardStep.setKind(this.toWizardStepKind(customWizardStepVO.getNature()));
        return (S)wizardStep;
    }

    private WizardActionEnum toWizardActionEnum(CustomWizardAction customWizardAction) {
        if (customWizardAction != null) {
            switch (customWizardAction) {
                case STEP: {
                    return WizardActionEnum.STEP;
                }
                case FINISH: {
                    return WizardActionEnum.FINISH;
                }
                case EXTERNAL_REDIRECT: {
                    return WizardActionEnum.EXTERNAL_REDIRECT;
                }
                case ALREADY_EXECUTED: {
                    return WizardActionEnum.ALREADY_EXECUTED;
                }
            }
        }
        return null;
    }

    private WizardKind toWizardKind(CustomWizardNature customWizardNature) {
        if (customWizardNature != null) {
            switch (customWizardNature) {
                case REGISTRATION: {
                    return WizardKind.REGISTRATION;
                }
                case SYSTEM: {
                    return WizardKind.SYSTEM;
                }
                case USER: {
                    return WizardKind.USER;
                }
                case MENU: {
                    return WizardKind.MENU;
                }
            }
        }
        return null;
    }

    private WizardResultTypeEnum toWizardResultTypeEnum(CustomWizardResultType customWizardResultType) {
        if (customWizardResultType != null) {
            switch (customWizardResultType) {
                case REGISTRATION: {
                    return WizardResultTypeEnum.REGISTRATION;
                }
                case PLAIN_TEXT: {
                    return WizardResultTypeEnum.PLAIN_TEXT;
                }
                case RICH_TEXT: {
                    return WizardResultTypeEnum.RICH_TEXT;
                }
            }
        }
        return null;
    }

    private WizardStep toWizardStep(CustomWizardStepVO customWizardStepVO) {
        if (customWizardStepVO == null) {
            return null;
        }
        return this.newWizardStep(WizardStep.class, customWizardStepVO);
    }

    private WizardStepDetailed toWizardStepDetailed(CustomWizardStepDetailedVO customWizardStepDetailedVO) {
        GroupSelectionWizardStepVO groupSelectionWizardStepVO;
        if (customWizardStepDetailedVO == null) {
            return null;
        }
        WizardStepDetailed wizardStepDetailed = this.newWizardStep(WizardStepDetailed.class, (CustomWizardStepVO)customWizardStepDetailedVO);
        wizardStepDetailed.setTitle(customWizardStepDetailedVO.getTitle());
        wizardStepDetailed.setInformationText(customWizardStepDetailedVO.getInformationText());
        if (customWizardStepDetailedVO instanceof GroupSelectionWizardStepVO) {
            groupSelectionWizardStepVO = (GroupSelectionWizardStepVO)customWizardStepDetailedVO;
            CollectionHelper.orEmpty((List)groupSelectionWizardStepVO.getGroups()).stream().map(this.usersApiHelper::toGroupForRegistration).forEach(wizardStepDetailed.getGroups()::add);
        } else {
            wizardStepDetailed.setGroups(null);
        }
        if (customWizardStepDetailedVO instanceof IdentityProviderWizardStepVO) {
            groupSelectionWizardStepVO = (IdentityProviderWizardStepVO)customWizardStepDetailedVO;
            CollectionHelper.orEmpty((List)groupSelectionWizardStepVO.getIdentityProviders()).stream().map(this.identityProvidersApiHelper::toIdentityProvider).forEach(wizardStepDetailed.getIdentityProviders()::add);
        } else {
            wizardStepDetailed.setIdentityProviders(null);
        }
        if (customWizardStepDetailedVO instanceof FormFieldsWizardStepVO) {
            groupSelectionWizardStepVO = (FormFieldsWizardStepVO)customWizardStepDetailedVO;
            wizardStepDetailed.setDataForNew(this.usersApiHelper.toDataForNew((AbstractSimpleRegistrationData)groupSelectionWizardStepVO.getRegistrationData()));
            wizardStepDetailed.setVerifiedEmail(groupSelectionWizardStepVO.getVerifiedEmail());
            wizardStepDetailed.setVerifiedSms(groupSelectionWizardStepVO.getVerifiedSms());
            wizardStepDetailed.setVerificationCodeSeconds(groupSelectionWizardStepVO.getVerificationCodeSeconds());
            CollectionHelper.orEmpty((List)groupSelectionWizardStepVO.getCustomFields()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(wizardStepDetailed.getCustomFields()::add);
            CollectionHelper.orEmpty((List)groupSelectionWizardStepVO.getFields()).stream().map(this::toWizardStepField).forEach(wizardStepDetailed.getFields()::add);
            wizardStepDetailed.setValidateEmail(wizardStepDetailed.getFields().stream().anyMatch(wizardStepField -> wizardStepField.getBasicProfileField() == BasicProfileFieldEnum.EMAIL && wizardStepField.getRequireVerification() != false));
            wizardStepDetailed.setValidateSms(wizardStepDetailed.getFields().stream().anyMatch(wizardStepField -> wizardStepField.getPhoneKind() == PhoneKind.MOBILE && wizardStepField.getRequireVerification() != false));
        } else {
            wizardStepDetailed.setCustomFields(null);
        }
        return wizardStepDetailed;
    }

    private WizardStepField toWizardStepField(FormFieldsWizardStepFieldVO formFieldsWizardStepFieldVO) {
        WizardStepField wizardStepField = new WizardStepField();
        wizardStepField.setKind(this.toWizardStepFieldKind(formFieldsWizardStepFieldVO.getType()));
        wizardStepField.setBasicProfileField(this.usersApiHelper.toBasicProfileFieldEnum(formFieldsWizardStepFieldVO.getBasicProfileField()));
        wizardStepField.setPhoneKind(this.phonesApiHelper.toPhoneKind(formFieldsWizardStepFieldVO.getPhoneNature()));
        wizardStepField.setCustomProfileField(formFieldsWizardStepFieldVO.getCustomProfileField());
        wizardStepField.setWizardField(formFieldsWizardStepFieldVO.getWizardField());
        wizardStepField.setReadOnly(formFieldsWizardStepFieldVO.isReadOnly());
        wizardStepField.setRequireVerification(formFieldsWizardStepFieldVO.isRequireVerification());
        wizardStepField.setReadOnlyFieldValue(this.apiHelper.toCustomFieldValue((ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO>)formFieldsWizardStepFieldVO.getReadOnlyFieldValue()));
        return wizardStepField;
    }

    private WizardStepFieldKind toWizardStepFieldKind(CustomWizardStepFieldDefinitionType customWizardStepFieldDefinitionType) {
        if (customWizardStepFieldDefinitionType != null) {
            switch (customWizardStepFieldDefinitionType) {
                case AGREEMENTS: {
                    return WizardStepFieldKind.AGREEMENTS;
                }
                case BASIC_PROFILE_FIELD: {
                    return WizardStepFieldKind.BASIC_PROFILE_FIELD;
                }
                case CAPTCHA: {
                    return WizardStepFieldKind.CAPTCHA;
                }
                case CONTACT_INFO: {
                    return WizardStepFieldKind.CONTACT_INFO;
                }
                case CUSTOM_PROFILE_FIELD: {
                    return WizardStepFieldKind.CUSTOM_PROFILE_FIELD;
                }
                case PASSWORDS: {
                    return WizardStepFieldKind.PASSWORDS;
                }
                case SECURITY_QUESTION: {
                    return WizardStepFieldKind.SECURITY_QUESTION;
                }
                case WIZARD_FIELD: {
                    return WizardStepFieldKind.WIZARD_FIELD;
                }
            }
        }
        return null;
    }

    private WizardStepKind toWizardStepKind(CustomWizardStepNature customWizardStepNature) {
        if (customWizardStepNature != null) {
            switch (customWizardStepNature) {
                case GROUP: {
                    return WizardStepKind.GROUP;
                }
                case IDENTITY_PROVIDER: {
                    return WizardStepKind.IDENTITY_PROVIDER;
                }
                case FORM_FIELDS: {
                    return WizardStepKind.FORM_FIELDS;
                }
                case EMAIL_VERIFICATION: {
                    return WizardStepKind.EMAIL_VERIFICATION;
                }
                case PHONE_VERIFICATION: {
                    return WizardStepKind.PHONE_VERIFICATION;
                }
            }
        }
        return null;
    }

    private WizardStepTransition toWizardStepTransition(CustomWizardTransitionVO customWizardTransitionVO) {
        if (customWizardTransitionVO == null) {
            return null;
        }
        WizardStepTransition wizardStepTransition = new WizardStepTransition();
        wizardStepTransition.setId(customWizardTransitionVO.getId());
        wizardStepTransition.setLabel(customWizardTransitionVO.getLabel());
        wizardStepTransition.setStep(this.toWizardStep(customWizardTransitionVO.getStep()));
        return wizardStepTransition;
    }

    private WizardTransitionParams toWizardTransitionParams(CustomWizardTransitionParams customWizardTransitionParams) {
        if (customWizardTransitionParams == null) {
            return null;
        }
        WizardTransitionParams wizardTransitionParams = new WizardTransitionParams();
        wizardTransitionParams.setGroup(ModelHelper.stringOrIdFromVO((EntityVO)customWizardTransitionParams.getGroup()));
        wizardTransitionParams.setUser(this.usersApiHelper.toUserNew((AbstractSimpleUserRegistrationDTO)customWizardTransitionParams.getUser()));
        wizardTransitionParams.setEmailVerification(customWizardTransitionParams.getEmailVerification());
        wizardTransitionParams.setSmsVerification(customWizardTransitionParams.getSmsVerification());
        wizardTransitionParams.setCustomValues(this.apiHelper.toCustomFieldValuesMap(customWizardTransitionParams.getCustomValues()));
        return wizardTransitionParams;
    }
}

