/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.privacycontrols.PrivacyControlDetailedVO;
import org.cyclos.model.users.privacycontrols.PrivacyControlVO;
import org.cyclos.model.users.privacysettings.PrivacySettingsDTO;
import org.cyclos.model.users.privacysettings.PrivacySettingsData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.PrivacyControl;
import org.cyclos.web.rest.model.PrivacySettingsParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PrivacySettingsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public org.cyclos.web.rest.model.PrivacySettingsData toPrivacySettingsData(PrivacySettingsData privacySettingsData) {
        PrivacySettingsDTO privacySettingsDTO = privacySettingsData.getSetting();
        org.cyclos.web.rest.model.PrivacySettingsData privacySettingsData2 = new org.cyclos.web.rest.model.PrivacySettingsData();
        privacySettingsData2.setCanEdit(privacySettingsData.isEditable());
        CollectionHelper.orEmpty((List)privacySettingsData.getPrivacyControls()).stream().map(this::toPrivacyControl).forEach(privacySettingsData2.getAvailableControls()::add);
        CollectionHelper.orEmpty((Set)privacySettingsDTO.getPrivacyControls()).stream().map(ModelHelper::stringOrIdFromVO).forEach(privacySettingsData2.getSelectedControls()::add);
        CollectionHelper.orEmpty((List)privacySettingsData.getPrivacyControlledProfileFields()).stream().map(this.usersApiHelper::internalName).forEach(privacySettingsData2.getControlledFields()::add);
        privacySettingsData.getPrivacyControlledProfileFields().stream().forEach(profileField -> {
            if (profileField instanceof CustomFieldVO) {
                privacySettingsData2.getCustomFields().add(this.apiHelper.toCustomField((CustomFieldVO)profileField));
            }
        });
        privacySettingsData2.setUser(this.usersApiHelper.toUser((BasicUserVO)privacySettingsDTO.getUser()));
        privacySettingsData2.setEnabled(privacySettingsDTO.isEnablePrivacyControl());
        return privacySettingsData2;
    }

    public PrivacySettingsDTO toPrivacySettingsDTO(String string2, PrivacySettingsParams privacySettingsParams) {
        PrivacySettingsDTO privacySettingsDTO = new PrivacySettingsDTO();
        privacySettingsDTO.setEnablePrivacyControl(privacySettingsParams.getEnabled().booleanValue());
        privacySettingsDTO.setPrivacyControls(privacySettingsParams.getSelectedControls().stream().map(string -> (PrivacyControlVO)ModelHelper.voFromString(PrivacyControlVO.class, (String)string)).collect(Collectors.toSet()));
        privacySettingsDTO.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)string2));
        return privacySettingsDTO;
    }

    private PrivacyControl toPrivacyControl(PrivacyControlDetailedVO privacyControlDetailedVO) {
        if (privacyControlDetailedVO == null) {
            return null;
        }
        PrivacyControl privacyControl = this.apiHelper.newEntity(PrivacyControl.class, privacyControlDetailedVO);
        privacyControl.setFieldsAlwaysVisible(privacyControlDetailedVO.isFieldsAlwaysVisible());
        privacyControl.setInformationText(privacyControlDetailedVO.getInformationText());
        return privacyControl;
    }
}

