/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.cyclos.model.EntityVO;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.messaging.messagecategories.MessageCategoryVO;
import org.cyclos.model.messaging.messages.DetailedMessageVO;
import org.cyclos.model.messaging.messages.IncomingMessageVO;
import org.cyclos.model.messaging.messages.MessageBox;
import org.cyclos.model.messaging.messages.MessageData;
import org.cyclos.model.messaging.messages.MessageDestination;
import org.cyclos.model.messaging.messages.MessageNature;
import org.cyclos.model.messaging.messages.MessageOwner;
import org.cyclos.model.messaging.messages.MessageQuery;
import org.cyclos.model.messaging.messages.MessageSearchData;
import org.cyclos.model.messaging.messages.MessageVO;
import org.cyclos.model.messaging.messages.MessagesStatusVO;
import org.cyclos.model.messaging.messages.OutgoingMessageVO;
import org.cyclos.model.messaging.messages.SendMessageDTO;
import org.cyclos.model.messaging.messages.SendMessageData;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.BaseSendMessage;
import org.cyclos.web.rest.model.Message;
import org.cyclos.web.rest.model.MessageBoxEnum;
import org.cyclos.web.rest.model.MessageCategory;
import org.cyclos.web.rest.model.MessageDataForReply;
import org.cyclos.web.rest.model.MessageDataForSearch;
import org.cyclos.web.rest.model.MessageDataForSend;
import org.cyclos.web.rest.model.MessageDestinationEnum;
import org.cyclos.web.rest.model.MessageKind;
import org.cyclos.web.rest.model.MessageOwnerEnum;
import org.cyclos.web.rest.model.MessageQueryFilters;
import org.cyclos.web.rest.model.MessageResult;
import org.cyclos.web.rest.model.MessageSourceEnum;
import org.cyclos.web.rest.model.MessageView;
import org.cyclos.web.rest.model.MessagesStatus;
import org.cyclos.web.rest.model.RepliedMessage;
import org.cyclos.web.rest.model.ReplyMessage;
import org.cyclos.web.rest.model.SendMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessagesApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;

    public MessageDataForReply toMessageDataForReply(SendMessageData sendMessageData) {
        if (sendMessageData == null) {
            return null;
        }
        MessageDataForReply messageDataForReply = new MessageDataForReply();
        messageDataForReply.setReply(this.toReplyMessage(sendMessageData.getDto()));
        messageDataForReply.setRepliedMessage(this.toRepliedMessage(sendMessageData));
        return messageDataForReply;
    }

    public MessageDataForSearch toMessageDataForSearch(MessageSearchData messageSearchData) {
        MessageDataForSearch messageDataForSearch = new MessageDataForSearch();
        if (CollectionHelper.isNotEmpty((Iterable)messageSearchData.getSendDestinations())) {
            messageDataForSearch.setCanSend(true);
            messageSearchData.getSendDestinations().stream().filter(MessageDestination::isSource).map(this::toMessageSourceEnum).forEach(messageDataForSearch.getSources()::add);
            messageSearchData.getSendDestinations().stream().map(this::toMessageDestinationEnum).forEach(messageDataForSearch.getDestinations()::add);
        }
        messageDataForSearch.setQuery(this.toMessageQueryFilters((MessageQuery)messageSearchData.getQuery()));
        CollectionHelper.orEmpty((List)messageSearchData.getVisibleViewCategories()).stream().map(this::toMessageCategory).forEach(messageDataForSearch.getVisibleCategories()::add);
        return messageDataForSearch;
    }

    public MessageDataForSend toMessageDataForSend(SendMessageData sendMessageData) {
        if (sendMessageData == null) {
            return null;
        }
        MessageDataForSend messageDataForSend = new MessageDataForSend();
        CollectionHelper.orEmpty((List)sendMessageData.getCategories()).stream().map(this::toMessageCategory).forEach(messageDataForSend.getCategories()::add);
        CollectionHelper.orEmpty((List)sendMessageData.getDestinations()).stream().map(this::toMessageDestinationEnum).forEach(messageDataForSend.getDestinations()::add);
        messageDataForSend.setMessage(this.toSendMessage(sendMessageData.getDto()));
        if (messageDataForSend.getDestinations().contains(MessageDestinationEnum.USER)) {
            messageDataForSend.setMaxRecipients(sendMessageData.getMaxRecipients());
        }
        CollectionHelper.orEmpty((List)sendMessageData.getPossibleGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(messageDataForSend.getGroups()::add);
        messageDataForSend.setToUser(this.usersApiHelper.toUser((BasicUserVO)sendMessageData.getToUser()));
        return messageDataForSend;
    }

    public MessageQuery toMessageQuery(MessageQueryFilters messageQueryFilters) {
        MessageQuery messageQuery = this.apiHelper.newQuery(MessageQuery.class, messageQueryFilters);
        messageQuery.setCategory((MessageCategoryVO)ModelHelper.voFromString(MessageCategoryVO.class, (String)messageQueryFilters.getCategory()));
        messageQuery.setDestination(this.toMessageDestination(messageQueryFilters.getDestination()));
        messageQuery.setKeywords(messageQueryFilters.getKeywords());
        messageQuery.setMessageBox(this.toMessageBox(messageQueryFilters.getMessageBox()));
        if (messageQuery.getMessageBox() == null) {
            messageQuery.setMessageBox(MessageBox.INBOX);
        }
        messageQuery.setOnlyUnread(messageQueryFilters.getOnlyUnread());
        messageQuery.setPeriod(this.apiHelper.toDatePeriodDTO(messageQueryFilters.getPeriod()));
        messageQuery.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)messageQueryFilters.getUser()));
        return messageQuery;
    }

    public MessageResult toMessageResult(MessageVO messageVO) {
        if (messageVO == null) {
            return null;
        }
        MessageResult messageResult = this.apiHelper.newEntity(MessageResult.class, messageVO);
        this.fill(messageResult, messageVO);
        return messageResult;
    }

    public MessagesStatus toMessagesStatus(MessagesStatusVO messagesStatusVO) {
        if (messagesStatusVO == null) {
            return null;
        }
        MessagesStatus messagesStatus = new MessagesStatus();
        messagesStatus.setLastViewDate(messagesStatusVO.getLastViewDate());
        messagesStatus.setNewMessages(messagesStatusVO.getNewMessages());
        messagesStatus.setUnreadMessages(messagesStatusVO.getUnreadMessages());
        return messagesStatus;
    }

    public MessageView toMessageView(MessageData messageData) {
        DetailedMessageVO detailedMessageVO = messageData.getMessage();
        MessageView messageView = this.toMessageView(detailedMessageVO);
        messageView.setCanRemove(messageData.isCanRemove());
        messageView.setCanMarkUnread(messageData.isCanMarkUnread());
        messageView.setCanMoveToTrash(messageData.isCanMoveToTrash());
        messageView.setCanRestore(messageData.isCanRestore());
        messageView.setCanReply(messageData.isCanReply());
        CollectionHelper.orEmpty((List)messageData.getReplies()).stream().map(this::toMessage).forEach(messageView.getReplies()::add);
        return messageView;
    }

    @NotNull
    public SendMessageDTO toSendMessageDto(BaseSendMessage baseSendMessage, String string2) {
        SendMessageDTO sendMessageDTO = new SendMessageDTO();
        sendMessageDTO.setToGroups(new HashSet());
        sendMessageDTO.setToUsers(new HashSet());
        sendMessageDTO.setBody(baseSendMessage.getBody());
        sendMessageDTO.setSubject(baseSendMessage.getSubject());
        if (baseSendMessage instanceof SendMessage) {
            SendMessage sendMessage = (SendMessage)baseSendMessage;
            sendMessageDTO.setDestination(this.toMessageDestination(sendMessage.getDestination()));
            sendMessageDTO.setCategory((MessageCategoryVO)ModelHelper.voFromString(MessageCategoryVO.class, (String)sendMessage.getCategory()));
            CollectionHelper.orEmpty(sendMessage.getToGroups()).stream().map(string -> (GroupVO)ModelHelper.voFromString(GroupVO.class, (String)string)).forEach(sendMessageDTO.getToGroups()::add);
            CollectionHelper.orEmpty(sendMessage.getToUsers()).stream().map(string -> (UserVO)ModelHelper.voFromString(UserVO.class, (String)string)).forEach(sendMessageDTO.getToUsers()::add);
        } else if (baseSendMessage instanceof ReplyMessage) {
            sendMessageDTO.setReplyToId(this.apiHelper.fromId(string2));
        } else {
            return null;
        }
        return sendMessageDTO;
    }

    private void fill(Message message, MessageVO messageVO) {
        message.setKind(this.toMessageKind(messageVO.getNature()));
        message.setCategory(this.toMessageCategory(messageVO.getCategory()));
        message.setDate(messageVO.getDate());
        message.setSubject(messageVO.getSubject());
    }

    private void fill(MessageResult messageResult, MessageVO messageVO) {
        this.fill((Message)messageResult, messageVO);
        messageResult.setRead(messageVO.isRead());
        messageResult.setReplied(messageVO.isReplied());
        if (messageVO instanceof IncomingMessageVO) {
            IncomingMessageVO incomingMessageVO = (IncomingMessageVO)messageVO;
            messageResult.setFromOwner(this.usersApiHelper.toUser((BasicUserVO)incomingMessageVO.getFromUser()));
            messageResult.setFromOwnerKind(this.toMessageOwnerEnum(incomingMessageVO.getFromOwner()));
        } else if (messageVO instanceof OutgoingMessageVO) {
            OutgoingMessageVO outgoingMessageVO = (OutgoingMessageVO)messageVO;
            messageResult.setDestination(this.toMessageDestinationEnum(outgoingMessageVO.getDestination()));
            messageResult.setSentBy(this.usersApiHelper.toUser((BasicUserVO)outgoingMessageVO.getSentBy()));
            CollectionHelper.orEmpty((List)outgoingMessageVO.getToGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(messageResult.getToGroups()::add);
            CollectionHelper.orEmpty((List)outgoingMessageVO.getToUsers()).stream().map(this.usersApiHelper::toUser).forEach(messageResult.getToUsers()::add);
        }
    }

    private void fill(MessageView messageView, MessageVO messageVO) {
        this.fill((MessageResult)messageView, messageVO);
        messageView.setOwner(this.usersApiHelper.toUser((BasicUserVO)messageVO.getOwner()));
        messageView.setOwnerKind(this.toMessageOwnerEnum(messageVO.getMessageOwner()));
        messageView.setRemovedAt(messageVO.getRemovedAt());
    }

    private Message toMessage(MessageVO messageVO) {
        if (messageVO == null) {
            return null;
        }
        Message message = this.apiHelper.newEntity(Message.class, messageVO);
        this.fill(message, messageVO);
        return message;
    }

    private MessageBox toMessageBox(MessageBoxEnum messageBoxEnum) {
        if (messageBoxEnum == null) {
            return null;
        }
        switch (messageBoxEnum) {
            case INBOX: {
                return MessageBox.INBOX;
            }
            case SENT: {
                return MessageBox.SENT_ITEMS;
            }
            case TRASH: {
                return MessageBox.TRASH;
            }
        }
        return null;
    }

    private MessageBoxEnum toMessageBoxEnum(MessageBox messageBox) {
        if (messageBox == null) {
            return null;
        }
        switch (messageBox) {
            case INBOX: {
                return MessageBoxEnum.INBOX;
            }
            case SENT_ITEMS: {
                return MessageBoxEnum.SENT;
            }
            case TRASH: {
                return MessageBoxEnum.TRASH;
            }
        }
        return null;
    }

    private MessageCategory toMessageCategory(MessageCategoryVO messageCategoryVO) {
        if (messageCategoryVO == null) {
            return null;
        }
        return this.apiHelper.newEntity(MessageCategory.class, messageCategoryVO);
    }

    private MessageDestination toMessageDestination(MessageDestinationEnum messageDestinationEnum) {
        if (messageDestinationEnum == null) {
            return null;
        }
        switch (messageDestinationEnum) {
            case BROKERED: {
                return MessageDestination.BROKERED;
            }
            case GROUP: {
                return MessageDestination.GROUP;
            }
            case SYSTEM: {
                return MessageDestination.SYSTEM;
            }
            case USER: {
                return MessageDestination.USER;
            }
        }
        return null;
    }

    private MessageDestinationEnum toMessageDestinationEnum(MessageDestination messageDestination) {
        if (messageDestination == null) {
            return null;
        }
        switch (messageDestination) {
            case BROKERED: {
                return MessageDestinationEnum.BROKERED;
            }
            case GROUP: {
                return MessageDestinationEnum.GROUP;
            }
            case SYSTEM: {
                return MessageDestinationEnum.SYSTEM;
            }
            case USER: {
                return MessageDestinationEnum.USER;
            }
        }
        return null;
    }

    private MessageKind toMessageKind(MessageNature messageNature) {
        if (messageNature == null) {
            return null;
        }
        switch (messageNature) {
            case INCOMING: {
                return MessageKind.INCOMING;
            }
            case OUTGOING: {
                return MessageKind.OUTGOING;
            }
        }
        return null;
    }

    private MessageOwnerEnum toMessageOwnerEnum(MessageOwner messageOwner) {
        if (messageOwner == null) {
            return null;
        }
        switch (messageOwner) {
            case SYSTEM: {
                return MessageOwnerEnum.SYSTEM;
            }
            case USER: {
                return MessageOwnerEnum.USER;
            }
        }
        return null;
    }

    private MessageQueryFilters toMessageQueryFilters(MessageQuery messageQuery) {
        if (messageQuery == null) {
            return null;
        }
        MessageQueryFilters messageQueryFilters = this.apiHelper.newQueryFilters(MessageQueryFilters.class, (QueryParameters)messageQuery);
        messageQueryFilters.setCategory(ModelHelper.stringOrIdFromVO((EntityVO)messageQuery.getCategory()));
        messageQueryFilters.setDestination(this.toMessageDestinationEnum(messageQuery.getDestination()));
        messageQueryFilters.setKeywords(messageQuery.getKeywords());
        messageQueryFilters.setMessageBox(this.toMessageBoxEnum(messageQuery.getMessageBox()));
        messageQueryFilters.setOnlyUnread(messageQuery.getOnlyUnread());
        messageQueryFilters.setPeriod(this.apiHelper.toFilter(messageQuery.getPeriod()));
        messageQueryFilters.setUser(ModelHelper.stringOrIdFromVO((EntityVO)messageQuery.getUser()));
        return messageQueryFilters;
    }

    private MessageSourceEnum toMessageSourceEnum(MessageDestination messageDestination) {
        if (messageDestination == null || !messageDestination.isSource()) {
            return null;
        }
        switch (messageDestination) {
            case BROKERED: 
            case GROUP: {
                break;
            }
            case SYSTEM: {
                return MessageSourceEnum.SYSTEM;
            }
            case USER: {
                return MessageSourceEnum.USER;
            }
        }
        return null;
    }

    private MessageView toMessageView(DetailedMessageVO detailedMessageVO) {
        if (detailedMessageVO == null) {
            return null;
        }
        MessageView messageView = this.apiHelper.newEntity(MessageView.class, detailedMessageVO);
        this.fill(messageView, (MessageVO)detailedMessageVO);
        messageView.setBody(detailedMessageVO.getBody());
        messageView.setReplyPosition(detailedMessageVO.getReplyPosition());
        return messageView;
    }

    private RepliedMessage toRepliedMessage(SendMessageData sendMessageData) {
        if (StringHelper.isBlank((Object)sendMessageData.getRepliedBody())) {
            return null;
        }
        RepliedMessage repliedMessage = new RepliedMessage();
        repliedMessage.setBody(sendMessageData.getRepliedBody());
        repliedMessage.setDate(sendMessageData.getRepliedDate());
        repliedMessage.setFrom(this.usersApiHelper.toUser((BasicUserVO)sendMessageData.getRepliedFrom()));
        repliedMessage.setSubject(sendMessageData.getRepliedSubject());
        return repliedMessage;
    }

    private ReplyMessage toReplyMessage(SendMessageDTO sendMessageDTO) {
        if (sendMessageDTO == null) {
            return null;
        }
        ReplyMessage replyMessage = new ReplyMessage();
        replyMessage.setBody(sendMessageDTO.getBody());
        replyMessage.setSubject(sendMessageDTO.getSubject());
        return replyMessage;
    }

    private SendMessage toSendMessage(SendMessageDTO sendMessageDTO) {
        if (sendMessageDTO == null) {
            return null;
        }
        SendMessage sendMessage = new SendMessage();
        sendMessage.setBody(sendMessageDTO.getBody());
        sendMessage.setSubject(sendMessageDTO.getSubject());
        sendMessage.setCategory(ModelHelper.stringOrIdFromVO((EntityVO)sendMessageDTO.getCategory()));
        sendMessage.setDestination(this.toMessageDestinationEnum(sendMessageDTO.getDestination()));
        CollectionHelper.orEmpty((Set)sendMessageDTO.getToGroups()).stream().map(ModelHelper::stringOrIdFromVO).forEach(sendMessage.getToGroups()::add);
        CollectionHelper.orEmpty((Set)sendMessageDTO.getToUsers()).stream().map(ModelHelper::stringOrIdFromVO).forEach(sendMessage.getToUsers()::add);
        return sendMessage;
    }
}

