/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.net.URI;
import java.util.List;
import java.util.stream.Stream;
import org.cyclos.model.EntityModel;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.contentmanagement.themes.ThemeImageType;
import org.cyclos.model.contentmanagement.themes.ThemeImageVO;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.configurations.ConfigurationImageVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.images.FullSystemImageCategoryListData;
import org.cyclos.model.system.images.FullSystemImagesListData;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.ImagesListData;
import org.cyclos.model.system.images.TempImageTarget;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.StoredFileVO;
import org.cyclos.server.model.users.users.UserProfileImagesData;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.services.contentmanagement.ThemeImageService;
import org.cyclos.services.system.ConfigurationImageService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.FilesApiHelper;
import org.cyclos.web.rest.model.Image;
import org.cyclos.web.rest.model.ImageConfigurationForUserProfile;
import org.cyclos.web.rest.model.ImageKind;
import org.cyclos.web.rest.model.ImageView;
import org.cyclos.web.rest.model.LogoKind;
import org.cyclos.web.rest.model.SystemImageCategoryListData;
import org.cyclos.web.rest.model.SystemImagesListData;
import org.cyclos.web.rest.model.TempImageTargetEnum;
import org.cyclos.web.rest.model.ThemeImageKind;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImagesApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private FilesApiHelper filesApiHelper;
    @Autowired
    private ConfigurationImageService configurationImageService;
    @Autowired
    private ThemeImageService themeImageService;

    public ConfigurationImageVO getConfigurationImage(String string, LogoKind logoKind) {
        ConfigurationVO configurationVO = (ConfigurationVO)ModelHelper.voFromString(ConfigurationVO.class, (String)string);
        ConfigurationImageType configurationImageType = this.toConfigurationImageType(logoKind);
        return this.configurationImageService.getImageVO(configurationVO, configurationImageType);
    }

    public ThemeImageVO getThemeImage(String string, ThemeImageKind themeImageKind, String string2) {
        Long l = this.apiHelper.fromId(string);
        ThemeImageType themeImageType = this.toThemeImageType(themeImageKind);
        return this.themeImageService.getImageVO(l, themeImageType, string2);
    }

    public URI imageURI(ImageVO imageVO) {
        return ServerImageHelper.imageURI((ImageVO)imageVO, (RequestData)ServletHelper.getRequestData(), null);
    }

    public String imageURL(ImageVO imageVO) {
        return this.imageURL(imageVO, null, null);
    }

    public String imageURL(ImageVO imageVO, Integer n, Integer n2) {
        URI uRI = this.imageURI(imageVO);
        if (uRI == null) {
            return null;
        }
        Object object = uRI.toString();
        if (n != null || n2 != null) {
            object = (String)object + "?";
            if (n != null) {
                object = (String)object + "width=" + n;
                if (n2 != null) {
                    object = (String)object + "&";
                }
            }
            if (n2 != null) {
                object = (String)object + "height=" + n2;
            }
        }
        return object;
    }

    public ConfigurationImageType toConfigurationImageType(LogoKind logoKind) {
        if (logoKind != null) {
            switch (logoKind) {
                case FRONTEND: {
                    return ConfigurationImageType.APP_LOGO;
                }
                case MASKABLE: {
                    return ConfigurationImageType.MASKABLE_LOGO;
                }
                case MOBILE: {
                    return ConfigurationImageType.MOBILE_LOGO;
                }
                case PAY: {
                    return ConfigurationImageType.PAY_LOGO;
                }
                case REPORT: {
                    return ConfigurationImageType.REPORTS_LOGO;
                }
                case CLASSIC_SHORTCUT: {
                    return ConfigurationImageType.SHORTCUT_ICON;
                }
                case CLASSIC: {
                    return ConfigurationImageType.SYSTEM_LOGO;
                }
            }
        }
        return null;
    }

    public Image toImage(ImageVO imageVO) {
        if (imageVO == null) {
            return null;
        }
        return this.newImage(Image.class, imageVO);
    }

    public ImageConfigurationForUserProfile toImageConfigurationForUserProfile(UserProfileImagesData userProfileImagesData) {
        if (userProfileImagesData == null) {
            return null;
        }
        ImageConfigurationForUserProfile imageConfigurationForUserProfile = new ImageConfigurationForUserProfile();
        imageConfigurationForUserProfile.setAvailability(this.apiHelper.toAvailability(userProfileImagesData.getMaxImages() > 0, userProfileImagesData.isRequired()));
        imageConfigurationForUserProfile.setManage(userProfileImagesData.isCanManage());
        imageConfigurationForUserProfile.setMaxImages(userProfileImagesData.getMaxImages());
        return imageConfigurationForUserProfile;
    }

    public ImageKind toImageKind(ImageNature imageNature) {
        if (imageNature != null) {
            switch (imageNature) {
                case AD: {
                    return ImageKind.MARKETPLACE;
                }
                case SYSTEM_CUSTOM: {
                    return ImageKind.SYSTEM_CUSTOM;
                }
                case TEMP: {
                    return ImageKind.TEMP;
                }
                case USER: {
                    return ImageKind.PROFILE;
                }
                case USER_CUSTOM: {
                    return ImageKind.USER_CUSTOM;
                }
                case CUSTOM_FIELD_VALUE: {
                    return ImageKind.CUSTOM_FIELD_VALUE;
                }
                case BULK_ACTION: {
                    return ImageKind.BULK_ACTION;
                }
                case CONTACT_INFO: {
                    return ImageKind.CONTACT_INFO;
                }
                case VOUCHER_TYPE: {
                    return ImageKind.VOUCHER_TYPE;
                }
                case VOUCHER_CATEGORY: {
                    return ImageKind.VOUCHER_CATEGORY;
                }
                case VOUCHER_TEMPLATE: {
                    return ImageKind.VOUCHER_TEMPLATE;
                }
                case OIDC_CLIENT: {
                    return ImageKind.OIDC_CLIENT;
                }
                case IDENTITY_PROVIDER: {
                    return ImageKind.IDENTITY_PROVIDER;
                }
                case AD_CATEGORY: {
                    return ImageKind.MARKETPLACE_CATEGORY;
                }
                case CONFIGURATION: 
                case THEME: 
                case IMPORTED: 
                case DEFAULT_USER: {
                    return null;
                }
            }
        }
        return null;
    }

    public ImageNature toImageNature(ImageKind imageKind) {
        if (imageKind != null) {
            switch (imageKind) {
                case MARKETPLACE: {
                    return ImageNature.AD;
                }
                case PROFILE: {
                    return ImageNature.USER;
                }
                case SYSTEM_CUSTOM: {
                    return ImageNature.SYSTEM_CUSTOM;
                }
                case TEMP: {
                    return ImageNature.TEMP;
                }
                case USER_CUSTOM: {
                    return ImageNature.USER_CUSTOM;
                }
                case CUSTOM_FIELD_VALUE: {
                    return ImageNature.CUSTOM_FIELD_VALUE;
                }
                case BULK_ACTION: {
                    return ImageNature.BULK_ACTION;
                }
                case CONTACT_INFO: {
                    return ImageNature.CONTACT_INFO;
                }
                case VOUCHER_TYPE: {
                    return ImageNature.VOUCHER_TYPE;
                }
                case VOUCHER_CATEGORY: {
                    return ImageNature.VOUCHER_CATEGORY;
                }
                case VOUCHER_TEMPLATE: {
                    return ImageNature.VOUCHER_TEMPLATE;
                }
                case OIDC_CLIENT: {
                    return ImageNature.OIDC_CLIENT;
                }
                case IDENTITY_PROVIDER: {
                    return ImageNature.IDENTITY_PROVIDER;
                }
                case MARKETPLACE_CATEGORY: {
                    return ImageNature.AD_CATEGORY;
                }
            }
        }
        return null;
    }

    public org.cyclos.web.rest.model.ImagesListData toImagesListData(ImagesListData imagesListData) {
        org.cyclos.web.rest.model.ImagesListData imagesListData2 = new org.cyclos.web.rest.model.ImagesListData();
        imagesListData2.setCanEdit(imagesListData.isCanManage());
        imagesListData2.setMaxImages(imagesListData.getMaxImages());
        CollectionHelper.orEmpty((List)imagesListData.getImages()).stream().map(this::toImage).forEach(imagesListData2.getImages()::add);
        imagesListData2.setCanCreate(imagesListData.isCanCreate());
        imagesListData2.setAvailability(this.apiHelper.toAvailability(imagesListData.getMaxImages() == null || imagesListData.getMaxImages() != 0, imagesListData.isRequired()));
        return imagesListData2;
    }

    public ImageView toImageView(ImageVO imageVO) {
        if (imageVO == null) {
            return null;
        }
        ImageView imageView = this.newImage(ImageView.class, imageVO);
        ImageNature imageNature = ModelHelper.resolveImageNature((ImageVO)imageVO);
        imageView.setKind(this.toImageKind(imageNature));
        imageView.setConvertedToJpeg(imageVO.isConvertedToJpeg());
        return imageView;
    }

    public LogoKind toLogoKind(ConfigurationImageType configurationImageType) {
        String string = ServerImageHelper.toLogoKind((ConfigurationImageType)configurationImageType);
        return Stream.of(LogoKind.values()).filter(logoKind -> logoKind.toString().equals(string)).findAny().orElse(null);
    }

    public SystemImagesListData toSystemImagesListData(FullSystemImagesListData fullSystemImagesListData) {
        SystemImagesListData systemImagesListData = new SystemImagesListData();
        CollectionHelper.orEmpty((List)fullSystemImagesListData.getCategories()).stream().map(this::toSystemImageCategoryListData).forEach(systemImagesListData.getCategories()::add);
        return systemImagesListData;
    }

    public TempImageTarget toTempImageTarget(TempImageTargetEnum tempImageTargetEnum) {
        if (tempImageTargetEnum != null) {
            switch (tempImageTargetEnum) {
                case ADVERTISEMENT: {
                    return TempImageTarget.ADVERTISEMENT;
                }
                case CONTACT_INFO: {
                    return TempImageTarget.CONTACT_INFO;
                }
                case CUSTOM_VALUE: {
                    return TempImageTarget.CUSTOM_VALUE;
                }
                case USER_PROFILE: {
                    return TempImageTarget.USER_PROFILE;
                }
                case USER_REGISTRATION: {
                    return TempImageTarget.USER_REGISTRATION;
                }
            }
        }
        return null;
    }

    public ThemeImageKind toThemeImageKind(ThemeImageType themeImageType) {
        String string = ServerImageHelper.toThemeImageKind((ThemeImageType)themeImageType);
        return Stream.of(ThemeImageKind.values()).filter(themeImageKind -> themeImageKind.toString().equals(string)).findAny().orElse(null);
    }

    private <I extends Image> I newImage(Class<I> clazz, ImageVO imageVO) {
        Image image = (Image)this.filesApiHelper.newStoredFile(clazz, (StoredFileVO)imageVO);
        if (imageVO.getKey() != null) {
            image.setId(imageVO.getKey());
        }
        image.setWidth(imageVO.getWidth());
        image.setHeight(imageVO.getHeight());
        image.setUrl(StringHelper.trimToNull((Object)this.imageURI(imageVO)));
        return (I)image;
    }

    private SystemImageCategoryListData toSystemImageCategoryListData(FullSystemImageCategoryListData fullSystemImageCategoryListData) {
        SystemImageCategoryListData systemImageCategoryListData = new SystemImageCategoryListData();
        systemImageCategoryListData.setCanCreate(fullSystemImageCategoryListData.isEditable());
        systemImageCategoryListData.setCanEdit(fullSystemImageCategoryListData.isEditable());
        systemImageCategoryListData.setCategory(this.apiHelper.toReference((EntityModel)fullSystemImageCategoryListData.getCategory()));
        CollectionHelper.orEmpty((List)fullSystemImageCategoryListData.getImages()).stream().map(this::toImage).forEach(systemImageCategoryListData.getImages()::add);
        return systemImageCategoryListData;
    }

    private ThemeImageType toThemeImageType(ThemeImageKind themeImageKind) {
        if (themeImageKind != null) {
            switch (themeImageKind) {
                case BACKGROUND: {
                    return ThemeImageType.BACKGROUND;
                }
                case CUSTOM: {
                    return ThemeImageType.CUSTOM;
                }
                case MAP_MARKER: {
                    return ThemeImageType.MAP_MARKER;
                }
                case MOBILE: {
                    return ThemeImageType.MOBILE;
                }
            }
        }
        return null;
    }
}

