/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.users.brokering.AddBrokerData;
import org.cyclos.model.users.brokering.BrokeringAction;
import org.cyclos.model.users.brokering.BrokeringData;
import org.cyclos.model.users.brokering.BrokeringLogVO;
import org.cyclos.model.users.brokering.BrokeringVO;
import org.cyclos.model.users.brokering.BrokeringWithUserVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.BrokerDataForAdd;
import org.cyclos.web.rest.model.Brokering;
import org.cyclos.web.rest.model.BrokeringActionEnum;
import org.cyclos.web.rest.model.BrokeringLog;
import org.cyclos.web.rest.model.BrokeringView;
import org.cyclos.web.rest.model.UserBrokersData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BrokeringApiHelper {
    @Autowired
    private GroupsApiHelper groupsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public BrokerDataForAdd toBrokerDataForAdd(AddBrokerData addBrokerData) {
        BrokerDataForAdd brokerDataForAdd = new BrokerDataForAdd();
        brokerDataForAdd.setUser(this.usersApiHelper.toUser((BasicUserVO)addBrokerData.getUser()));
        CollectionHelper.orEmpty((List)addBrokerData.getBrokers()).stream().map(this.usersApiHelper::toUser).forEach(brokerDataForAdd.getBrokers()::add);
        CollectionHelper.orEmpty((List)addBrokerData.getPossibleBrokerGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(brokerDataForAdd.getBrokerGroups()::add);
        return brokerDataForAdd;
    }

    public BrokeringActionEnum toBrokeringActionEnum(BrokeringAction brokeringAction) {
        if (brokeringAction != null) {
            switch (brokeringAction) {
                case SET_MAIN_BROKER: {
                    return BrokeringActionEnum.SET_MAIN;
                }
                case ADD_BROKER: {
                    return BrokeringActionEnum.ADD;
                }
                case REMOVE_BROKER: {
                    return BrokeringActionEnum.REMOVE;
                }
            }
        }
        return null;
    }

    public BrokeringView toBrokeringView(BrokeringWithUserVO brokeringWithUserVO) {
        if (brokeringWithUserVO == null) {
            return null;
        }
        BrokeringView brokeringView = this.newBrokering(BrokeringView.class, (BrokeringVO)brokeringWithUserVO);
        brokeringView.setUser(this.usersApiHelper.toUser((BasicUserVO)brokeringWithUserVO.getUser()));
        return brokeringView;
    }

    public UserBrokersData toUserBrokersData(BrokeringData brokeringData) {
        UserBrokersData userBrokersData = new UserBrokersData();
        userBrokersData.setUser(this.usersApiHelper.toUser((BasicUserVO)brokeringData.getUser()));
        userBrokersData.setEditable(brokeringData.isEditable());
        CollectionHelper.orEmpty((List)brokeringData.getBrokerings()).stream().map(this::toBrokering).forEach(userBrokersData.getBrokers()::add);
        CollectionHelper.orEmpty((List)brokeringData.getLogs()).stream().map(this::toBrokeringLog).forEach(userBrokersData.getHistory()::add);
        return userBrokersData;
    }

    private <B extends Brokering> B newBrokering(Class<B> clazz, BrokeringVO brokeringVO) {
        Brokering brokering = (Brokering)ClassHelper.instantiate(clazz);
        brokering.setBroker(this.usersApiHelper.toUser((BasicUserVO)brokeringVO.getBroker()));
        brokering.setMain(brokeringVO.isMain());
        brokering.setSince(brokeringVO.getBeginDate());
        return (B)brokering;
    }

    private Brokering toBrokering(BrokeringVO brokeringVO) {
        return brokeringVO == null ? null : this.newBrokering(Brokering.class, brokeringVO);
    }

    private BrokeringLog toBrokeringLog(BrokeringLogVO brokeringLogVO) {
        BrokeringLog brokeringLog = new BrokeringLog();
        brokeringLog.setBroker(this.usersApiHelper.toUser((BasicUserVO)brokeringLogVO.getBroker()));
        brokeringLog.setBy(this.usersApiHelper.toUser((BasicUserVO)brokeringLogVO.getBy()));
        brokeringLog.setDate(brokeringLogVO.getDate());
        brokeringLog.setAction(this.toBrokeringActionEnum(brokeringLogVO.getAction()));
        return brokeringLog;
    }
}

