/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitDTO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitLogVO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitVO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.AccountLimitsOverviewData;
import org.cyclos.model.banking.accounts.UserAccountBalanceLimitData;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.users.UserService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.BalanceLimitsApi;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AccountBalanceLimitsData;
import org.cyclos.web.rest.model.AccountBalanceLimitsLog;
import org.cyclos.web.rest.model.AccountBalanceLimitsResult;
import org.cyclos.web.rest.model.DataForBalanceLimitsSearch;
import org.cyclos.web.rest.model.GeneralAccountBalanceLimitsResult;
import org.cyclos.web.rest.model.SetAccountBalanceLimits;
import org.cyclos.web.rest.model.UserAccountBalanceLimitsListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BalanceLimitsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private UserService userService;
    @Autowired
    private GroupsApiHelper groupsApiHelper;

    public AccountBalanceLimitDTO toAccountBalanceLimitDTO(BalanceLimitsApi.SetAccountBalanceLimitsParams setAccountBalanceLimitsParams) {
        SetAccountBalanceLimits setAccountBalanceLimits = setAccountBalanceLimitsParams.setAccountBalanceLimits;
        AccountBalanceLimitDTO accountBalanceLimitDTO = new AccountBalanceLimitDTO();
        accountBalanceLimitDTO.setAccount(this.accountsApiHelper.toAccountVO(setAccountBalanceLimitsParams.user, setAccountBalanceLimitsParams.accountType));
        accountBalanceLimitDTO.setConfirmationPassword(setAccountBalanceLimitsParams.confirmationPassword);
        accountBalanceLimitDTO.setCreditLimit(setAccountBalanceLimits.getCreditLimit());
        accountBalanceLimitDTO.setCreditLimitFromProduct(!Boolean.TRUE.equals(setAccountBalanceLimits.getCustomCreditLimit()));
        accountBalanceLimitDTO.setUpperCreditLimit(setAccountBalanceLimits.getUpperCreditLimit());
        accountBalanceLimitDTO.setUpperCreditLimitFromProduct(!Boolean.TRUE.equals(setAccountBalanceLimits.getCustomUpperCreditLimit()));
        accountBalanceLimitDTO.setDescription(setAccountBalanceLimits.getComment());
        return accountBalanceLimitDTO;
    }

    public AccountBalanceLimitsData toAccountBalanceLimitsData(UserAccountBalanceLimitData userAccountBalanceLimitData) {
        AccountBalanceLimitsData accountBalanceLimitsData = new AccountBalanceLimitsData();
        AccountBalanceLimitDTO accountBalanceLimitDTO = userAccountBalanceLimitData.getDto();
        accountBalanceLimitsData.setAccount(this.accountsApiHelper.toAccountWithCurrency(accountBalanceLimitDTO.getAccount(), accountBalanceLimitDTO.getCurrency()));
        accountBalanceLimitsData.setUser(this.usersApiHelper.toUser((BasicUserVO)((UserVO)userAccountBalanceLimitData.getDto().getAccount().getOwner())));
        accountBalanceLimitsData.setEditable(userAccountBalanceLimitData.isEditable());
        accountBalanceLimitsData.setCreditLimit(accountBalanceLimitDTO.getCreditLimit());
        accountBalanceLimitsData.setCustomCreditLimit(!accountBalanceLimitDTO.isCreditLimitFromProduct());
        accountBalanceLimitsData.setUpperCreditLimit(accountBalanceLimitDTO.getUpperCreditLimit());
        accountBalanceLimitsData.setCustomUpperCreditLimit(!accountBalanceLimitDTO.isUpperCreditLimitFromProduct());
        accountBalanceLimitsData.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)userAccountBalanceLimitData.getConfirmationPasswordInput()));
        accountBalanceLimitsData.setDefaultCreditLimit(userAccountBalanceLimitData.getProductsCreditLimit().getAmount());
        accountBalanceLimitsData.setDefaultUpperCreditLimit(userAccountBalanceLimitData.getProductsUpperCreditLimit().getAmount());
        CollectionHelper.orEmpty((List)userAccountBalanceLimitData.getAccountLimitLog()).stream().map(this::toAccountBalanceLimitsLog).forEach(accountBalanceLimitsData.getHistory()::add);
        return accountBalanceLimitsData;
    }

    public AccountBalanceLimitsOverviewQuery toAccountBalanceLimitsOverviewQuery(BalanceLimitsApi.SearchAccountBalanceLimitsParams searchAccountBalanceLimitsParams) {
        AccountBalanceLimitsOverviewQuery accountBalanceLimitsOverviewQuery = this.apiHelper.newQuery(AccountBalanceLimitsOverviewQuery.class, searchAccountBalanceLimitsParams.page, searchAccountBalanceLimitsParams.pageSize, searchAccountBalanceLimitsParams.skipTotalCount);
        accountBalanceLimitsOverviewQuery.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)searchAccountBalanceLimitsParams.currency));
        accountBalanceLimitsOverviewQuery.setAccountType((AccountTypeVO)ModelHelper.voFromString(AccountTypeVO.class, (String)searchAccountBalanceLimitsParams.accountType));
        accountBalanceLimitsOverviewQuery.setChangedBy((UserVO)ModelHelper.voFromString(UserVO.class, (String)searchAccountBalanceLimitsParams.by));
        accountBalanceLimitsOverviewQuery.setGroups(CollectionHelper.orEmpty(searchAccountBalanceLimitsParams.groups).stream().map(string -> (BasicGroupVO)ModelHelper.voFromString(BasicGroupVO.class, (String)string)).collect(Collectors.toSet()));
        accountBalanceLimitsOverviewQuery.setBrokers(CollectionHelper.orEmpty(searchAccountBalanceLimitsParams.brokers).stream().map(string -> (UserVO)ModelHelper.voFromString(UserVO.class, (String)string)).collect(Collectors.toSet()));
        accountBalanceLimitsOverviewQuery.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)searchAccountBalanceLimitsParams.user));
        accountBalanceLimitsOverviewQuery.setPersonalizedNegativeLimit(searchAccountBalanceLimitsParams.customLimit);
        accountBalanceLimitsOverviewQuery.setNegativeLimitRange(this.apiHelper.toDecimalRangeDTO(searchAccountBalanceLimitsParams.customLimitRange));
        accountBalanceLimitsOverviewQuery.setPersonalizedPositiveLimit(searchAccountBalanceLimitsParams.customUpperLimit);
        accountBalanceLimitsOverviewQuery.setPositiveLimitRange(this.apiHelper.toDecimalRangeDTO(searchAccountBalanceLimitsParams.customUpperLimitRange));
        return accountBalanceLimitsOverviewQuery;
    }

    public DataForBalanceLimitsSearch toDataForBalanceLimitsSearch(AccountLimitsOverviewData accountLimitsOverviewData) {
        DataForBalanceLimitsSearch dataForBalanceLimitsSearch = new DataForBalanceLimitsSearch();
        CollectionHelper.orEmpty((List)accountLimitsOverviewData.getManagedGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(dataForBalanceLimitsSearch.getGroups()::add);
        CollectionHelper.orEmpty((List)accountLimitsOverviewData.getUserAccountTypes()).stream().map(this.accountsApiHelper::toAccountType).forEach(dataForBalanceLimitsSearch.getAccountTypes()::add);
        CollectionHelper.orEmpty((List)accountLimitsOverviewData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(dataForBalanceLimitsSearch.getExportFormats()::add);
        return dataForBalanceLimitsSearch;
    }

    public GeneralAccountBalanceLimitsResult toGeneralAccountBalanceLimitsResult(AccountBalanceLimitVO accountBalanceLimitVO) {
        GeneralAccountBalanceLimitsResult generalAccountBalanceLimitsResult = this.newResult(GeneralAccountBalanceLimitsResult.class, accountBalanceLimitVO);
        generalAccountBalanceLimitsResult.setUser(this.usersApiHelper.toUser((BasicUserVO)((UserVO)accountBalanceLimitVO.getAccount().getOwner())));
        return generalAccountBalanceLimitsResult;
    }

    public UserAccountBalanceLimitsListData toUserAccountBalanceLimitsListData(String string, List<AccountBalanceLimitVO> list) {
        UserAccountBalanceLimitsListData userAccountBalanceLimitsListData = new UserAccountBalanceLimitsListData();
        UserVO userVO = null;
        if (CollectionHelper.isEmpty(list)) {
            userVO = this.userService.locate((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        } else {
            userVO = (UserVO)((AccountBalanceLimitVO)CollectionHelper.first(list)).getAccount().getOwner();
            list.stream().map(this::toAccountBalanceLimitsResult).forEach(userAccountBalanceLimitsListData.getAccountLimits()::add);
        }
        userAccountBalanceLimitsListData.setUser(this.usersApiHelper.toUser((BasicUserVO)userVO));
        return userAccountBalanceLimitsListData;
    }

    private <R extends AccountBalanceLimitsResult> R newResult(Class<R> clazz, AccountBalanceLimitVO accountBalanceLimitVO) {
        AccountBalanceLimitsResult accountBalanceLimitsResult = (AccountBalanceLimitsResult)ClassHelper.instantiate(clazz);
        accountBalanceLimitsResult.setAccount(this.accountsApiHelper.toAccountWithCurrency(accountBalanceLimitVO.getAccount()));
        accountBalanceLimitsResult.setCreditLimit(accountBalanceLimitVO.getCreditLimit());
        accountBalanceLimitsResult.setCustomCreditLimit(!accountBalanceLimitVO.isCreditLimitFromProduct());
        if (accountBalanceLimitVO.getUpperCreditLimit() != null) {
            accountBalanceLimitsResult.setUpperCreditLimit(accountBalanceLimitVO.getUpperCreditLimit());
        }
        accountBalanceLimitsResult.setCustomUpperCreditLimit(!accountBalanceLimitVO.isUpperCreditLimitFromProduct());
        return (R)accountBalanceLimitsResult;
    }

    private AccountBalanceLimitsLog toAccountBalanceLimitsLog(AccountBalanceLimitLogVO accountBalanceLimitLogVO) {
        AccountBalanceLimitsLog accountBalanceLimitsLog = new AccountBalanceLimitsLog();
        accountBalanceLimitsLog.setDate(accountBalanceLimitLogVO.getModifiedAt());
        accountBalanceLimitsLog.setBy(this.usersApiHelper.toUser(accountBalanceLimitLogVO.getBy()));
        accountBalanceLimitsLog.setComment(accountBalanceLimitLogVO.getDescription());
        accountBalanceLimitsLog.setCreditLimit(accountBalanceLimitLogVO.getCreditLimit());
        accountBalanceLimitsLog.setCustomCreditLimit(!accountBalanceLimitLogVO.isCreditLimitFromProduct());
        accountBalanceLimitsLog.setUpperCreditLimit(accountBalanceLimitLogVO.getUpperCreditLimit());
        accountBalanceLimitsLog.setCustomUpperCreditLimit(!accountBalanceLimitLogVO.isUpperCreditLimitFromProduct());
        return accountBalanceLimitsLog;
    }

    private AccountBalanceLimitsResult toAccountBalanceLimitsResult(AccountBalanceLimitVO accountBalanceLimitVO) {
        return this.newResult(AccountBalanceLimitsResult.class, accountBalanceLimitVO);
    }
}

