/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import org.cyclos.model.marketplace.advertisements.AdQuestionQuery;
import org.cyclos.model.marketplace.advertisements.AdQuestionVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.MarketplaceApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AdQuestion;
import org.cyclos.web.rest.model.AdQuestionQueryFilters;
import org.cyclos.web.rest.model.AdQuestionResult;
import org.cyclos.web.rest.model.AdQuestionView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdQuestionsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private MarketplaceApiHelper marketplaceApiHelper;

    public AdQuestion toAdQuestion(AdQuestionVO adQuestionVO) {
        AdQuestion adQuestion = this.newAdQuestion(AdQuestion.class, adQuestionVO);
        return adQuestion;
    }

    public AdQuestionQuery toAdQuestionQuery(String string, AdQuestionQueryFilters adQuestionQueryFilters) {
        AdQuestionQuery adQuestionQuery = this.apiHelper.newQuery(AdQuestionQuery.class, adQuestionQueryFilters);
        adQuestionQuery.setSeller((UserVO)ModelHelper.voFromString(UserVO.class, (String)string));
        adQuestionQuery.setType(this.marketplaceApiHelper.toAdType(adQuestionQueryFilters.getKind()));
        return adQuestionQuery;
    }

    public AdQuestionResult toAdQuestionResult(AdQuestionVO adQuestionVO) {
        AdQuestionResult adQuestionResult = this.newAdQuestion(AdQuestionResult.class, adQuestionVO);
        this.fillAdQuestionResult(adQuestionResult, adQuestionVO);
        return adQuestionResult;
    }

    public AdQuestionView toAdQuestionView(AdQuestionVO adQuestionVO) {
        AdQuestionView adQuestionView = this.newAdQuestion(AdQuestionView.class, adQuestionVO);
        this.fillAdQuestionResult(adQuestionView, adQuestionVO);
        return adQuestionView;
    }

    private void fillAdQuestionResult(AdQuestionResult adQuestionResult, AdQuestionVO adQuestionVO) {
        adQuestionResult.setAdvertisement(this.marketplaceApiHelper.toAdWithOwner(adQuestionVO.getAd()));
    }

    private <Q extends AdQuestion> Q newAdQuestion(Class<Q> clazz, AdQuestionVO adQuestionVO) {
        AdQuestion adQuestion = (AdQuestion)this.apiHelper.newEntity(clazz, adQuestionVO);
        adQuestion.setAnswer(adQuestionVO.getAnswer());
        adQuestion.setAnswerDate(adQuestionVO.getAnswerDate());
        adQuestion.setQuestion(adQuestionVO.getQuestion());
        adQuestion.setQuestionDate(adQuestionVO.getQuestionDate());
        adQuestion.setUser(this.usersApiHelper.toUser((BasicUserVO)adQuestionVO.getOwner()));
        return (Q)adQuestion;
    }
}

