/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.WizardsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.HttpRequestData;
import org.cyclos.web.rest.model.WizardExecutionData;
import org.cyclos.web.rest.model.WizardTransitionParams;
import org.cyclos.web.rest.model.WizardVerificationCodeParams;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class WizardsApi {
    @Autowired
    private WizardsApiImpl impl;
    public static final String BACK_WIZARD_EXECUTION = "/wizard-executions/{key}/back";
    public static final String CANCEL_WIZARD_EXECUTION = "/wizard-executions/{key}";
    public static final String GET_CURRENT_WIZARD_EXECUTION = "/wizard-executions/{key}";
    public static final String REDIRECT_WIZARD_EXECUTION = "/wizard-executions/{key}/redirect";
    public static final String RUN_WIZARD_CALLBACK = "/wizard-executions/{key}/callback";
    public static final String SEND_WIZARD_VERIFICATION_CODE = "/wizard-executions/{key}/verification-code";
    public static final String START_MENU_WIZARD = "/menu/{menu}/wizards/start";
    public static final String START_USER_WIZARD = "/users/{user}/wizards/{key}/start";
    public static final String START_WIZARD = "/wizards/{key}/start";
    public static final String TRANSITION_WIZARD_EXECUTION = "/wizard-executions/{key}";

    @RequestMapping(value={"/api/wizard-executions/{key}/back"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<WizardExecutionData> backWizardExecution(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="steps", required=false) Integer n, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /wizard-executions/{key}/back");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.backWizardExecution(string, list, n);
    }

    @RequestMapping(value={"/api/wizard-executions/{key}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> cancelWizardExecution(@PathVariable(value="key") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /wizard-executions/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.cancelWizardExecution(string);
    }

    @RequestMapping(value={"/api/wizard-executions/{key}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<WizardExecutionData> getCurrentWizardExecution(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /wizard-executions/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getCurrentWizardExecution(string, list);
    }

    @RequestMapping(value={"/api/wizard-executions/{key}/redirect"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> redirectWizardExecution(@PathVariable(value="key") String string, @RequestBody(required=false) WizardTransitionParams wizardTransitionParams, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /wizard-executions/{key}/redirect");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.redirectWizardExecution(string, wizardTransitionParams);
    }

    @RequestMapping(value={"/api/wizard-executions/{key}/callback"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<WizardExecutionData> runWizardCallback(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestBody(required=false) HttpRequestData httpRequestData, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /wizard-executions/{key}/callback");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.runWizardCallback(string, list, httpRequestData);
    }

    @RequestMapping(value={"/api/wizard-executions/{key}/verification-code"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> sendWizardVerificationCode(@PathVariable(value="key") String string, @RequestBody(required=false) WizardVerificationCodeParams wizardVerificationCodeParams, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /wizard-executions/{key}/verification-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.sendWizardVerificationCode(string, wizardVerificationCodeParams);
    }

    @RequestMapping(value={"/api/menu/{menu}/wizards/start"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<WizardExecutionData> startMenuWizard(@PathVariable(value="menu") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /menu/{menu}/wizards/start");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.startMenuWizard(string, list);
    }

    @RequestMapping(value={"/api/users/{user:.*}/wizards/{key}/start"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<WizardExecutionData> startUserWizard(@PathVariable(value="user") String string, @PathVariable(value="key") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /users/{user}/wizards/{key}/start");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.startUserWizard(string, string2, list);
    }

    @RequestMapping(value={"/api/wizards/{key}/start"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<WizardExecutionData> startWizard(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="inviteToken", required=false) String string2, @RequestParam(value="externalPaymentToken", required=false) String string3, @RequestParam(value="userAgentId", required=false) String string4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /wizards/{key}/start");
        httpServletRequest.setAttribute("errorType", Error.class);
        StartWizardParams startWizardParams = new StartWizardParams();
        startWizardParams.key = string;
        startWizardParams.fields = list;
        startWizardParams.inviteToken = string2;
        startWizardParams.externalPaymentToken = string3;
        startWizardParams.userAgentId = string4;
        return this.impl.startWizard(startWizardParams);
    }

    @RequestMapping(value={"/api/wizard-executions/{key}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<WizardExecutionData> transitionWizardExecution(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="transition", required=false) String string2, @RequestBody(required=false) WizardTransitionParams wizardTransitionParams, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /wizard-executions/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        TransitionWizardExecutionParams transitionWizardExecutionParams = new TransitionWizardExecutionParams();
        transitionWizardExecutionParams.key = string;
        transitionWizardExecutionParams.fields = list;
        transitionWizardExecutionParams.transition = string2;
        transitionWizardExecutionParams.wizardTransitionParams = wizardTransitionParams;
        return this.impl.transitionWizardExecution(transitionWizardExecutionParams);
    }

    public static class StartWizardParams {
        public String key;
        public static final String KEY = "key";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String inviteToken;
        public static final String INVITE_TOKEN = "inviteToken";
        public String externalPaymentToken;
        public static final String EXTERNAL_PAYMENT_TOKEN = "externalPaymentToken";
        public String userAgentId;
        public static final String USER_AGENT_ID = "userAgentId";
    }

    public static class TransitionWizardExecutionParams {
        public String key;
        public static final String KEY = "key";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String transition;
        public static final String TRANSITION = "transition";
        public WizardTransitionParams wizardTransitionParams;
        public static final String WIZARD_TRANSITION_PARAMS = "wizardTransitionParams";
    }
}

