/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.Bean;
import org.cyclos.model.banking.vouchers.AssignVoucherDTO;
import org.cyclos.model.banking.vouchers.BasicVoucherQuery;
import org.cyclos.model.banking.vouchers.BuyVoucherData;
import org.cyclos.model.banking.vouchers.BuyVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.BuyVouchersDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherExpirationDateDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherNotificationSettingsDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherPinDTO;
import org.cyclos.model.banking.vouchers.CreateVoucherDataParams;
import org.cyclos.model.banking.vouchers.GeneralVoucherQuery;
import org.cyclos.model.banking.vouchers.GeneralVouchersSearchData;
import org.cyclos.model.banking.vouchers.GenerateVouchersDTO;
import org.cyclos.model.banking.vouchers.GenerateVouchersData;
import org.cyclos.model.banking.vouchers.InitialVoucherUserData;
import org.cyclos.model.banking.vouchers.RedeemVoucherDTO;
import org.cyclos.model.banking.vouchers.RedeemVoucherData;
import org.cyclos.model.banking.vouchers.RedeemVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.SendVoucherDTO;
import org.cyclos.model.banking.vouchers.TopUpVoucherDTO;
import org.cyclos.model.banking.vouchers.TopUpVoucherData;
import org.cyclos.model.banking.vouchers.TopUpVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.UserVoucherQuery;
import org.cyclos.model.banking.vouchers.UserVouchersSearchData;
import org.cyclos.model.banking.vouchers.VoucherBarcodeParams;
import org.cyclos.model.banking.vouchers.VoucherData;
import org.cyclos.model.banking.vouchers.VoucherPackVO;
import org.cyclos.model.banking.vouchers.VoucherPackWithIdsVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionData;
import org.cyclos.model.banking.vouchers.VoucherTransactionDataParams;
import org.cyclos.model.banking.vouchers.VoucherTransactionResultVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionsQuery;
import org.cyclos.model.banking.vouchers.VoucherTransactionsSearchData;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeDetailedVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.banking.VoucherService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.VouchersApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.VouchersApiHelper;
import org.cyclos.web.rest.model.AssignVoucher;
import org.cyclos.web.rest.model.BuyVoucher;
import org.cyclos.web.rest.model.ChangeVoucherExpirationDate;
import org.cyclos.web.rest.model.ChangeVoucherNotificationSettings;
import org.cyclos.web.rest.model.ChangeVoucherPin;
import org.cyclos.web.rest.model.GeneralVouchersDataForSearch;
import org.cyclos.web.rest.model.GenerateVoucher;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.RedeemVoucher;
import org.cyclos.web.rest.model.SendVoucher;
import org.cyclos.web.rest.model.UserVoucherTransactionsDataForSearch;
import org.cyclos.web.rest.model.UserVoucherTransactionsQueryFilters;
import org.cyclos.web.rest.model.UserVouchersDataForSearch;
import org.cyclos.web.rest.model.UserVouchersQueryFilters;
import org.cyclos.web.rest.model.VoucherBoughtResult;
import org.cyclos.web.rest.model.VoucherBuyingPreview;
import org.cyclos.web.rest.model.VoucherDataForBuy;
import org.cyclos.web.rest.model.VoucherDataForGenerate;
import org.cyclos.web.rest.model.VoucherDataForRedeem;
import org.cyclos.web.rest.model.VoucherDataForTopUp;
import org.cyclos.web.rest.model.VoucherInitialDataForTransaction;
import org.cyclos.web.rest.model.VoucherRedeemPreview;
import org.cyclos.web.rest.model.VoucherRedeemResult;
import org.cyclos.web.rest.model.VoucherRelationEnum;
import org.cyclos.web.rest.model.VoucherResult;
import org.cyclos.web.rest.model.VoucherSendingPreview;
import org.cyclos.web.rest.model.VoucherTopUpPreview;
import org.cyclos.web.rest.model.VoucherTransaction;
import org.cyclos.web.rest.model.VoucherTransactionResult;
import org.cyclos.web.rest.model.VoucherTransactionView;
import org.cyclos.web.rest.model.VoucherView;
import org.cyclos.web.rest.model.VouchersQueryFilters;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class VouchersApiImpl
extends BaseApiImpl {
    @Autowired
    private VoucherService voucherService;
    @Autowired
    private VouchersApiHelper vouchersApiHelper;

    public ResponseEntity<Void> assignVoucher(String string, AssignVoucher assignVoucher) {
        AssignVoucherDTO assignVoucherDTO = this.vouchersApiHelper.toAssignVoucherDTO(string, assignVoucher);
        this.voucherService.assign(assignVoucherDTO);
        return this.okOrNoContent(null);
    }

    public ResponseEntity<List<String>> buyVouchers(String string, BuyVoucher buyVoucher, String string2) {
        BuyVouchersDTO buyVouchersDTO = this.vouchersApiHelper.toBuyVouchersDTO(string, buyVoucher, string2);
        VoucherPackWithIdsVO voucherPackWithIdsVO = this.voucherService.buy(buyVouchersDTO);
        List list = CollectionHelper.orEmpty((Set)voucherPackWithIdsVO.getVoucherIds()).stream().map(ApiHelper::toId).collect(Collectors.toList());
        return this.ok(list);
    }

    public ResponseEntity<VoucherBoughtResult> buyVouchersWithStatus(String string, BuyVoucher buyVoucher, String string2) {
        BuyVouchersDTO buyVouchersDTO = this.vouchersApiHelper.toBuyVouchersDTO(string, buyVoucher, string2);
        VoucherPackWithIdsVO voucherPackWithIdsVO = this.voucherService.buy(buyVouchersDTO);
        return this.ok(this.vouchersApiHelper.toVoucherBoughtResult(voucherPackWithIdsVO));
    }

    public ResponseEntity<Void> cancelVoucher(String string, String string2) {
        Long l = this.vouchersApiHelper.ensureId(string);
        this.voucherService.cancel(this.vouchersApiHelper.toCancelVoucherDTO(l, string2));
        return this.ok();
    }

    public ResponseEntity<Void> changeVoucherExpirationDate(String string, ChangeVoucherExpirationDate changeVoucherExpirationDate, String string2) {
        Long l = this.vouchersApiHelper.ensureId(string);
        ChangeVoucherExpirationDateDTO changeVoucherExpirationDateDTO = this.vouchersApiHelper.toChangeVoucherExpirationDateDTO(l, changeVoucherExpirationDate, string2);
        this.voucherService.changeExpirationDate(changeVoucherExpirationDateDTO);
        return this.ok();
    }

    public ResponseEntity<Void> changeVoucherNotificationSettings(String string, ChangeVoucherNotificationSettings changeVoucherNotificationSettings, String string2) {
        ChangeVoucherNotificationSettingsDTO changeVoucherNotificationSettingsDTO = this.vouchersApiHelper.toChangeVoucherNotificationSettingsDTO(string, changeVoucherNotificationSettings, string2);
        this.voucherService.changeNotificationSettings(changeVoucherNotificationSettingsDTO);
        return this.ok();
    }

    public ResponseEntity<Void> changeVoucherPin(String string, ChangeVoucherPin changeVoucherPin, String string2) {
        ChangeVoucherPinDTO changeVoucherPinDTO = this.vouchersApiHelper.toChangeVoucherPinDTO(string, changeVoucherPin, string2);
        this.voucherService.changePin(changeVoucherPinDTO);
        return this.ok();
    }

    public ResponseEntity<InputStream> exportUserVouchers(VouchersApi.ExportUserVouchersParams exportUserVouchersParams) {
        UserVouchersQueryFilters userVouchersQueryFilters = (UserVouchersQueryFilters)ClassHelper.convert((Object)exportUserVouchersParams, UserVouchersQueryFilters.class);
        UserVoucherQuery userVoucherQuery = this.vouchersApiHelper.toUserVoucherQuery(exportUserVouchersParams.user, userVouchersQueryFilters);
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)exportUserVouchersParams.format);
        FileInfo fileInfo = this.voucherService.exportVouchers(exportFormatVO, (BasicVoucherQuery)userVoucherQuery, false);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<InputStream> exportVoucher(String string, String string2, Boolean bl) {
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)string2);
        FileInfo fileInfo = this.voucherService.exportVoucher(exportFormatVO, (VoucherVO)ModelHelper.voFromString(VoucherVO.class, (String)string), Boolean.TRUE.equals(bl));
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<InputStream> exportVouchers(VouchersApi.ExportVouchersParams exportVouchersParams) {
        VouchersQueryFilters vouchersQueryFilters = (VouchersQueryFilters)ClassHelper.convert((Object)exportVouchersParams, VouchersQueryFilters.class);
        GeneralVoucherQuery generalVoucherQuery = this.vouchersApiHelper.toVoucherQuery(vouchersQueryFilters);
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)exportVouchersParams.format);
        boolean bl = Boolean.TRUE.equals(exportVouchersParams.markAsPrinted);
        FileInfo fileInfo = this.voucherService.exportVouchers(exportFormatVO, (BasicVoucherQuery)generalVoucherQuery, bl);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<InputStream> exportVoucherTransaction(String string, String string2) {
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)string2);
        FileInfo fileInfo = this.voucherService.exportTransaction(exportFormatVO, (VoucherTransactionVO)ModelHelper.voFromString(VoucherTransactionVO.class, (String)string));
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<List<String>> generateVouchers(GenerateVoucher generateVoucher, String string) {
        GenerateVouchersDTO generateVouchersDTO = this.vouchersApiHelper.toGenerateVouchersDTO(generateVoucher, string);
        VoucherPackWithIdsVO voucherPackWithIdsVO = this.voucherService.generate(generateVouchersDTO);
        List list = CollectionHelper.orEmpty((Set)voucherPackWithIdsVO.getVoucherIds()).stream().map(ApiHelper::toId).collect(Collectors.toList());
        return this.ok(list);
    }

    public ResponseEntity<GeneralVouchersDataForSearch> getGeneralVouchersDataForSearch(List<String> list) {
        GeneralVouchersSearchData generalVouchersSearchData = this.voucherService.getGeneralSearchData();
        GeneralVouchersDataForSearch generalVouchersDataForSearch = this.vouchersApiHelper.toGeneralVouchersDataForSearch(generalVouchersSearchData);
        return this.ok(generalVouchersDataForSearch);
    }

    public ResponseEntity<UserVouchersDataForSearch> getUserVouchersDataForSearch(String string, List<String> list, VoucherRelationEnum voucherRelationEnum) {
        UserVouchersDataForSearch userVouchersDataForSearch;
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        voucherRelationEnum = (VoucherRelationEnum)ObjectHelper.defaultValue((Object)voucherRelationEnum, (Object)VoucherRelationEnum.BOUGHT);
        switch (voucherRelationEnum) {
            case BOUGHT: {
                UserVouchersSearchData userVouchersSearchData = this.voucherService.getUserVouchersSearchData(userLocatorVO);
                userVouchersDataForSearch = this.vouchersApiHelper.toUserVouchersDataForSearch(userVouchersSearchData);
                break;
            }
            case REDEEMED: {
                VoucherTransactionsSearchData voucherTransactionsSearchData = this.voucherService.getUserTransactionsSearchData(userLocatorVO);
                userVouchersDataForSearch = this.vouchersApiHelper.toUserVouchersDataForSearch(voucherTransactionsSearchData);
                break;
            }
            default: {
                userVouchersDataForSearch = null;
            }
        }
        return this.ok(userVouchersDataForSearch);
    }

    public ResponseEntity<UserVoucherTransactionsDataForSearch> getUserVoucherTransactionsDataForSearch(String string, List<String> list) {
        VoucherTransactionsSearchData voucherTransactionsSearchData = this.voucherService.getUserTransactionsSearchData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        UserVoucherTransactionsDataForSearch userVoucherTransactionsDataForSearch = this.vouchersApiHelper.toUserVoucherTransactionsDataForSearch(voucherTransactionsSearchData);
        return this.ok(userVoucherTransactionsDataForSearch);
    }

    public ResponseEntity<VoucherDataForBuy> getVoucherDataForBuy(String string, List<String> list, String string2) {
        CreateVoucherDataParams createVoucherDataParams = this.vouchersApiHelper.toCreateVoucherDataParams(string, string2);
        BuyVoucherData buyVoucherData = this.voucherService.getBuyData(createVoucherDataParams);
        VoucherDataForBuy voucherDataForBuy = this.vouchersApiHelper.toVoucherDataForBuy(buyVoucherData);
        return this.ok(voucherDataForBuy);
    }

    public ResponseEntity<VoucherDataForGenerate> getVoucherDataForGenerate(List<String> list, String string, String string2) {
        CreateVoucherDataParams createVoucherDataParams = this.vouchersApiHelper.toCreateVoucherDataParams(string, string2);
        GenerateVouchersData generateVouchersData = this.voucherService.getGenerateData(createVoucherDataParams);
        VoucherDataForGenerate voucherDataForGenerate = this.vouchersApiHelper.toVoucherDataForGenerate(generateVouchersData);
        return this.ok(voucherDataForGenerate);
    }

    public ResponseEntity<VoucherDataForRedeem> getVoucherDataForRedeem(String string, String string2, List<String> list) {
        VoucherTransactionDataParams voucherTransactionDataParams = this.vouchersApiHelper.toVoucherTransactionDataParams(string, string2);
        RedeemVoucherData redeemVoucherData = this.voucherService.getRedeemData(voucherTransactionDataParams);
        VoucherDataForRedeem voucherDataForRedeem = this.vouchersApiHelper.toVoucherDataForRedeem(redeemVoucherData);
        return this.ok(voucherDataForRedeem);
    }

    public ResponseEntity<VoucherDataForBuy> getVoucherDataForSend(String string, List<String> list, String string2) {
        CreateVoucherDataParams createVoucherDataParams = this.vouchersApiHelper.toCreateVoucherDataParams(string, string2);
        BuyVoucherData buyVoucherData = this.voucherService.getSendData(createVoucherDataParams);
        VoucherDataForBuy voucherDataForBuy = this.vouchersApiHelper.toVoucherDataForBuy(buyVoucherData);
        return this.ok(voucherDataForBuy);
    }

    public ResponseEntity<VoucherDataForTopUp> getVoucherDataForTopUp(String string, String string2, List<String> list) {
        VoucherTransactionDataParams voucherTransactionDataParams = this.vouchersApiHelper.toVoucherTransactionDataParams(string, string2);
        TopUpVoucherData topUpVoucherData = this.voucherService.getTopUpData(voucherTransactionDataParams);
        VoucherDataForTopUp voucherDataForTopUp = this.vouchersApiHelper.toVoucherDataForTopUp(topUpVoucherData);
        return this.ok(voucherDataForTopUp);
    }

    public ResponseEntity<VoucherInitialDataForTransaction> getVoucherInitialDataForRedeem(String string, List<String> list) {
        InitialVoucherUserData initialVoucherUserData = this.voucherService.getRedeemInitialData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        VoucherInitialDataForTransaction voucherInitialDataForTransaction = this.vouchersApiHelper.toVoucherInitialDataForTransaction(initialVoucherUserData);
        return this.ok(voucherInitialDataForTransaction);
    }

    public ResponseEntity<VoucherInitialDataForTransaction> getVoucherInitialDataForTopUp(String string, List<String> list) {
        InitialVoucherUserData initialVoucherUserData = this.voucherService.getTopUpInitialData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        VoucherInitialDataForTransaction voucherInitialDataForTransaction = this.vouchersApiHelper.toVoucherInitialDataForTransaction(initialVoucherUserData);
        return this.ok(voucherInitialDataForTransaction);
    }

    public ResponseEntity<InputStream> getVoucherQrCode(String string, ImageSizeEnum imageSizeEnum) throws IOException {
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        VoucherBarcodeParams voucherBarcodeParams = this.vouchersApiHelper.toVoucherBarcodeParams(string, imageSizeEnum);
        SerializableInputStream serializableInputStream = this.voucherService.barcode(voucherBarcodeParams);
        ServletHelper.setContentType(httpServletResponse, ContentType.PNG);
        ServletHelper.writeContents(httpServletResponse, (InputStream)serializableInputStream);
        httpServletResponse.flushBuffer();
        return null;
    }

    public ResponseEntity<VoucherBuyingPreview> previewBuyVouchers(String string, BuyVoucher buyVoucher, List<String> list) {
        BuyVouchersDTO buyVouchersDTO = this.vouchersApiHelper.toBuyVouchersDTO(string, buyVoucher, null);
        BuyVoucherPreviewVO buyVoucherPreviewVO = this.voucherService.previewBuy(buyVouchersDTO);
        VoucherBuyingPreview voucherBuyingPreview = this.vouchersApiHelper.toVoucherBuyingPreview(buyVoucherPreviewVO);
        return this.ok(voucherBuyingPreview);
    }

    public ResponseEntity<VoucherSendingPreview> previewSendVoucher(String string, SendVoucher sendVoucher, List<String> list) {
        SendVoucherDTO sendVoucherDTO = this.vouchersApiHelper.toSendVoucherDTO(string, sendVoucher, null);
        BuyVoucherPreviewVO buyVoucherPreviewVO = this.voucherService.previewSend(sendVoucherDTO);
        VoucherSendingPreview voucherSendingPreview = this.vouchersApiHelper.toVoucherSendingPreview(buyVoucherPreviewVO);
        return this.ok(voucherSendingPreview);
    }

    public ResponseEntity<VoucherRedeemPreview> previewVoucherRedeem(VouchersApi.PreviewVoucherRedeemParams previewVoucherRedeemParams) {
        RedeemVoucherDTO redeemVoucherDTO = this.vouchersApiHelper.toRedeemVoucherDTO(previewVoucherRedeemParams.user, previewVoucherRedeemParams.token, previewVoucherRedeemParams.redeemVoucher);
        RedeemVoucherPreviewVO redeemVoucherPreviewVO = this.voucherService.previewRedeem(redeemVoucherDTO);
        VoucherRedeemPreview voucherRedeemPreview = this.vouchersApiHelper.toVoucherRedeemPreview(redeemVoucherPreviewVO);
        return this.ok(voucherRedeemPreview);
    }

    public ResponseEntity<VoucherTopUpPreview> previewVoucherTopUp(VouchersApi.PreviewVoucherTopUpParams previewVoucherTopUpParams) {
        TopUpVoucherDTO topUpVoucherDTO = this.vouchersApiHelper.toTopUpVoucherDTO(previewVoucherTopUpParams.user, previewVoucherTopUpParams.token, null, previewVoucherTopUpParams.topUpVoucher);
        TopUpVoucherPreviewVO topUpVoucherPreviewVO = this.voucherService.previewTopUp(topUpVoucherDTO);
        VoucherTopUpPreview voucherTopUpPreview = this.vouchersApiHelper.toVoucherTopUpPreview(topUpVoucherPreviewVO);
        return this.ok(voucherTopUpPreview);
    }

    public ResponseEntity<VoucherRedeemResult> redeemVoucher(String string, String string2, RedeemVoucher redeemVoucher) {
        RedeemVoucherDTO redeemVoucherDTO = this.vouchersApiHelper.toRedeemVoucherDTO(string, string2, redeemVoucher);
        VoucherTransactionResultVO voucherTransactionResultVO = this.voucherService.redeem(redeemVoucherDTO);
        VoucherRedeemResult voucherRedeemResult = this.vouchersApiHelper.toVoucherRedeemResult(voucherTransactionResultVO);
        URI uRI = voucherRedeemResult.getVoucherId() == null ? this.apiHelper.uriFromApi("voucher-transactions", voucherRedeemResult.getId()) : this.apiHelper.uriFromApi("vouchers", voucherRedeemResult.getVoucherId());
        return ResponseEntity.created((URI)uRI).body((Object)voucherRedeemResult);
    }

    public ResponseEntity<List<String>> resendPin(String string, String string2) {
        return this.ok(this.voucherService.resendPinForRedeem(string, ModelHelper.userLocator((String)string2)));
    }

    public ResponseEntity<Void> resendVoucherEmail(String string) {
        VoucherVO voucherVO = (VoucherVO)ModelHelper.voFromString(VoucherVO.class, (String)string);
        this.voucherService.resendEmail(voucherVO);
        return this.okOrNoContent(null);
    }

    public ResponseEntity<List<VoucherResult>> searchUserVouchers(VouchersApi.SearchUserVouchersParams searchUserVouchersParams) {
        UserVouchersQueryFilters userVouchersQueryFilters = (UserVouchersQueryFilters)ClassHelper.convert((Object)searchUserVouchersParams, UserVouchersQueryFilters.class);
        VoucherRelationEnum voucherRelationEnum = (VoucherRelationEnum)ObjectHelper.defaultValue((Object)searchUserVouchersParams.relation, (Object)VoucherRelationEnum.BOUGHT);
        Page page = null;
        switch (voucherRelationEnum) {
            case BOUGHT: {
                UserVoucherQuery userVoucherQuery = this.vouchersApiHelper.toUserVoucherQuery(searchUserVouchersParams.user, userVouchersQueryFilters);
                page = this.voucherService.searchUser(userVoucherQuery);
                break;
            }
            case REDEEMED: {
                VoucherTransactionsQuery voucherTransactionsQuery = this.vouchersApiHelper.toVoucherTransactionsQueryDeprecated(searchUserVouchersParams.user, userVouchersQueryFilters);
                Page page2 = this.voucherService.searchTransactions(voucherTransactionsQuery);
                page = PageImpl.transformed((Page)page2, this::transactionAsVoucherVO);
            }
        }
        return this.pageResponse(page, voucherVO -> this.vouchersApiHelper.toVoucherResult((VoucherVO)voucherVO, voucherRelationEnum));
    }

    public ResponseEntity<List<VoucherTransactionResult>> searchUserVoucherTransactions(VouchersApi.SearchUserVoucherTransactionsParams searchUserVoucherTransactionsParams) {
        UserVoucherTransactionsQueryFilters userVoucherTransactionsQueryFilters = (UserVoucherTransactionsQueryFilters)ClassHelper.convert((Object)searchUserVoucherTransactionsParams, UserVoucherTransactionsQueryFilters.class);
        VoucherTransactionsQuery voucherTransactionsQuery = this.vouchersApiHelper.toVoucherTransactionsQuery(searchUserVoucherTransactionsParams.user, userVoucherTransactionsQueryFilters);
        Page page = this.voucherService.searchTransactions(voucherTransactionsQuery);
        return this.pageResponse(page, this.vouchersApiHelper::toVoucherTransactionResult);
    }

    public ResponseEntity<List<VoucherResult>> searchVouchers(VouchersApi.SearchVouchersParams searchVouchersParams) {
        VouchersQueryFilters vouchersQueryFilters = (VouchersQueryFilters)ClassHelper.convert((Object)searchVouchersParams, VouchersQueryFilters.class);
        GeneralVoucherQuery generalVoucherQuery = this.vouchersApiHelper.toVoucherQuery(vouchersQueryFilters);
        Page page = this.voucherService.searchGeneral(generalVoucherQuery);
        return this.pageResponse(page, voucherVO -> this.vouchersApiHelper.toVoucherResult((VoucherVO)voucherVO, null));
    }

    public ResponseEntity<List<VoucherTransaction>> searchVoucherTransactions(VouchersApi.SearchVoucherTransactionsParams searchVoucherTransactionsParams) {
        VoucherTransactionsQuery voucherTransactionsQuery = this.apiHelper.newQuery(VoucherTransactionsQuery.class, searchVoucherTransactionsParams.page, searchVoucherTransactionsParams.pageSize, searchVoucherTransactionsParams.skipTotalCount);
        voucherTransactionsQuery.setVoucher((VoucherVO)ModelHelper.voFromString(VoucherVO.class, (String)searchVoucherTransactionsParams.key));
        Page page = this.voucherService.searchTransactions(voucherTransactionsQuery);
        return this.pageResponse(page, this.vouchersApiHelper::toVoucherTransaction);
    }

    public ResponseEntity<VoucherBoughtResult> sendVoucher(String string, SendVoucher sendVoucher, String string2) {
        SendVoucherDTO sendVoucherDTO = this.vouchersApiHelper.toSendVoucherDTO(string, sendVoucher, string2);
        VoucherPackWithIdsVO voucherPackWithIdsVO = this.voucherService.send(sendVoucherDTO);
        return this.ok(this.vouchersApiHelper.toVoucherBoughtResult(voucherPackWithIdsVO));
    }

    public ResponseEntity<VoucherTransactionResult> topUpVoucher(VouchersApi.TopUpVoucherParams topUpVoucherParams) {
        TopUpVoucherDTO topUpVoucherDTO = this.vouchersApiHelper.toTopUpVoucherDTO(topUpVoucherParams.user, topUpVoucherParams.token, topUpVoucherParams.confirmationPassword, topUpVoucherParams.topUpVoucher);
        VoucherTransactionResultVO voucherTransactionResultVO = this.voucherService.topUp(topUpVoucherDTO);
        VoucherTransactionResult voucherTransactionResult = this.vouchersApiHelper.toVoucherTransactionResult(voucherTransactionResultVO);
        return ResponseEntity.created((URI)this.apiHelper.uriFromApi("vouchers-transactions", voucherTransactionResult.getId())).body((Object)voucherTransactionResult);
    }

    public ResponseEntity<Void> unblockVoucherPin(String string) {
        VoucherVO voucherVO = (VoucherVO)ModelHelper.voFromString(VoucherVO.class, (String)string);
        this.voucherService.unblockPin(voucherVO);
        return this.okOrNoContent(null);
    }

    public ResponseEntity<VoucherView> viewVoucher(String string, List<String> list) {
        Long l = this.vouchersApiHelper.ensureId(string);
        VoucherData voucherData = this.voucherService.getData(l);
        VoucherView voucherView = this.vouchersApiHelper.toVoucherView(voucherData);
        return this.ok(voucherView);
    }

    public ResponseEntity<VoucherTransactionView> viewVoucherTransaction(String string, List<String> list) {
        VoucherTransactionData voucherTransactionData = this.voucherService.getTransactionData(this.apiHelper.fromId(string));
        VoucherTransactionView voucherTransactionView = this.vouchersApiHelper.toVoucherTransactionView(voucherTransactionData);
        return this.ok(voucherTransactionView);
    }

    private VoucherVO transactionAsVoucherVO(VoucherTransactionResultVO voucherTransactionResultVO) {
        VoucherVO voucherVO = new VoucherVO();
        VoucherPackVO voucherPackVO = new VoucherPackVO();
        voucherVO.setPack(voucherPackVO);
        voucherPackVO.setType(new VoucherTypeDetailedVO());
        voucherTransactionResultVO.getType().copyPropertiesTo((Bean)voucherPackVO.getType());
        voucherPackVO.setAmount(voucherTransactionResultVO.getAmount());
        voucherPackVO.setCreationDate(voucherTransactionResultVO.getDate());
        voucherVO.setRedeemDate(voucherTransactionResultVO.getDate());
        voucherVO.setRedeemBy(voucherTransactionResultVO.getBy());
        voucherVO.setId(voucherTransactionResultVO.getVoucherId());
        return voucherVO;
    }
}

