/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.access.CaptchaResponseDTO;
import org.cyclos.model.banking.vouchers.ActivateGiftVoucherDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherNotificationSettingsDTO;
import org.cyclos.model.banking.vouchers.SimpleChangeVoucherNotificationSettingsDTO;
import org.cyclos.model.banking.vouchers.SimpleChangeVoucherPinDTO;
import org.cyclos.model.banking.vouchers.VoucherInfoData;
import org.cyclos.model.banking.vouchers.VoucherInfoTransactionsQuery;
import org.cyclos.model.banking.vouchers.VoucherInfoVO;
import org.cyclos.services.banking.VoucherService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.VoucherInfoApi;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.VoucherInfoApiHelper;
import org.cyclos.web.rest.helpers.VouchersApiHelper;
import org.cyclos.web.rest.model.ActivateGiftVoucher;
import org.cyclos.web.rest.model.CaptchaResponse;
import org.cyclos.web.rest.model.ChangeVoucherNotificationSettings;
import org.cyclos.web.rest.model.DataForVoucherInfo;
import org.cyclos.web.rest.model.SimpleChangeVoucherPin;
import org.cyclos.web.rest.model.VoucherInfo;
import org.cyclos.web.rest.model.VoucherTransaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class VoucherInfoApiImpl
extends BaseApiImpl {
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private VoucherService voucherService;
    @Autowired
    private VouchersApiHelper vouchersApiHelper;
    @Autowired
    private VoucherInfoApiHelper voucherInfoApiHelper;

    public ResponseEntity<VoucherInfo> activateGiftVoucher(String string, ActivateGiftVoucher activateGiftVoucher) {
        ActivateGiftVoucherDTO activateGiftVoucherDTO = this.voucherInfoApiHelper.toActivateGiftVoucher(activateGiftVoucher);
        VoucherInfoVO voucherInfoVO = this.voucherService.activateGiftVoucher(string, activateGiftVoucherDTO);
        VoucherInfo voucherInfo = this.voucherInfoApiHelper.toVoucherInfo(voucherInfoVO);
        return this.ok(voucherInfo);
    }

    public ResponseEntity<Void> changeVoucherInfoNotificationSettings(String string, String string2, ChangeVoucherNotificationSettings changeVoucherNotificationSettings) {
        ChangeVoucherNotificationSettingsDTO changeVoucherNotificationSettingsDTO = this.voucherInfoApiHelper.toChangeVoucherNotificationSettingsDto(string2, changeVoucherNotificationSettings);
        this.voucherService.changeInfoNotificationSettings(string, string2, (SimpleChangeVoucherNotificationSettingsDTO)changeVoucherNotificationSettingsDTO);
        return this.ok();
    }

    public ResponseEntity<Void> changeVoucherInfoPin(String string, String string2, SimpleChangeVoucherPin simpleChangeVoucherPin) {
        SimpleChangeVoucherPinDTO simpleChangeVoucherPinDTO = this.voucherInfoApiHelper.toSimpleChangeVoucherPinDto(string2, simpleChangeVoucherPin);
        this.voucherService.changeInfoPin(string, simpleChangeVoucherPinDTO);
        return this.ok();
    }

    public ResponseEntity<VoucherInfo> getVoucherInfo(String string, String string2) {
        VoucherInfoVO voucherInfoVO = this.voucherService.getInfo(string, string2);
        VoucherInfo voucherInfo = this.voucherInfoApiHelper.toVoucherInfo(voucherInfoVO);
        return this.ok(voucherInfo);
    }

    public ResponseEntity<DataForVoucherInfo> getVoucherInfoData() {
        VoucherInfoData voucherInfoData = this.voucherService.getInfoData();
        DataForVoucherInfo dataForVoucherInfo = this.voucherInfoApiHelper.toDataForVoucherInfo(voucherInfoData);
        return this.ok(dataForVoucherInfo);
    }

    public ResponseEntity<List<String>> resendVoucherInfoPin(String string, CaptchaResponse captchaResponse) {
        CaptchaResponseDTO captchaResponseDTO = this.authApiHelper.toCaptchaResponseDTO(captchaResponse);
        List list = this.voucherService.resendPin(string, captchaResponseDTO);
        return this.ok(list);
    }

    public ResponseEntity<List<VoucherTransaction>> searchVoucherInfoTransactions(VoucherInfoApi.SearchVoucherInfoTransactionsParams searchVoucherInfoTransactionsParams) {
        VoucherInfoTransactionsQuery voucherInfoTransactionsQuery = this.voucherInfoApiHelper.toVoucherInfoTransactionsQuery(searchVoucherInfoTransactionsParams);
        Page page = this.voucherService.searchInfoTransactions(voucherInfoTransactionsQuery, searchVoucherInfoTransactionsParams.pin);
        return this.pageResponse(page, this.vouchersApiHelper::toVoucherTransaction);
    }

    public ResponseEntity<Void> unblockVoucherInfo(String string, String string2) {
        this.voucherService.unblock(this.voucherInfoApiHelper.toUnblockVoucherParams(string, string2));
        return this.ok();
    }
}

