/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.TokensApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.TokenDataForNew;
import org.cyclos.web.rest.model.TokenDataForSearch;
import org.cyclos.web.rest.model.TokenNew;
import org.cyclos.web.rest.model.TokenPermissions;
import org.cyclos.web.rest.model.TokenResult;
import org.cyclos.web.rest.model.TokenStatusEnum;
import org.cyclos.web.rest.model.TokenView;
import org.cyclos.web.rest.model.UserTokensListData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class TokensApi {
    @Autowired
    private TokensApiImpl impl;
    public static final String ACTIVATE_PENDING_TOKEN = "/tokens/{id}/activate";
    public static final String ACTIVATE_TOKEN = "/{user}/tokens/{type}";
    public static final String ASSIGN_TOKEN = "/tokens/{id}/assign/{user}";
    public static final String BLOCK_TOKEN = "/tokens/{id}/block";
    public static final String CANCEL_TOKEN = "/tokens/{id}/cancel";
    public static final String CREATE_TOKEN = "/tokens/{type}/new";
    public static final String GET_GENERAL_TOKENS_DATA_FOR_SEARCH = "/general-tokens/{type}/data-for-search";
    public static final String GET_TOKEN_DATA_FOR_NEW = "/tokens/{type}/data-for-new";
    public static final String GET_TOKEN_QR_CODE = "/tokens/{id}/qr-code";
    public static final String GET_USER_TOKENS = "/{user}/tokens/{type}";
    public static final String LIST_USER_TOKEN_TYPES = "/{user}/token-types";
    public static final String SEARCH_GENERAL_TOKENS = "/general-tokens/{type}";
    public static final String SET_TOKEN_ACTIVATION_DEADLINE = "/tokens/{id}/set-activation-deadline";
    public static final String SET_TOKEN_EXPIRY_DATE = "/tokens/{id}/set-expiry-date";
    public static final String UNBLOCK_TOKEN = "/tokens/{id}/unblock";
    public static final String VIEW_TOKEN = "/tokens/{id}";

    @RequestMapping(value={"/api/tokens/{id}/activate"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> activatePendingToken(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tokens/{id}/activate");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.activatePendingToken(string);
    }

    @RequestMapping(value={"/api/{user:.*}/tokens/{type}"}, produces={"text/plain", "application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<String> activateToken(@PathVariable(value="user") String string, @PathVariable(value="type") String string2, @RequestBody(required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/tokens/{type}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.activateToken(string, string2, string3);
    }

    @RequestMapping(value={"/api/tokens/{id}/assign/{user:.*}"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> assignToken(@PathVariable(value="id") String string, @PathVariable(value="user") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tokens/{id}/assign/{user}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.assignToken(string, string2);
    }

    @RequestMapping(value={"/api/tokens/{id}/block"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> blockToken(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tokens/{id}/block");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.blockToken(string);
    }

    @RequestMapping(value={"/api/tokens/{id}/cancel"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> cancelToken(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tokens/{id}/cancel");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.cancelToken(string);
    }

    @RequestMapping(value={"/api/tokens/{type}/new"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createToken(@PathVariable(value="type") String string, @RequestBody(required=true) TokenNew tokenNew, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tokens/{type}/new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.createToken(string, tokenNew);
    }

    @RequestMapping(value={"/api/general-tokens/{type}/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<TokenDataForSearch> getGeneralTokensDataForSearch(@PathVariable(value="type") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /general-tokens/{type}/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getGeneralTokensDataForSearch(string, list);
    }

    @RequestMapping(value={"/api/tokens/{type}/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<TokenDataForNew> getTokenDataForNew(@PathVariable(value="type") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="user", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /tokens/{type}/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getTokenDataForNew(string, list, string2);
    }

    @RequestMapping(value={"/api/tokens/{id}/qr-code"}, produces={"image/png", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> getTokenQrCode(@PathVariable(value="id") String string, @RequestParam(value="size", required=false) ImageSizeEnum imageSizeEnum, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /tokens/{id}/qr-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getTokenQrCode(string, imageSizeEnum);
    }

    @RequestMapping(value={"/api/{user:.*}/tokens/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserTokensListData> getUserTokens(@PathVariable(value="user") String string, @PathVariable(value="type") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/tokens/{type}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserTokens(string, string2, list);
    }

    @RequestMapping(value={"/api/{user:.*}/token-types"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<TokenPermissions>> listUserTokenTypes(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/token-types");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listUserTokenTypes(string, list);
    }

    @RequestMapping(value={"/api/general-tokens/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<TokenResult>> searchGeneralTokens(@PathVariable(value="type") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="activationPeriod", required=false) List<DateTime> list2, @RequestParam(value="brokers", required=false) List<String> list3, @RequestParam(value="expiryPeriod", required=false) List<DateTime> list4, @RequestParam(value="groups", required=false) List<String> list5, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="statuses", required=false) List<TokenStatusEnum> list6, @RequestParam(value="user", required=false) String string2, @RequestParam(value="value", required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /general-tokens/{type}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchGeneralTokensParams searchGeneralTokensParams = new SearchGeneralTokensParams();
        searchGeneralTokensParams.type = string;
        searchGeneralTokensParams.fields = list;
        searchGeneralTokensParams.activationPeriod = list2;
        searchGeneralTokensParams.brokers = list3;
        searchGeneralTokensParams.expiryPeriod = list4;
        searchGeneralTokensParams.groups = list5;
        searchGeneralTokensParams.page = n;
        searchGeneralTokensParams.pageSize = n2;
        searchGeneralTokensParams.skipTotalCount = bl;
        searchGeneralTokensParams.statuses = list6;
        searchGeneralTokensParams.user = string2;
        searchGeneralTokensParams.value = string3;
        return this.impl.searchGeneralTokens(searchGeneralTokensParams);
    }

    @RequestMapping(value={"/api/tokens/{id}/set-activation-deadline"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> setTokenActivationDeadline(@PathVariable(value="id") String string, @RequestParam(value="date", required=false) DateTime dateTime, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tokens/{id}/set-activation-deadline");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.setTokenActivationDeadline(string, dateTime);
    }

    @RequestMapping(value={"/api/tokens/{id}/set-expiry-date"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> setTokenExpiryDate(@PathVariable(value="id") String string, @RequestParam(value="date", required=false) DateTime dateTime, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tokens/{id}/set-expiry-date");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.setTokenExpiryDate(string, dateTime);
    }

    @RequestMapping(value={"/api/tokens/{id}/unblock"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> unblockToken(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tokens/{id}/unblock");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.unblockToken(string);
    }

    @RequestMapping(value={"/api/tokens/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<TokenView> viewToken(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /tokens/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewToken(string, list);
    }

    public static class SearchGeneralTokensParams {
        public String type;
        public static final String TYPE = "type";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<DateTime> activationPeriod;
        public static final String ACTIVATION_PERIOD = "activationPeriod";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public List<DateTime> expiryPeriod;
        public static final String EXPIRY_PERIOD = "expiryPeriod";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<TokenStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public String user;
        public static final String USER = "user";
        public String value;
        public static final String VALUE = "value";
    }
}

