/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.ReferencesApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ReferenceDataForSet;
import org.cyclos.web.rest.model.ReferenceDirectionEnum;
import org.cyclos.web.rest.model.ReferenceLevelEnum;
import org.cyclos.web.rest.model.ReferenceSet;
import org.cyclos.web.rest.model.ReferenceStatistics;
import org.cyclos.web.rest.model.ReferenceView;
import org.cyclos.web.rest.model.UserReferenceDataForSearch;
import org.cyclos.web.rest.model.UserReferenceResult;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class ReferencesApi {
    @Autowired
    private ReferencesApiImpl impl;
    public static final String DELETE_REFERENCE = "/references/{id}";
    public static final String GET_REFERENCE_DATA_FOR_EDIT = "/references/{id}/data-for-edit";
    public static final String GET_REFERENCE_DATA_FOR_SET = "/{from}/reference/{to}/data-for-set";
    public static final String GET_USER_REFERENCE_STATISTICS = "/{user}/references/statistics";
    public static final String GET_USER_REFERENCES_DATA_FOR_SEARCH = "/{user}/references/data-for-search";
    public static final String SEARCH_USER_REFERENCES = "/{user}/references";
    public static final String SET_REFERENCE = "/{from}/reference/{to}";
    public static final String UPDATE_REFERENCE = "/references/{id}";
    public static final String VIEW_REFERENCE = "/references/{id}";

    @RequestMapping(value={"/api/references/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteReference(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /references/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteReference(string);
    }

    @RequestMapping(value={"/api/references/{id}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ReferenceDataForSet> getReferenceDataForEdit(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /references/{id}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getReferenceDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/{from:.*}/reference/{to:.*}/data-for-set"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ReferenceDataForSet> getReferenceDataForSet(@PathVariable(value="from") String string, @PathVariable(value="to") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{from}/reference/{to}/data-for-set");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getReferenceDataForSet(string, string2, list);
    }

    @RequestMapping(value={"/api/{user:.*}/references/statistics"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ReferenceStatistics> getUserReferenceStatistics(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="direction", required=false) ReferenceDirectionEnum referenceDirectionEnum, @RequestParam(value="periods", required=false) List<String> list2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/references/statistics");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        GetUserReferenceStatisticsParams getUserReferenceStatisticsParams = new GetUserReferenceStatisticsParams();
        getUserReferenceStatisticsParams.user = string;
        getUserReferenceStatisticsParams.fields = list;
        getUserReferenceStatisticsParams.direction = referenceDirectionEnum;
        getUserReferenceStatisticsParams.periods = list2;
        return this.impl.getUserReferenceStatistics(getUserReferenceStatisticsParams);
    }

    @RequestMapping(value={"/api/{user:.*}/references/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserReferenceDataForSearch> getUserReferencesDataForSearch(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/references/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserReferencesDataForSearch(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/references"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<UserReferenceResult>> searchUserReferences(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="direction", required=false) ReferenceDirectionEnum referenceDirectionEnum, @RequestParam(value="levels", required=false) List<ReferenceLevelEnum> list2, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="period", required=false) List<DateTime> list3, @RequestParam(value="relatedUser", required=false) String string2, @RequestParam(value="skipTotalCount", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/references");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchUserReferencesParams searchUserReferencesParams = new SearchUserReferencesParams();
        searchUserReferencesParams.user = string;
        searchUserReferencesParams.fields = list;
        searchUserReferencesParams.direction = referenceDirectionEnum;
        searchUserReferencesParams.levels = list2;
        searchUserReferencesParams.page = n;
        searchUserReferencesParams.pageSize = n2;
        searchUserReferencesParams.period = list3;
        searchUserReferencesParams.relatedUser = string2;
        searchUserReferencesParams.skipTotalCount = bl;
        return this.impl.searchUserReferences(searchUserReferencesParams);
    }

    @RequestMapping(value={"/api/{from:.*}/reference/{to:.*}"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> setReference(@PathVariable(value="from") String string, @PathVariable(value="to") String string2, @RequestBody(required=true) ReferenceSet referenceSet, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{from}/reference/{to}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.setReference(string, string2, referenceSet);
    }

    @RequestMapping(value={"/api/references/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateReference(@PathVariable(value="id") String string, @RequestBody(required=true) ReferenceSet referenceSet, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /references/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateReference(string, referenceSet);
    }

    @RequestMapping(value={"/api/references/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ReferenceView> viewReference(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /references/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewReference(string, list);
    }

    public static class GetUserReferenceStatisticsParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public ReferenceDirectionEnum direction;
        public static final String DIRECTION = "direction";
        public List<String> periods;
        public static final String PERIODS = "periods";
    }

    public static class SearchUserReferencesParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public ReferenceDirectionEnum direction;
        public static final String DIRECTION = "direction";
        public List<ReferenceLevelEnum> levels;
        public static final String LEVELS = "levels";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<DateTime> period;
        public static final String PERIOD = "period";
        public String relatedUser;
        public static final String RELATED_USER = "relatedUser";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
    }
}

