/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.users.phones.CodeVerificationStatus;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.phones.PhoneDTO;
import org.cyclos.model.users.phones.PhoneData;
import org.cyclos.model.users.phones.PhoneDataParams;
import org.cyclos.model.users.phones.PhoneListData;
import org.cyclos.model.users.phones.PhoneVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.users.PhoneService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.PhonesApiHelper;
import org.cyclos.web.rest.model.CodeVerificationStatusEnum;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.PhoneDataForEdit;
import org.cyclos.web.rest.model.PhoneDataForNew;
import org.cyclos.web.rest.model.PhoneEdit;
import org.cyclos.web.rest.model.PhoneKind;
import org.cyclos.web.rest.model.PhoneNew;
import org.cyclos.web.rest.model.PhoneResult;
import org.cyclos.web.rest.model.PhoneView;
import org.cyclos.web.rest.model.UserPhonesListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PhonesApiImpl
extends BaseApiImpl {
    @Autowired
    private PhoneService phoneService;
    @Autowired
    private PhonesApiHelper phonesApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public ResponseEntity<String> createPhone(String string, PhoneNew phoneNew, String string2) {
        if (phoneNew.getKind() == null) {
            throw new ValidationException("kind", "Missing parameter: kind");
        }
        MobilePhoneDTO mobilePhoneDTO = phoneNew.getKind() == PhoneKind.MOBILE ? this.phonesApiHelper.toMobilePhoneDTO(phoneNew) : this.phonesApiHelper.toLandLinePhoneDTO(phoneNew);
        mobilePhoneDTO.setUser((BasicUserVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        String string3 = ApiHelper.toId(this.phoneService.saveWithConfirmationPassword((EntityDTO)mobilePhoneDTO, string2));
        return this.created(this.apiHelper.uriFromApi("phones", string3), string3);
    }

    public ResponseEntity<Void> deletePhone(String string, String string2) {
        Long l = this.phonesApiHelper.ensureId(string);
        this.phoneService.removeWithConfirmationPassword(l, string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> disablePhoneForSms(String string, String string2) {
        this.phoneService.disableForSms((PhoneVO)ModelHelper.voFromString(PhoneVO.class, (String)string), string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> enablePhoneForSms(String string) {
        this.phoneService.enableForSms((PhoneVO)ModelHelper.voFromString(PhoneVO.class, (String)string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<PasswordInput> getPasswordInputForDisablePhoneForSms(String string, List<String> list) {
        CredentialInputDTO credentialInputDTO = this.phoneService.getConfirmationPasswordInputForDisableSms((PhoneVO)ModelHelper.voFromString(PhoneVO.class, (String)string));
        PasswordInput passwordInput = this.authApiHelper.toPasswordInput((ICredentialInputDTO)credentialInputDTO);
        return this.ok(passwordInput);
    }

    public ResponseEntity<PasswordInput> getPasswordInputForRemovePhone(String string, List<String> list) {
        Long l = this.phonesApiHelper.ensureId(string);
        CredentialInputDTO credentialInputDTO = this.phoneService.getConfirmationPasswordInputForRemove(l);
        PasswordInput passwordInput = this.authApiHelper.toPasswordInput((ICredentialInputDTO)credentialInputDTO);
        return this.ok(passwordInput);
    }

    public ResponseEntity<PhoneDataForEdit> getPhoneDataForEdit(String string, List<String> list) {
        Long l = this.phonesApiHelper.ensureId(string);
        PhoneData phoneData = (PhoneData)this.phoneService.getData(l);
        return this.ok(this.phonesApiHelper.toDataForEdit(phoneData));
    }

    public ResponseEntity<PhoneDataForNew> getPhoneDataForNew(String string, PhoneKind phoneKind, List<String> list) {
        PhoneDataParams phoneDataParams = new PhoneDataParams();
        phoneDataParams.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        phoneDataParams.setNature(phoneKind == null ? null : this.phonesApiHelper.toPhoneNature(PhoneKind.valueOf(phoneKind.name())));
        phoneDataParams.setSuggestPhoneName(true);
        PhoneData phoneData = (PhoneData)this.phoneService.getDataForNew((Object)phoneDataParams);
        return this.ok(this.phonesApiHelper.toDataForNew(phoneData));
    }

    public ResponseEntity<UserPhonesListData> getUserPhonesListData(String string, List<String> list) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        PhoneListData phoneListData = this.phoneService.getPhoneListData(userLocatorVO);
        UserPhonesListData userPhonesListData = this.phonesApiHelper.toUserPhonesListData(phoneListData);
        return this.ok(userPhonesListData);
    }

    public ResponseEntity<List<PhoneResult>> listPhonesByUser(String string, List<String> list) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        PhoneListData phoneListData = this.phoneService.getPhoneListData(userLocatorVO);
        UserPhonesListData userPhonesListData = this.phonesApiHelper.toUserPhonesListData(phoneListData);
        return this.ok(userPhonesListData.getPhones());
    }

    public ResponseEntity<String> sendPhoneVerificationCode(String string) {
        String string2 = this.phoneService.sendVerificationCode((PhoneVO)ModelHelper.voFromString(PhoneVO.class, (String)string));
        return ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).body((Object)string2);
    }

    public ResponseEntity<Void> updatePhone(String string, PhoneEdit phoneEdit, String string2) {
        Long l = this.phonesApiHelper.ensureId(string);
        PhoneDTO phoneDTO = (PhoneDTO)this.phoneService.load(l);
        Object object = phoneDTO instanceof MobilePhoneDTO ? this.phonesApiHelper.toMobilePhoneDTO(phoneEdit) : this.phonesApiHelper.toLandLinePhoneDTO(phoneEdit);
        object.setId(phoneDTO.getId());
        this.phoneService.saveWithConfirmationPassword((EntityDTO)object, string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity verifyPhone(String string, String string2) {
        CodeVerificationStatus codeVerificationStatus = this.phoneService.verify((PhoneVO)ModelHelper.voFromString(PhoneVO.class, (String)string), string2);
        CodeVerificationStatusEnum codeVerificationStatusEnum = this.phonesApiHelper.toCodeVerificationStatusEnum(codeVerificationStatus);
        return ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).body((Object)codeVerificationStatusEnum.toString());
    }

    public ResponseEntity<PhoneView> viewPhone(String string, List<String> list) {
        Long l = this.phonesApiHelper.ensureId(string);
        PhoneData phoneData = (PhoneData)this.phoneService.getData(l);
        return this.ok(this.phonesApiHelper.toPhoneView(phoneData));
    }
}

