/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.PaymentRequestsApiImpl;
import org.cyclos.web.rest.model.AcceptOrReschedulePaymentRequest;
import org.cyclos.web.rest.model.ChangePaymentRequestExpirationDate;
import org.cyclos.web.rest.model.DataForTransaction;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.PaymentRequestPreview;
import org.cyclos.web.rest.model.SendPaymentRequest;
import org.cyclos.web.rest.model.Transaction;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class PaymentRequestsApi {
    @Autowired
    private PaymentRequestsApiImpl impl;
    public static final String ACCEPT_PAYMENT_REQUEST = "/payment-requests/{key}/accept";
    public static final String CANCEL_PAYMENT_REQUEST = "/payment-requests/{key}/cancel";
    public static final String CHANGE_PAYMENT_REQUEST_EXPIRATION_DATE = "/payment-requests/{key}/change-expiration";
    public static final String DATA_FOR_SEND_PAYMENT_REQUEST = "/{owner}/payment-requests/data-for-send";
    public static final String PREVIEW_PAYMENT_REQUEST = "/payment-requests/{key}/preview";
    public static final String REJECT_PAYMENT_REQUEST = "/payment-requests/{key}/reject";
    public static final String RESCHEDULE_PAYMENT_REQUEST = "/payment-requests/{key}/reschedule";
    public static final String SEND_PAYMENT_REQUEST = "/{owner}/payment-requests";

    @RequestMapping(value={"/api/payment-requests/{key}/accept"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Transaction> acceptPaymentRequest(@PathVariable(value="key") String string, @RequestBody(required=true) AcceptOrReschedulePaymentRequest acceptOrReschedulePaymentRequest, @RequestParam(value="fields", required=false) List<String> list, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /payment-requests/{key}/accept");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        AcceptPaymentRequestParams acceptPaymentRequestParams = new AcceptPaymentRequestParams();
        acceptPaymentRequestParams.key = string;
        acceptPaymentRequestParams.acceptOrReschedulePaymentRequest = acceptOrReschedulePaymentRequest;
        acceptPaymentRequestParams.fields = list;
        acceptPaymentRequestParams.confirmationPassword = string2;
        return this.impl.acceptPaymentRequest(acceptPaymentRequestParams);
    }

    @RequestMapping(value={"/api/payment-requests/{key}/cancel"}, produces={"application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<Void> cancelPaymentRequest(@PathVariable(value="key") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, @RequestBody(required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /payment-requests/{key}/cancel");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.cancelPaymentRequest(string, string2, string3);
    }

    @RequestMapping(value={"/api/payment-requests/{key}/change-expiration"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> changePaymentRequestExpirationDate(@PathVariable(value="key") String string, @RequestBody(required=true) ChangePaymentRequestExpirationDate changePaymentRequestExpirationDate, @RequestParam(value="fields", required=false) List<String> list, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /payment-requests/{key}/change-expiration");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        ChangePaymentRequestExpirationDateParams changePaymentRequestExpirationDateParams = new ChangePaymentRequestExpirationDateParams();
        changePaymentRequestExpirationDateParams.key = string;
        changePaymentRequestExpirationDateParams.changePaymentRequestExpirationDate = changePaymentRequestExpirationDate;
        changePaymentRequestExpirationDateParams.fields = list;
        changePaymentRequestExpirationDateParams.confirmationPassword = string2;
        return this.impl.changePaymentRequestExpirationDate(changePaymentRequestExpirationDateParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/payment-requests/data-for-send"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForTransaction> dataForSendPaymentRequest(@PathVariable(value="owner") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="to", required=false) String string2, @RequestParam(value="type", required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/payment-requests/data-for-send");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        DataForSendPaymentRequestParams dataForSendPaymentRequestParams = new DataForSendPaymentRequestParams();
        dataForSendPaymentRequestParams.owner = string;
        dataForSendPaymentRequestParams.fields = list;
        dataForSendPaymentRequestParams.to = string2;
        dataForSendPaymentRequestParams.type = string3;
        return this.impl.dataForSendPaymentRequest(dataForSendPaymentRequestParams);
    }

    @RequestMapping(value={"/api/payment-requests/{key}/preview"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PaymentRequestPreview> previewPaymentRequest(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /payment-requests/{key}/preview");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.previewPaymentRequest(string, list);
    }

    @RequestMapping(value={"/api/payment-requests/{key}/reject"}, produces={"application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<Void> rejectPaymentRequest(@PathVariable(value="key") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, @RequestBody(required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /payment-requests/{key}/reject");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.rejectPaymentRequest(string, string2, string3);
    }

    @RequestMapping(value={"/api/payment-requests/{key}/reschedule"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Transaction> reschedulePaymentRequest(@PathVariable(value="key") String string, @RequestBody(required=true) AcceptOrReschedulePaymentRequest acceptOrReschedulePaymentRequest, @RequestParam(value="fields", required=false) List<String> list, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /payment-requests/{key}/reschedule");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        ReschedulePaymentRequestParams reschedulePaymentRequestParams = new ReschedulePaymentRequestParams();
        reschedulePaymentRequestParams.key = string;
        reschedulePaymentRequestParams.acceptOrReschedulePaymentRequest = acceptOrReschedulePaymentRequest;
        reschedulePaymentRequestParams.fields = list;
        reschedulePaymentRequestParams.confirmationPassword = string2;
        return this.impl.reschedulePaymentRequest(reschedulePaymentRequestParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/payment-requests"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Transaction> sendPaymentRequest(@PathVariable(value="owner") String string, @RequestBody(required=true) SendPaymentRequest sendPaymentRequest, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{owner}/payment-requests");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.sendPaymentRequest(string, sendPaymentRequest, list);
    }

    public static class AcceptPaymentRequestParams {
        public String key;
        public static final String KEY = "key";
        public AcceptOrReschedulePaymentRequest acceptOrReschedulePaymentRequest;
        public static final String ACCEPT_OR_RESCHEDULE_PAYMENT_REQUEST = "acceptOrReschedulePaymentRequest";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
    }

    public static class ChangePaymentRequestExpirationDateParams {
        public String key;
        public static final String KEY = "key";
        public ChangePaymentRequestExpirationDate changePaymentRequestExpirationDate;
        public static final String CHANGE_PAYMENT_REQUEST_EXPIRATION_DATE = "changePaymentRequestExpirationDate";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
    }

    public static class DataForSendPaymentRequestParams {
        public String owner;
        public static final String OWNER = "owner";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String to;
        public static final String TO = "to";
        public String type;
        public static final String TYPE = "type";
    }

    public static class ReschedulePaymentRequestParams {
        public String key;
        public static final String KEY = "key";
        public AcceptOrReschedulePaymentRequest acceptOrReschedulePaymentRequest;
        public static final String ACCEPT_OR_RESCHEDULE_PAYMENT_REQUEST = "acceptOrReschedulePaymentRequest";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
    }
}

