/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import org.cyclos.model.banking.accounts.AccountLimitsOverviewData;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.UserAccountPaymentAmountLimitData;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.banking.AccountService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.PaymentLimitsApi;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.PaymentLimitsApiHelper;
import org.cyclos.web.rest.model.AccountPaymentLimitsData;
import org.cyclos.web.rest.model.DataForPaymentLimitsSearch;
import org.cyclos.web.rest.model.GeneralAccountPaymentLimitsResult;
import org.cyclos.web.rest.model.UserAccountPaymentLimitsListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PaymentLimitsApiImpl
extends BaseApiImpl {
    @Autowired
    private PaymentLimitsApiHelper paymentLimitsApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private AccountService accountService;

    public ResponseEntity<InputStream> exportAccountPaymentLimits(PaymentLimitsApi.ExportAccountPaymentLimitsParams exportAccountPaymentLimitsParams) {
        PaymentLimitsApi.SearchAccountPaymentLimitsParams searchAccountPaymentLimitsParams = (PaymentLimitsApi.SearchAccountPaymentLimitsParams)ClassHelper.convert((Object)exportAccountPaymentLimitsParams, PaymentLimitsApi.SearchAccountPaymentLimitsParams.class);
        AccountPaymentAmountLimitsOverviewQuery accountPaymentAmountLimitsOverviewQuery = this.paymentLimitsApiHelper.toAccountPaymentAmountLimitsOverviewQuery(searchAccountPaymentLimitsParams);
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)exportAccountPaymentLimitsParams.format);
        FileInfo fileInfo = this.accountService.exportAccountPaymentAmountLimitsOverview(exportFormatVO, accountPaymentAmountLimitsOverviewQuery);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<AccountPaymentLimitsData> getAccountPaymentLimits(String string, String string2, List<String> list) {
        AccountVO accountVO = this.accountsApiHelper.toAccountVO(string, string2);
        UserAccountPaymentAmountLimitData userAccountPaymentAmountLimitData = this.accountService.getUserAccountPaymentAmountLimitData(accountVO);
        AccountPaymentLimitsData accountPaymentLimitsData = this.paymentLimitsApiHelper.toAccountPaymentAmountLimitsData(userAccountPaymentAmountLimitData);
        return this.ok(accountPaymentLimitsData);
    }

    public ResponseEntity<DataForPaymentLimitsSearch> getAccountPaymentLimitsData(List<String> list) {
        AccountLimitsOverviewData accountLimitsOverviewData = this.accountService.getAccountPaymentAmountLimitsOverviewData();
        DataForPaymentLimitsSearch dataForPaymentLimitsSearch = this.paymentLimitsApiHelper.toDataForPaymentAmountLimitsSearch(accountLimitsOverviewData);
        return this.ok(dataForPaymentLimitsSearch);
    }

    public ResponseEntity<UserAccountPaymentLimitsListData> getDataForUserPaymentLimits(String string, List<String> list) {
        List list2 = this.accountService.getUserAccountsPaymentAmountLimits((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        UserAccountPaymentLimitsListData userAccountPaymentLimitsListData = this.paymentLimitsApiHelper.toUserAccountPaymentAmountLimitsListData(string, list2);
        return this.ok(userAccountPaymentLimitsListData);
    }

    public ResponseEntity<List<GeneralAccountPaymentLimitsResult>> searchAccountPaymentLimits(PaymentLimitsApi.SearchAccountPaymentLimitsParams searchAccountPaymentLimitsParams) {
        AccountPaymentAmountLimitsOverviewQuery accountPaymentAmountLimitsOverviewQuery = this.paymentLimitsApiHelper.toAccountPaymentAmountLimitsOverviewQuery(searchAccountPaymentLimitsParams);
        Page page = this.accountService.searchAccountPaymentAmountLimitsOverview(accountPaymentAmountLimitsOverviewQuery);
        return this.pageResponse(page, this.paymentLimitsApiHelper::toGeneralAccountPaymentAmountLimitsResult);
    }

    public ResponseEntity<Void> setAccountPaymentLimits(PaymentLimitsApi.SetAccountPaymentLimitsParams setAccountPaymentLimitsParams) {
        this.accountService.setPaymentAmountLimit(this.paymentLimitsApiHelper.toAccountPaymentAmountLimitDTO(setAccountPaymentLimitsParams));
        return ResponseEntity.noContent().build();
    }
}

