/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.PaymentFeedbacksApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.PaymentFeedbackDataForEdit;
import org.cyclos.web.rest.model.PaymentFeedbackDataForGive;
import org.cyclos.web.rest.model.PaymentFeedbackDataForReply;
import org.cyclos.web.rest.model.PaymentFeedbackDataForSearch;
import org.cyclos.web.rest.model.PaymentFeedbackEdit;
import org.cyclos.web.rest.model.PaymentFeedbackGive;
import org.cyclos.web.rest.model.PaymentFeedbackResult;
import org.cyclos.web.rest.model.PaymentFeedbackView;
import org.cyclos.web.rest.model.ReferenceDirectionEnum;
import org.cyclos.web.rest.model.ReferenceLevelEnum;
import org.cyclos.web.rest.model.ReferenceStatistics;
import org.cyclos.web.rest.model.TransactionResult;
import org.cyclos.web.rest.model.User;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class PaymentFeedbacksApi {
    @Autowired
    private PaymentFeedbacksApiImpl impl;
    public static final String ADD_PAYMENT_FEEDBACK_IGNORED_USER = "/{user}/payment-feedback-ignored-users";
    public static final String GET_PAYMENT_FEEDBACK_DATA_FOR_EDIT = "/payment-feedbacks/{key}/data-for-edit";
    public static final String GET_PAYMENT_FEEDBACK_STATISTICS = "/{user}/payment-feedbacks/statistics";
    public static final String GET_PAYMENT_FEEDBACKS_DATA_FOR_GIVE = "/payment-feedbacks/{key}/data-for-give";
    public static final String GET_PAYMENT_FEEDBACKS_DATA_FOR_REPLY = "/payment-feedbacks/{key}/data-for-reply";
    public static final String GET_PAYMENT_FEEDBACKS_DATA_FOR_SEARCH = "/{user}/payment-feedbacks/data-for-search";
    public static final String GIVE_PAYMENT_FEEDBACK = "/payment-feedbacks/{key}/give";
    public static final String LIST_PAYMENT_FEEDBACK_IGNORED_USERS = "/{user}/payment-feedback-ignored-users";
    public static final String REMOVE_PAYMENT_FEEDBACK = "/payment-feedbacks/{key}";
    public static final String REMOVE_PAYMENT_FEEDBACK_IGNORED_USER = "/{user}/payment-feedback-ignored-users/{ignored}";
    public static final String REPLY_PAYMENT_FEEDBACK = "/payment-feedbacks/{key}/reply";
    public static final String SEARCH_PAYMENT_AWAITING_FEEDBACK = "/{user}/payments-awaiting-feedback";
    public static final String SEARCH_PAYMENT_FEEDBACKS = "/{user}/payment-feedbacks";
    public static final String UPDATE_PAYMENT_FEEDBACK = "/payment-feedbacks/{key}";
    public static final String VIEW_PAYMENT_FEEDBACK = "/payment-feedbacks/{key}";

    @RequestMapping(value={"/api/{user:.*}/payment-feedback-ignored-users"}, produces={"application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<Void> addPaymentFeedbackIgnoredUser(@PathVariable(value="user") String string, @RequestBody(required=true) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/payment-feedback-ignored-users");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.addPaymentFeedbackIgnoredUser(string, string2);
    }

    @RequestMapping(value={"/api/payment-feedbacks/{key}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PaymentFeedbackDataForEdit> getPaymentFeedbackDataForEdit(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /payment-feedbacks/{key}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPaymentFeedbackDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/payment-feedbacks/statistics"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ReferenceStatistics> getPaymentFeedbackStatistics(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="direction", required=false) ReferenceDirectionEnum referenceDirectionEnum, @RequestParam(value="periods", required=false) List<String> list2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/payment-feedbacks/statistics");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        GetPaymentFeedbackStatisticsParams getPaymentFeedbackStatisticsParams = new GetPaymentFeedbackStatisticsParams();
        getPaymentFeedbackStatisticsParams.user = string;
        getPaymentFeedbackStatisticsParams.fields = list;
        getPaymentFeedbackStatisticsParams.direction = referenceDirectionEnum;
        getPaymentFeedbackStatisticsParams.periods = list2;
        return this.impl.getPaymentFeedbackStatistics(getPaymentFeedbackStatisticsParams);
    }

    @RequestMapping(value={"/api/payment-feedbacks/{key}/data-for-give"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PaymentFeedbackDataForGive> getPaymentFeedbacksDataForGive(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /payment-feedbacks/{key}/data-for-give");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPaymentFeedbacksDataForGive(string, list);
    }

    @RequestMapping(value={"/api/payment-feedbacks/{key}/data-for-reply"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PaymentFeedbackDataForReply> getPaymentFeedbacksDataForReply(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /payment-feedbacks/{key}/data-for-reply");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPaymentFeedbacksDataForReply(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/payment-feedbacks/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PaymentFeedbackDataForSearch> getPaymentFeedbacksDataForSearch(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/payment-feedbacks/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPaymentFeedbacksDataForSearch(string, list);
    }

    @RequestMapping(value={"/api/payment-feedbacks/{key}/give"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> givePaymentFeedback(@PathVariable(value="key") String string, @RequestBody(required=true) PaymentFeedbackGive paymentFeedbackGive, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /payment-feedbacks/{key}/give");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.givePaymentFeedback(string, paymentFeedbackGive);
    }

    @RequestMapping(value={"/api/{user:.*}/payment-feedback-ignored-users"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<User>> listPaymentFeedbackIgnoredUsers(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/payment-feedback-ignored-users");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listPaymentFeedbackIgnoredUsers(string, list);
    }

    @RequestMapping(value={"/api/payment-feedbacks/{key}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> removePaymentFeedback(@PathVariable(value="key") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /payment-feedbacks/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.removePaymentFeedback(string);
    }

    @RequestMapping(value={"/api/{user:.*}/payment-feedback-ignored-users/{ignored}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> removePaymentFeedbackIgnoredUser(@PathVariable(value="user") String string, @PathVariable(value="ignored") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /{user}/payment-feedback-ignored-users/{ignored}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.removePaymentFeedbackIgnoredUser(string, string2);
    }

    @RequestMapping(value={"/api/payment-feedbacks/{key}/reply"}, produces={"application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<Void> replyPaymentFeedback(@PathVariable(value="key") String string, @RequestBody(required=true) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /payment-feedbacks/{key}/reply");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.replyPaymentFeedback(string, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/payments-awaiting-feedback"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<TransactionResult>> searchPaymentAwaitingFeedback(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="relatedUser", required=false) String string2, @RequestParam(value="skipTotalCount", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/payments-awaiting-feedback");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchPaymentAwaitingFeedbackParams searchPaymentAwaitingFeedbackParams = new SearchPaymentAwaitingFeedbackParams();
        searchPaymentAwaitingFeedbackParams.user = string;
        searchPaymentAwaitingFeedbackParams.fields = list;
        searchPaymentAwaitingFeedbackParams.page = n;
        searchPaymentAwaitingFeedbackParams.pageSize = n2;
        searchPaymentAwaitingFeedbackParams.relatedUser = string2;
        searchPaymentAwaitingFeedbackParams.skipTotalCount = bl;
        return this.impl.searchPaymentAwaitingFeedback(searchPaymentAwaitingFeedbackParams);
    }

    @RequestMapping(value={"/api/{user:.*}/payment-feedbacks"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<PaymentFeedbackResult>> searchPaymentFeedbacks(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="direction", required=false) ReferenceDirectionEnum referenceDirectionEnum, @RequestParam(value="levels", required=false) List<ReferenceLevelEnum> list2, @RequestParam(value="noReplied", required=false) Boolean bl, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="period", required=false) List<DateTime> list3, @RequestParam(value="relatedUser", required=false) String string2, @RequestParam(value="skipTotalCount", required=false) Boolean bl2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/payment-feedbacks");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchPaymentFeedbacksParams searchPaymentFeedbacksParams = new SearchPaymentFeedbacksParams();
        searchPaymentFeedbacksParams.user = string;
        searchPaymentFeedbacksParams.fields = list;
        searchPaymentFeedbacksParams.direction = referenceDirectionEnum;
        searchPaymentFeedbacksParams.levels = list2;
        searchPaymentFeedbacksParams.noReplied = bl;
        searchPaymentFeedbacksParams.page = n;
        searchPaymentFeedbacksParams.pageSize = n2;
        searchPaymentFeedbacksParams.period = list3;
        searchPaymentFeedbacksParams.relatedUser = string2;
        searchPaymentFeedbacksParams.skipTotalCount = bl2;
        return this.impl.searchPaymentFeedbacks(searchPaymentFeedbacksParams);
    }

    @RequestMapping(value={"/api/payment-feedbacks/{key}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updatePaymentFeedback(@PathVariable(value="key") String string, @RequestBody(required=true) PaymentFeedbackEdit paymentFeedbackEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /payment-feedbacks/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updatePaymentFeedback(string, paymentFeedbackEdit);
    }

    @RequestMapping(value={"/api/payment-feedbacks/{key}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PaymentFeedbackView> viewPaymentFeedback(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /payment-feedbacks/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewPaymentFeedback(string, list);
    }

    public static class GetPaymentFeedbackStatisticsParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public ReferenceDirectionEnum direction;
        public static final String DIRECTION = "direction";
        public List<String> periods;
        public static final String PERIODS = "periods";
    }

    public static class SearchPaymentAwaitingFeedbackParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public String relatedUser;
        public static final String RELATED_USER = "relatedUser";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
    }

    public static class SearchPaymentFeedbacksParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public ReferenceDirectionEnum direction;
        public static final String DIRECTION = "direction";
        public List<ReferenceLevelEnum> levels;
        public static final String LEVELS = "levels";
        public Boolean noReplied;
        public static final String NO_REPLIED = "noReplied";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<DateTime> period;
        public static final String PERIOD = "period";
        public String relatedUser;
        public static final String RELATED_USER = "relatedUser";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
    }
}

