/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.access.passwords.ChangeGeneratedPasswordDTO;
import org.cyclos.model.access.passwords.ChangePasswordDTO;
import org.cyclos.model.access.passwords.PasswordActionDTO;
import org.cyclos.model.access.passwords.PasswordData;
import org.cyclos.model.access.passwords.ResetAndSendPasswordDTO;
import org.cyclos.model.access.passwords.SetSecurityQuestionDTO;
import org.cyclos.model.access.passwords.UserPasswordsData;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.access.PasswordService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.PasswordsApiHelper;
import org.cyclos.web.rest.model.ChangePassword;
import org.cyclos.web.rest.model.DataForUserPasswords;
import org.cyclos.web.rest.model.PasswordStatusAndActions;
import org.cyclos.web.rest.model.PasswordStatusAndType;
import org.cyclos.web.rest.model.SendMediumEnum;
import org.cyclos.web.rest.model.SetSecurityAnswer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PasswordsApiImpl
extends BaseApiImpl {
    @Autowired
    private PasswordService passwordService;
    @Autowired
    private PasswordsApiHelper passwordsApiHelper;

    public ResponseEntity<Void> allowGeneration(String string, String string2) {
        PasswordActionDTO passwordActionDTO = this.passwordsApiHelper.toPasswordActionDTO(string, string2);
        this.passwordService.allowActivation(passwordActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<String> changeGenerated(String string, String string2) {
        ChangeGeneratedPasswordDTO changeGeneratedPasswordDTO = this.passwordsApiHelper.toChangeGeneratedPasswordDTO(string, string2);
        String string3 = this.passwordService.generateNew(changeGeneratedPasswordDTO);
        return ResponseEntity.ok().contentType(TEXT).body((Object)string3);
    }

    public ResponseEntity<Void> changePassword(String string, String string2, ChangePassword changePassword) {
        ChangePasswordDTO changePasswordDTO = this.passwordsApiHelper.toChangePasswordDTO(string, string2, changePassword);
        this.passwordService.change(changePasswordDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> disablePassword(String string, String string2) {
        PasswordActionDTO passwordActionDTO = this.passwordsApiHelper.toPasswordActionDTO(string, string2);
        this.passwordService.disable(passwordActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> enablePassword(String string, String string2) {
        PasswordActionDTO passwordActionDTO = this.passwordsApiHelper.toPasswordActionDTO(string, string2);
        this.passwordService.enable(passwordActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<String> generatePassword(String string) {
        String string2 = this.passwordService.activate((PasswordTypeVO)ModelHelper.voFromString(PasswordTypeVO.class, (String)string));
        return ResponseEntity.ok().contentType(TEXT).body((Object)string2);
    }

    public ResponseEntity<PasswordStatusAndActions> getUserPasswordsData(String string, String string2, List<String> list) {
        PasswordData passwordData = this.passwordService.getPasswordData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string), (PasswordTypeVO)ModelHelper.voFromString(PasswordTypeVO.class, (String)string2));
        return this.ok(this.passwordsApiHelper.toPasswordStatusAndActions(passwordData));
    }

    public ResponseEntity<DataForUserPasswords> getUserPasswordsListData(String string, List<String> list) {
        UserPasswordsData userPasswordsData = this.passwordService.getData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        DataForUserPasswords dataForUserPasswords = this.passwordsApiHelper.toDataForUserPasswords(userPasswordsData);
        return this.ok(dataForUserPasswords);
    }

    public ResponseEntity<List<PasswordStatusAndType>> listUserPasswords(String string, List<String> list) {
        UserPasswordsData userPasswordsData = this.passwordService.getData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        return this.ok(this.passwordsApiHelper.toPasswordStatusAndType(userPasswordsData));
    }

    public ResponseEntity<Void> resetAndSendPassword(String string, String string2, List<SendMediumEnum> list) {
        ResetAndSendPasswordDTO resetAndSendPasswordDTO = this.passwordsApiHelper.toResetAndSendPasswordDTO(string, string2, list);
        this.passwordService.resetAndSend(resetAndSendPasswordDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> resetGeneratedPassword(String string, String string2) {
        PasswordActionDTO passwordActionDTO = this.passwordsApiHelper.toPasswordActionDTO(string, string2);
        this.passwordService.reset(passwordActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> resetUserSecurityAnswer(String string) {
        this.passwordService.resetSecurityQuestion((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> setSecurityAnswer(SetSecurityAnswer setSecurityAnswer) {
        SetSecurityQuestionDTO setSecurityQuestionDTO = this.passwordsApiHelper.toSetSecurityQuestionDTO(setSecurityAnswer);
        this.passwordService.setSecurityQuestion(setSecurityQuestionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> unblockPassword(String string, String string2) {
        PasswordActionDTO passwordActionDTO = this.passwordsApiHelper.toPasswordActionDTO(string, string2);
        this.passwordService.unblock(passwordActionDTO);
        return ResponseEntity.noContent().build();
    }
}

