/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.users.operatorgroups.OperatorGroupListData;
import org.cyclos.model.users.operators.OperatorDataParams;
import org.cyclos.model.users.operators.OperatorQuery;
import org.cyclos.model.users.operators.OperatorRegistrationDTO;
import org.cyclos.model.users.operators.OperatorRegistrationData;
import org.cyclos.model.users.operators.OperatorsSearchData;
import org.cyclos.model.users.operators.ViewOperatorProfileData;
import org.cyclos.model.users.users.AbstractViewProfileData;
import org.cyclos.model.users.users.BaseUserRegistrationResult;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.users.OperatorGroupService;
import org.cyclos.services.users.OperatorService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.OperatorsApi;
import org.cyclos.web.rest.helpers.OperatorsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.EntityReference;
import org.cyclos.web.rest.model.GeneralOperatorsDataForSearch;
import org.cyclos.web.rest.model.GeneralOperatorsQueryFilters;
import org.cyclos.web.rest.model.OperatorDataForNew;
import org.cyclos.web.rest.model.OperatorNew;
import org.cyclos.web.rest.model.OperatorResult;
import org.cyclos.web.rest.model.UserOperatorsDataForSearch;
import org.cyclos.web.rest.model.UserOperatorsQueryFilters;
import org.cyclos.web.rest.model.UserRegistrationResult;
import org.cyclos.web.rest.model.UserView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class OperatorsApiImpl
extends BaseApiImpl {
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private OperatorGroupService operatorGroupService;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private OperatorsApiHelper operatorsApiHelper;

    public ResponseEntity<GeneralOperatorsDataForSearch> getGeneralOperatorsDataForSearch(List<String> list) {
        OperatorsSearchData operatorsSearchData = this.operatorService.getSearchData(null);
        GeneralOperatorsDataForSearch generalOperatorsDataForSearch = this.operatorsApiHelper.toGeneralOperatorsDataForSearch(operatorsSearchData);
        return this.ok(generalOperatorsDataForSearch);
    }

    public ResponseEntity<List<EntityReference>> getGroupsForOperatorRegistration(String string, List<String> list) {
        OperatorGroupListData operatorGroupListData = this.operatorGroupService.getListData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        List list2 = operatorGroupListData.getGroups().stream().map(this.apiHelper::toReference).collect(Collectors.toList());
        return this.ok(list2);
    }

    public ResponseEntity<OperatorDataForNew> getOperatorDataForNew(String string, List<String> list, String string2) {
        OperatorDataParams operatorDataParams = this.operatorsApiHelper.toOperatorDataParams(string, string2);
        OperatorRegistrationData operatorRegistrationData = (OperatorRegistrationData)this.operatorService.getDataForNew((Object)operatorDataParams);
        OperatorDataForNew operatorDataForNew = this.operatorsApiHelper.toOperatorDataForNew(operatorRegistrationData);
        return this.ok(operatorDataForNew);
    }

    public ResponseEntity<UserOperatorsDataForSearch> getUserOperatorsDataForSearch(String string, List<String> list) {
        OperatorsSearchData operatorsSearchData = this.operatorService.getSearchData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        UserOperatorsDataForSearch userOperatorsDataForSearch = this.operatorsApiHelper.toUserOperatorsDataForSearch(operatorsSearchData);
        return this.ok(userOperatorsDataForSearch);
    }

    public ResponseEntity<UserRegistrationResult> registerOperator(String string, OperatorNew operatorNew) {
        OperatorRegistrationDTO operatorRegistrationDTO = this.operatorsApiHelper.toOperatorRegistrationDTO(string, operatorNew);
        org.cyclos.model.users.users.UserRegistrationResult userRegistrationResult = this.operatorService.register(operatorRegistrationDTO);
        String string2 = this.usersApiHelper.getUserIdentification((BaseUserRegistrationResult)userRegistrationResult);
        URI uRI = this.apiHelper.uriFromApi("operators", string2);
        return ResponseEntity.created((URI)uRI).body((Object)this.usersApiHelper.toUserRegistrationResult(userRegistrationResult));
    }

    public ResponseEntity<List<OperatorResult>> searchGeneralOperators(OperatorsApi.SearchGeneralOperatorsParams searchGeneralOperatorsParams) {
        GeneralOperatorsQueryFilters generalOperatorsQueryFilters = (GeneralOperatorsQueryFilters)ClassHelper.convert((Object)searchGeneralOperatorsParams, GeneralOperatorsQueryFilters.class);
        OperatorQuery operatorQuery = this.operatorsApiHelper.toOperatorQuery(generalOperatorsQueryFilters);
        Page page = this.operatorService.search(operatorQuery);
        return this.pageResponse(page, this.operatorsApiHelper::toOperatorResult);
    }

    public ResponseEntity<List<OperatorResult>> searchUserOperators(OperatorsApi.SearchUserOperatorsParams searchUserOperatorsParams) {
        UserOperatorsQueryFilters userOperatorsQueryFilters = (UserOperatorsQueryFilters)ClassHelper.convert((Object)searchUserOperatorsParams, UserOperatorsQueryFilters.class);
        OperatorQuery operatorQuery = this.operatorsApiHelper.toOperatorQuery(searchUserOperatorsParams.user, userOperatorsQueryFilters);
        Page page = this.operatorService.search(operatorQuery);
        return this.pageResponse(page, this.operatorsApiHelper::toOperatorResult);
    }

    public ResponseEntity<UserView> viewOperator(String string, List<String> list) {
        ViewOperatorProfileData viewOperatorProfileData = this.operatorService.getViewProfileData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        return this.ok(this.usersApiHelper.toUserView((AbstractViewProfileData)viewOperatorProfileData));
    }
}

