/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.MobileApiImpl;
import org.cyclos.web.rest.model.DataForMobileGuest;
import org.cyclos.web.rest.model.DataForMobileUser;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class MobileApi {
    @Autowired
    private MobileApiImpl impl;
    public static final String DATA_FOR_MOBILE_GUEST = "/mobile/data-for-guest";
    public static final String DATA_FOR_MOBILE_USER = "/mobile/data-for-user";
    public static final String MOBILE_PAGE_CONTENT = "/mobile/page/{key}";

    @RequestMapping(value={"/api/mobile/data-for-guest"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForMobileGuest> dataForMobileGuest(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="cyclosVersion", required=false) String string, @RequestParam(value="headerIf", required=false) String string2, @RequestParam(value="footerIf", required=false) String string3, @RequestParam(value="themeIf", required=false) String string4, @RequestParam(value="welcomePageIf", required=false) String string5, @RequestParam(value="translationsIf", required=false) String string6, @RequestParam(value="deviceId", required=false) String string7, @RequestParam(value="pinPrincipal", required=false) String string8, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /mobile/data-for-guest");
        httpServletRequest.setAttribute("errorType", Error.class);
        DataForMobileGuestParams dataForMobileGuestParams = new DataForMobileGuestParams();
        dataForMobileGuestParams.fields = list;
        dataForMobileGuestParams.cyclosVersion = string;
        dataForMobileGuestParams.headerIf = string2;
        dataForMobileGuestParams.footerIf = string3;
        dataForMobileGuestParams.themeIf = string4;
        dataForMobileGuestParams.welcomePageIf = string5;
        dataForMobileGuestParams.translationsIf = string6;
        dataForMobileGuestParams.deviceId = string7;
        dataForMobileGuestParams.pinPrincipal = string8;
        return this.impl.dataForMobileGuest(dataForMobileGuestParams);
    }

    @RequestMapping(value={"/api/mobile/data-for-user"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForMobileUser> dataForMobileUser(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="cyclosVersion", required=false) String string, @RequestParam(value="themeIf", required=false) String string2, @RequestParam(value="translationsIf", required=false) String string3, @RequestParam(value="mobileHelpIf", required=false) String string4, @RequestParam(value="posHelpIf", required=false) String string5, @RequestParam(value="homePageIf", required=false) String string6, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /mobile/data-for-user");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        DataForMobileUserParams dataForMobileUserParams = new DataForMobileUserParams();
        dataForMobileUserParams.fields = list;
        dataForMobileUserParams.cyclosVersion = string;
        dataForMobileUserParams.themeIf = string2;
        dataForMobileUserParams.translationsIf = string3;
        dataForMobileUserParams.mobileHelpIf = string4;
        dataForMobileUserParams.posHelpIf = string5;
        dataForMobileUserParams.homePageIf = string6;
        return this.impl.dataForMobileUser(dataForMobileUserParams);
    }

    @RequestMapping(value={"/api/mobile/page/{key}"}, produces={"text/html", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<String> mobilePageContent(@PathVariable(value="key") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /mobile/page/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.mobilePageContent(string);
    }

    public static class DataForMobileGuestParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String cyclosVersion;
        public static final String CYCLOS_VERSION = "cyclosVersion";
        public String headerIf;
        public static final String HEADER_IF = "headerIf";
        public String footerIf;
        public static final String FOOTER_IF = "footerIf";
        public String themeIf;
        public static final String THEME_IF = "themeIf";
        public String welcomePageIf;
        public static final String WELCOME_PAGE_IF = "welcomePageIf";
        public String translationsIf;
        public static final String TRANSLATIONS_IF = "translationsIf";
        public String deviceId;
        public static final String DEVICE_ID = "deviceId";
        public String pinPrincipal;
        public static final String PIN_PRINCIPAL = "pinPrincipal";
    }

    public static class DataForMobileUserParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String cyclosVersion;
        public static final String CYCLOS_VERSION = "cyclosVersion";
        public String themeIf;
        public static final String THEME_IF = "themeIf";
        public String translationsIf;
        public static final String TRANSLATIONS_IF = "translationsIf";
        public String mobileHelpIf;
        public static final String MOBILE_HELP_IF = "mobileHelpIf";
        public String posHelpIf;
        public static final String POS_HELP_IF = "posHelpIf";
        public String homePageIf;
        public static final String HOME_PAGE_IF = "homePageIf";
    }
}

