/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.identityproviders.IdentityProviderCallbackResult;
import org.cyclos.model.access.identityproviders.IdentityProviderRequestType;
import org.cyclos.model.access.identityproviders.IdentityProviderVO;
import org.cyclos.model.access.useridentityproviders.UserIdentityProviderListData;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.Cookie;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.NotificationLevel;
import org.cyclos.server.model.access.identityproviders.IdentityProviderRequest;
import org.cyclos.server.model.access.identityproviders.IdentityProviderRequestResult;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.services.access.CallbackResult;
import org.cyclos.services.access.InternalIdentityProviderService;
import org.cyclos.services.access.UserIdentityProviderService;
import org.cyclos.services.contentmanagement.InternalTranslationMessageService;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageProducer;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.IdentityProvidersApiHelper;
import org.cyclos.web.rest.model.UserIdentityProvidersListData;
import org.cyclos.web.utils.RequestHelper;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component
public class IdentityProvidersApiImpl
extends BaseApiImpl {
    @Autowired
    private IdentityProvidersApiHelper identityProvidersApiHelper;
    @Autowired
    private InternalIdentityProviderService internalIdentityProviderService;
    @Autowired
    private UserIdentityProviderService userIdentityProviderService;
    @Autowired
    private JsonConverter jsonConverter;
    @Autowired
    private InternalTranslationMessageService internalTranslationMessageService;

    public ResponseEntity<Void> deleteUserIdentityProvider(String string, String string2, Boolean bl) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        IdentityProviderVO identityProviderVO = (IdentityProviderVO)ModelHelper.voFromString(IdentityProviderVO.class, (String)string2);
        if (Boolean.TRUE.equals(bl)) {
            this.userIdentityProviderService.disable(userLocatorVO, identityProviderVO);
        } else {
            this.userIdentityProviderService.unlink(userLocatorVO, identityProviderVO);
        }
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<UserIdentityProvidersListData> getUserIdentityProvidersListData(String string, List<String> list) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        UserIdentityProviderListData userIdentityProviderListData = this.userIdentityProviderService.getListData(userLocatorVO);
        UserIdentityProvidersListData userIdentityProvidersListData = this.identityProvidersApiHelper.toUserIdentityProvidersListData(userIdentityProviderListData);
        return this.ok(userIdentityProvidersListData);
    }

    public ModelAndView identityProviderCallback() throws JsonGenerationException, JsonMappingException {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        String string = RequestHelper.getCookieValue(httpServletRequest, Cookie.IDENTITY_PROVIDER_REQUEST_ID);
        try {
            Object object;
            CallbackResult callbackResult = this.internalIdentityProviderService.callback(string);
            if (callbackResult.isDestroyed()) {
                ServletHelper.sendCookie(httpServletRequest, httpServletResponse, null, true, false, Cookie.IDENTITY_PROVIDER_REQUEST_ID, null);
            }
            if ((object = callbackResult.getRedirectUrl()) != null) {
                IdentityProviderCallbackResult identityProviderCallbackResult = callbackResult.getResult();
                org.cyclos.web.rest.model.IdentityProviderCallbackResult identityProviderCallbackResult2 = this.identityProvidersApiHelper.toIdentityProviderCallbackResult(identityProviderCallbackResult);
                String string2 = this.jsonConverter.writeValueAsString((Object)identityProviderCallbackResult2);
                object = (String)object + (((String)object).contains("?") ? "&" : "?") + "result=" + StringHelper.encodeURIComponent((String)string2);
            }
            return new ModelAndView("idp-callback").addObject("redirectUrl", object);
        }
        catch (LoginException loginException) {
            String string3;
            try {
                string3 = this.message(MessageFormat.HTML, GeneralKeys.Ui.BROWSER_NOT_SUPPORTED, new Object[0]);
            }
            catch (Exception exception) {
                string3 = "Your browser is not supported";
            }
            return ServletHelper.sendNotification(NotificationLevel.ERROR, loginException.translate((MessageProducer)this.internalTranslationMessageService), string3, true);
        }
    }

    public ModelAndView identityProviderRedirect(String string) {
        String string2 = this.internalIdentityProviderService.redirect(string);
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        ServletHelper.sendCookie(httpServletRequest, httpServletResponse, null, true, false, Cookie.IDENTITY_PROVIDER_REQUEST_ID, string);
        return new ModelAndView("idp-redirect").addObject("redirectUrl", (Object)string2);
    }

    public ResponseEntity<org.cyclos.web.rest.model.IdentityProviderRequestResult> prepareIdentityProviderLink(String string) {
        return this.request(IdentityProviderRequestType.LINK, string, null, null, null);
    }

    public ResponseEntity<org.cyclos.web.rest.model.IdentityProviderRequestResult> prepareIdentityProviderLogin(String string, String string2) {
        return this.request(IdentityProviderRequestType.LOGIN, string, string2, null, null);
    }

    public ResponseEntity<org.cyclos.web.rest.model.IdentityProviderRequestResult> prepareIdentityProviderRegistration(String string, String string2, String string3) {
        return this.request(IdentityProviderRequestType.REGISTER, string, string3, string2, null);
    }

    public ResponseEntity<org.cyclos.web.rest.model.IdentityProviderRequestResult> prepareIdentityProviderWizard(String string, String string2) {
        return this.request(IdentityProviderRequestType.WIZARD, string, null, null, string2);
    }

    private ResponseEntity<org.cyclos.web.rest.model.IdentityProviderRequestResult> request(IdentityProviderRequestType identityProviderRequestType, String string, String string2, String string3, String string4) {
        IdentityProviderRequest identityProviderRequest = new IdentityProviderRequest();
        identityProviderRequest.setType(identityProviderRequestType);
        identityProviderRequest.setIdentityProvider((IdentityProviderVO)ModelHelper.voFromString(IdentityProviderVO.class, (String)string));
        identityProviderRequest.setUserAgentId(string2);
        identityProviderRequest.setGroup((GroupVO)ModelHelper.voFromString(GroupVO.class, (String)string3));
        identityProviderRequest.setWizardExecution(string4);
        IdentityProviderRequestResult identityProviderRequestResult = this.internalIdentityProviderService.request(identityProviderRequest);
        return this.ok(this.identityProvidersApiHelper.toIdentityProviderRequestResult(identityProviderRequestResult));
    }
}

