/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.FrontendApiImpl;
import org.cyclos.web.rest.model.DataForFrontend;
import org.cyclos.web.rest.model.DataForFrontendHome;
import org.cyclos.web.rest.model.DataForUserQuickAccess;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.FrontendHomeContent;
import org.cyclos.web.rest.model.FrontendPageWithContent;
import org.cyclos.web.rest.model.FrontendScreenSizeEnum;
import org.cyclos.web.rest.model.FrontendSettings;
import org.cyclos.web.rest.model.UserQuickAccessSettingsEdit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class FrontendApi {
    @Autowired
    private FrontendApiImpl impl;
    public static final String DATA_FOR_FRONTEND = "/frontend/data";
    public static final String DATA_FOR_FRONTEND_HOME = "/frontend/home";
    public static final String GET_DATA_FOR_USER_QUICK_ACCESS = "/frontend/{user}/quick-access";
    public static final String GET_FRONTEND_HELP = "/frontend/help";
    public static final String GET_FRONTEND_ICONS = "/frontend/icons";
    public static final String RESTORE_USER_QUICK_ACCESS_DEFAULTS = "/frontend/{user}/quick-access/defaults";
    public static final String SAVE_FRONTEND_SETTINGS = "/frontend/settings";
    public static final String SAVE_USER_QUICK_ACCESS = "/frontend/{user}/quick-access";
    public static final String VIEW_FRONTEND_PAGE = "/frontend/page/{key}";

    @RequestMapping(value={"/api/frontend/data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForFrontend> dataForFrontend(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="screenSize", required=false) FrontendScreenSizeEnum frontendScreenSizeEnum, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /frontend/data");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.dataForFrontend(list, frontendScreenSizeEnum);
    }

    @RequestMapping(value={"/api/frontend/home"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForFrontendHome> dataForFrontendHome(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="screenSize", required=false) FrontendScreenSizeEnum frontendScreenSizeEnum, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /frontend/home");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.dataForFrontendHome(list, frontendScreenSizeEnum);
    }

    @RequestMapping(value={"/api/frontend/{user:.*}/quick-access"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForUserQuickAccess> getDataForUserQuickAccess(@PathVariable(value="user") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /frontend/{user}/quick-access");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getDataForUserQuickAccess(string);
    }

    @RequestMapping(value={"/api/frontend/help"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<FrontendHomeContent> getFrontendHelp(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /frontend/help");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getFrontendHelp(list);
    }

    @RequestMapping(value={"/api/frontend/icons"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, String>> getFrontendIcons(@RequestParam(value="names", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /frontend/icons");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getFrontendIcons(list);
    }

    @RequestMapping(value={"/api/frontend/{user:.*}/quick-access/defaults"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> restoreUserQuickAccessDefaults(@PathVariable(value="user") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /frontend/{user}/quick-access/defaults");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.restoreUserQuickAccessDefaults(string);
    }

    @RequestMapping(value={"/api/frontend/settings"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> saveFrontendSettings(@RequestBody(required=false) FrontendSettings frontendSettings, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /frontend/settings");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.saveFrontendSettings(frontendSettings);
    }

    @RequestMapping(value={"/api/frontend/{user:.*}/quick-access"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> saveUserQuickAccess(@PathVariable(value="user") String string, @RequestBody(required=true) UserQuickAccessSettingsEdit userQuickAccessSettingsEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /frontend/{user}/quick-access");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.saveUserQuickAccess(string, userQuickAccessSettingsEdit);
    }

    @RequestMapping(value={"/api/frontend/page/{key}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<FrontendPageWithContent> viewFrontendPage(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /frontend/page/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.viewFrontendPage(string, list);
    }
}

