/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.ClientsApiImpl;
import org.cyclos.web.rest.model.ActivateClientResult;
import org.cyclos.web.rest.model.ClientView;
import org.cyclos.web.rest.model.CreateClientParams;
import org.cyclos.web.rest.model.DataForClientActivation;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.OtpResult;
import org.cyclos.web.rest.model.SendOtp;
import org.cyclos.web.rest.model.UserClientTypePermissions;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class ClientsApi {
    @Autowired
    private ClientsApiImpl impl;
    public static final String ACTIVATE_CLIENT = "/clients/activate";
    public static final String CREATE_AND_ACTIVATE_CLIENT = "/clients/{type}";
    public static final String GET_DATA_FOR_CLIENT_ACTIVATION = "/clients/data-for-activation";
    public static final String LIST_CLIENT_TYPES_FOR_USER = "/{user}/client-types";
    public static final String SEND_CLIENT_ACTIVATION_CODE = "/clients/send-activaction-code";
    public static final String UNASSIGN_CLIENT = "/clients/{key}/unassign";
    public static final String VIEW_CLIENT = "/clients/{key}";

    @RequestMapping(value={"/api/clients/activate"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ActivateClientResult> activateClient(@RequestParam(value="code", required=true) String string, @RequestParam(value="prefix", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /clients/activate");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.activateClient(string, string2);
    }

    @RequestMapping(value={"/api/clients/{type}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ActivateClientResult> createAndActivateClient(@PathVariable(value="type") String string, @RequestBody(required=true) CreateClientParams createClientParams, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /clients/{type}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.createAndActivateClient(string, createClientParams);
    }

    @RequestMapping(value={"/api/clients/data-for-activation"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForClientActivation> getDataForClientActivation(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="channel", required=false) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /clients/data-for-activation");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDataForClientActivation(list, string);
    }

    @RequestMapping(value={"/api/{user:.*}/client-types"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<UserClientTypePermissions>> listClientTypesForUser(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="channel", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/client-types");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listClientTypesForUser(string, list, string2);
    }

    @RequestMapping(value={"/api/clients/send-activaction-code"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<OtpResult> sendClientActivationCode(@RequestBody(required=true) SendOtp sendOtp, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /clients/send-activaction-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.sendClientActivationCode(sendOtp, list);
    }

    @RequestMapping(value={"/api/clients/{key}/unassign"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> unassignClient(@PathVariable(value="key") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /clients/{key}/unassign");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.unassignClient(string, string2);
    }

    @RequestMapping(value={"/api/clients/{key}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ClientView> viewClient(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /clients/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewClient(string, list);
    }
}

