/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.model.ActionWithConfirmationPassword;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.access.LoginData;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.passwords.ChangeForgottenPasswordDTO;
import org.cyclos.model.access.passwords.ChangeForgottenPasswordData;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.ForgotPasswordRequestDTO;
import org.cyclos.model.access.passwords.GetChangeForgottenPasswordDataParams;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.access.passwords.OtpResult;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.model.utils.Cookie;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.server.model.access.login.AuthVO;
import org.cyclos.server.model.access.login.SessionPropertiesVO;
import org.cyclos.server.model.access.login.SetSessionPropertiesDTO;
import org.cyclos.services.access.AccessClientService;
import org.cyclos.services.access.InternalAuthService;
import org.cyclos.services.access.LoginService;
import org.cyclos.services.access.PasswordService;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.AuthApi;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.model.Auth;
import org.cyclos.web.rest.model.ChangeForgottenPassword;
import org.cyclos.web.rest.model.DataForChangeForgottenPassword;
import org.cyclos.web.rest.model.DataForLogin;
import org.cyclos.web.rest.model.ForgottenPasswordRequest;
import org.cyclos.web.rest.model.ForgottenPasswordResponse;
import org.cyclos.web.rest.model.LoginAuth;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.SendMediumEnum;
import org.cyclos.web.rest.model.SessionPropertiesEdit;
import org.cyclos.web.rest.model.SessionPropertiesView;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AuthApiImpl
extends BaseApiImpl {
    @Autowired
    private InternalAuthService internalAuthService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private PasswordService passwordService;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private AccessClientService accessClientService;

    public ResponseEntity<Void> changeForgottenPassword(ChangeForgottenPassword changeForgottenPassword) {
        ChangeForgottenPasswordDTO changeForgottenPasswordDTO = this.authApiHelper.toChangeForgottenPasswordDTO(changeForgottenPassword);
        this.passwordService.changeForgottenPassword(changeForgottenPasswordDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> confirmLogin(String string) {
        this.loginService.confirmLogin(string);
        return this.okOrNoContent(Optional.empty());
    }

    public ResponseEntity<Void> disconnectCurrentClient(String string) {
        ActionWithConfirmationPassword actionWithConfirmationPassword = new ActionWithConfirmationPassword();
        actionWithConfirmationPassword.setConfirmationPassword(string);
        boolean bl = this.accessClientService.unassignCurrent(actionWithConfirmationPassword);
        if (!bl) {
            throw new IllegalActionException();
        }
        return this.ok();
    }

    public ResponseEntity<ForgottenPasswordResponse> forgottenPasswordRequest(ForgottenPasswordRequest forgottenPasswordRequest) {
        ForgotPasswordRequestDTO forgotPasswordRequestDTO = this.authApiHelper.toForgotPasswordRequestDTO(forgottenPasswordRequest);
        OtpResult otpResult = this.passwordService.forgotPasswordRequest(forgotPasswordRequestDTO);
        ForgottenPasswordResponse forgottenPasswordResponse = this.authApiHelper.toForgottenPasswordResponse(otpResult);
        return this.ok(forgottenPasswordResponse);
    }

    public ResponseEntity<Auth> getCurrentAuth(List<String> list) {
        AuthVO authVO = this.internalAuthService.getCurrentAuth();
        Auth auth = this.authApiHelper.toAuth(authVO);
        return this.ok(auth);
    }

    public ResponseEntity<DataForChangeForgottenPassword> getDataForChangeForgottenPassword(String string, String string2, List<String> list) {
        GetChangeForgottenPasswordDataParams getChangeForgottenPasswordDataParams = this.authApiHelper.toGetChangeForgottenPasswordDataParams(string, string2);
        ChangeForgottenPasswordData changeForgottenPasswordData = this.passwordService.getChangeForgottenPasswordData(getChangeForgottenPasswordDataParams);
        DataForChangeForgottenPassword dataForChangeForgottenPassword = this.authApiHelper.toDataForChangeForgottenPassword(changeForgottenPasswordData);
        return this.ok(dataForChangeForgottenPassword);
    }

    public ResponseEntity<DataForLogin> getDataForLogin(List<String> list, String string, String string2) {
        if (!this.apiHelper.isGuest()) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        PinLocatorVO pinLocatorVO = null;
        if (StringHelper.isNotBlank((Object)string2)) {
            pinLocatorVO = new PinLocatorVO((Property)PinLocatorVO.PRINCIPAL, (Object)string2);
        }
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        LoginData loginData = this.loginService.getLoginData(ServletHelper.getChannelName(httpServletRequest), this.apiHelper.fromId(string), pinLocatorVO);
        DataForLogin dataForLogin = this.authApiHelper.toDataForLogin(loginData);
        return this.ok(dataForLogin);
    }

    public ResponseEntity<PasswordInput> getLoginConfirmation() {
        CredentialInputDTO credentialInputDTO = this.loginService.getLoginConfirmationCredentialInput();
        return this.ok(this.authApiHelper.toPasswordInput((ICredentialInputDTO)credentialInputDTO));
    }

    public ResponseEntity<PasswordInput> getSecondaryPasswordInput() {
        return this.getLoginConfirmation();
    }

    public ResponseEntity<SessionPropertiesView> getSessionProperties(List<String> list) {
        SessionPropertiesVO sessionPropertiesVO = this.internalAuthService.getSessionProperties();
        SessionPropertiesView sessionPropertiesView = this.authApiHelper.toSessionPropertiesView(sessionPropertiesVO);
        return this.okOrNoContent(Optional.ofNullable(sessionPropertiesView));
    }

    public ResponseEntity<LoginAuth> login(AuthApi.LoginParams loginParams) {
        TimeIntervalDTO timeIntervalDTO = null;
        Integer n = loginParams.timeoutInSeconds;
        if (n != null) {
            timeIntervalDTO = ModelHelper.timeInterval((int)n, (TimeField)TimeField.SECONDS);
        }
        AuthVO authVO = this.internalAuthService.login(this.authApiHelper.toLoginDTO(timeIntervalDTO, loginParams.deviceConfirmationId, loginParams.deviceId, loginParams.hmac, loginParams.identityProviderRequestId, loginParams.fcmDeviceToken, loginParams.userAgentId, loginParams.mobileAppVersion));
        String string = authVO.getSessionToken();
        String string2 = this.sendSessionToken(string, loginParams.cookie);
        authVO.setSessionToken(string2);
        LoginAuth loginAuth = this.authApiHelper.toLoginAuth(authVO);
        return this.ok(loginAuth);
    }

    public ResponseEntity<Void> logout(Boolean bl) {
        if (this.apiHelper.isSession()) {
            this.internalAuthService.logout();
            if (Boolean.TRUE.equals(bl)) {
                ServletHelper.setSessionToken(ServletHelper.getRequest(), ServletHelper.getResponse(), null);
            }
            return this.ok();
        }
        throw new PermissionDeniedException();
    }

    public ResponseEntity<List<String>> newOtp(SendMediumEnum sendMediumEnum, String string, List<String> list) {
        List list2 = this.passwordService.requestNewOTP(this.apiHelper.toSendMedium(sendMediumEnum), string, this.apiHelper.fromIds(list));
        return this.ok(list2);
    }

    public ResponseEntity<List<String>> newOtpForLoginConfirmation(SendMediumEnum sendMediumEnum, List<String> list) {
        List list2 = this.passwordService.requestNewOTPForLoginConfirmation(this.apiHelper.toSendMedium(sendMediumEnum), this.apiHelper.fromIds(list));
        return this.ok(list2);
    }

    public ResponseEntity<List<String>> newOtpForSecondaryPassword(SendMediumEnum sendMediumEnum, List<String> list) {
        return this.newOtpForLoginConfirmation(sendMediumEnum, list);
    }

    public ResponseEntity<String> replaceSession(String string, Boolean bl) {
        if (!this.apiHelper.isGuest()) {
            throw new PermissionDeniedException();
        }
        ServletHelper.setSessionToken(ServletHelper.getRequest(), string);
        String string2 = this.loginService.replaceSession();
        return this.ok(this.sendSessionToken(string2, bl));
    }

    public ResponseEntity<Void> setSessionProperties(SessionPropertiesEdit sessionPropertiesEdit) {
        SetSessionPropertiesDTO setSessionPropertiesDTO = this.authApiHelper.toSetSessionPropertiesDTO(sessionPropertiesEdit);
        this.internalAuthService.setSessionProperties(setSessionPropertiesDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> validateSecondaryPassword(String string) {
        return this.confirmLogin(string);
    }

    private String sendSessionToken(String string, Boolean bl) {
        String string2;
        if (Boolean.TRUE.equals(bl)) {
            Pair<String, String> pair = ServletHelper.splitSessionToken(string);
            string2 = (String)pair.getFirst();
            ServletHelper.sendCookie(ServletHelper.getRequest(), ServletHelper.getResponse(), null, true, true, Cookie.SESSION_TOKEN, (String)pair.getSecond());
        } else {
            string2 = string;
        }
        ServletHelper.setSessionToken(ServletHelper.getRequest(), string);
        return string2;
    }
}

