/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.AuthApiImpl;
import org.cyclos.web.rest.model.Auth;
import org.cyclos.web.rest.model.ChangeForgottenPassword;
import org.cyclos.web.rest.model.DataForChangeForgottenPassword;
import org.cyclos.web.rest.model.DataForLogin;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ForgottenPasswordError;
import org.cyclos.web.rest.model.ForgottenPasswordRequest;
import org.cyclos.web.rest.model.ForgottenPasswordResponse;
import org.cyclos.web.rest.model.LoginAuth;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.SendMediumEnum;
import org.cyclos.web.rest.model.SessionPropertiesEdit;
import org.cyclos.web.rest.model.SessionPropertiesView;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class AuthApi {
    @Autowired
    private AuthApiImpl impl;
    public static final String CHANGE_FORGOTTEN_PASSWORD = "/auth/forgotten-password";
    public static final String CONFIRM_LOGIN = "/auth/session/login-confirmation";
    public static final String DISCONNECT_CURRENT_CLIENT = "/auth/access-client";
    public static final String FORGOTTEN_PASSWORD_REQUEST = "/auth/forgotten-password/request";
    public static final String GET_CURRENT_AUTH = "/auth";
    public static final String GET_DATA_FOR_CHANGE_FORGOTTEN_PASSWORD = "/auth/forgotten-password/data-for-change";
    public static final String GET_DATA_FOR_LOGIN = "/auth/data-for-login";
    public static final String GET_LOGIN_CONFIRMATION = "/auth/session/login-confirmation";
    public static final String GET_SECONDARY_PASSWORD_INPUT = "/auth/session/secondary-password";
    public static final String GET_SESSION_PROPERTIES = "/auth/session";
    public static final String LOGIN = "/auth/session";
    public static final String LOGOUT = "/auth/session";
    public static final String NEW_OTP = "/auth/otp";
    public static final String NEW_OTP_FOR_LOGIN_CONFIRMATION = "/auth/session/login-confirmation/otp";
    public static final String NEW_OTP_FOR_SECONDARY_PASSWORD = "/auth/session/secondary-password/otp";
    public static final String REPLACE_SESSION = "/auth/session/replace/{sessionToken}";
    public static final String SET_SESSION_PROPERTIES = "/auth/session";
    public static final String VALIDATE_SECONDARY_PASSWORD = "/auth/session/secondary-password";

    @RequestMapping(value={"/api/auth/forgotten-password"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> changeForgottenPassword(@RequestBody(required=true) ChangeForgottenPassword changeForgottenPassword, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /auth/forgotten-password");
        httpServletRequest.setAttribute("errorType", ForgottenPasswordError.class);
        return this.impl.changeForgottenPassword(changeForgottenPassword);
    }

    @RequestMapping(value={"/api/auth/session/login-confirmation"}, produces={"application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<Void> confirmLogin(@RequestBody(required=true) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /auth/session/login-confirmation");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.confirmLogin(string);
    }

    @RequestMapping(value={"/api/auth/access-client"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> disconnectCurrentClient(@RequestHeader(value="confirmationPassword", required=false) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /auth/access-client");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.disconnectCurrentClient(string);
    }

    @RequestMapping(value={"/api/auth/forgotten-password/request"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ForgottenPasswordResponse> forgottenPasswordRequest(@RequestBody(required=true) ForgottenPasswordRequest forgottenPasswordRequest, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /auth/forgotten-password/request");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.forgottenPasswordRequest(forgottenPasswordRequest);
    }

    @RequestMapping(value={"/api/auth"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Auth> getCurrentAuth(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /auth");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getCurrentAuth(list);
    }

    @RequestMapping(value={"/api/auth/forgotten-password/data-for-change"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForChangeForgottenPassword> getDataForChangeForgottenPassword(@RequestParam(value="user", required=true) String string, @RequestParam(value="code", required=true) String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /auth/forgotten-password/data-for-change");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getDataForChangeForgottenPassword(string, string2, list);
    }

    @RequestMapping(value={"/api/auth/data-for-login"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForLogin> getDataForLogin(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="deviceId", required=false) String string, @RequestParam(value="pinPrincipal", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /auth/data-for-login");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getDataForLogin(list, string, string2);
    }

    @RequestMapping(value={"/api/auth/session/login-confirmation"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PasswordInput> getLoginConfirmation(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /auth/session/login-confirmation");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getLoginConfirmation();
    }

    @RequestMapping(value={"/api/auth/session/secondary-password"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PasswordInput> getSecondaryPasswordInput(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /auth/session/secondary-password");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getSecondaryPasswordInput();
    }

    @RequestMapping(value={"/api/auth/session"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<SessionPropertiesView> getSessionProperties(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /auth/session");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getSessionProperties(list);
    }

    @RequestMapping(value={"/api/auth/session"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<LoginAuth> login(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="cookie", required=false) Boolean bl, @RequestParam(value="timeoutInSeconds", required=false) Integer n, @RequestParam(value="deviceConfirmationId", required=false) String string, @RequestParam(value="userAgentId", required=false) String string2, @RequestParam(value="deviceId", required=false) String string3, @RequestParam(value="hmac", required=false) String string4, @RequestParam(value="identityProviderRequestId", required=false) String string5, @RequestParam(value="fcmDeviceToken", required=false) String string6, @RequestParam(value="mobileAppVersion", required=false) String string7, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /auth/session");
        httpServletRequest.setAttribute("errorType", Error.class);
        LoginParams loginParams = new LoginParams();
        loginParams.fields = list;
        loginParams.cookie = bl;
        loginParams.timeoutInSeconds = n;
        loginParams.deviceConfirmationId = string;
        loginParams.userAgentId = string2;
        loginParams.deviceId = string3;
        loginParams.hmac = string4;
        loginParams.identityProviderRequestId = string5;
        loginParams.fcmDeviceToken = string6;
        loginParams.mobileAppVersion = string7;
        return this.impl.login(loginParams);
    }

    @RequestMapping(value={"/api/auth/session"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> logout(@RequestParam(value="cookie", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /auth/session");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.logout(bl);
    }

    @RequestMapping(value={"/api/auth/otp"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<List<String>> newOtp(@RequestParam(value="medium", required=true) SendMediumEnum sendMediumEnum, @RequestParam(value="otpChannel", required=false) String string, @RequestParam(value="mobilePhones", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /auth/otp");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.newOtp(sendMediumEnum, string, list);
    }

    @RequestMapping(value={"/api/auth/session/login-confirmation/otp"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<List<String>> newOtpForLoginConfirmation(@RequestParam(value="medium", required=true) SendMediumEnum sendMediumEnum, @RequestParam(value="mobilePhones", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /auth/session/login-confirmation/otp");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.newOtpForLoginConfirmation(sendMediumEnum, list);
    }

    @RequestMapping(value={"/api/auth/session/secondary-password/otp"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<List<String>> newOtpForSecondaryPassword(@RequestParam(value="medium", required=true) SendMediumEnum sendMediumEnum, @RequestParam(value="mobilePhones", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /auth/session/secondary-password/otp");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.newOtpForSecondaryPassword(sendMediumEnum, list);
    }

    @RequestMapping(value={"/api/auth/session/replace/{sessionToken}"}, produces={"text/plain", "application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> replaceSession(@PathVariable(value="sessionToken") String string, @RequestParam(value="cookie", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /auth/session/replace/{sessionToken}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.replaceSession(string, bl);
    }

    @RequestMapping(value={"/api/auth/session"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> setSessionProperties(@RequestBody(required=true) SessionPropertiesEdit sessionPropertiesEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /auth/session");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.setSessionProperties(sessionPropertiesEdit);
    }

    @RequestMapping(value={"/api/auth/session/secondary-password"}, produces={"application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<Void> validateSecondaryPassword(@RequestBody(required=true) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /auth/session/secondary-password");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.validateSecondaryPassword(string);
    }

    public static class LoginParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public Boolean cookie;
        public static final String COOKIE = "cookie";
        public Integer timeoutInSeconds;
        public static final String TIMEOUT_IN_SECONDS = "timeoutInSeconds";
        public String deviceConfirmationId;
        public static final String DEVICE_CONFIRMATION_ID = "deviceConfirmationId";
        public String userAgentId;
        public static final String USER_AGENT_ID = "userAgentId";
        public String deviceId;
        public static final String DEVICE_ID = "deviceId";
        public String hmac;
        public static final String HMAC = "hmac";
        public String identityProviderRequestId;
        public static final String IDENTITY_PROVIDER_REQUEST_ID = "identityProviderRequestId";
        public String fcmDeviceToken;
        public static final String FCM_DEVICE_TOKEN = "fcmDeviceToken";
        public String mobileAppVersion;
        public static final String MOBILE_APP_VERSION = "mobileAppVersion";
    }
}

