/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.system;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.system.configurations.ConfigurationImageVO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.services.system.InternalImageService;
import org.cyclos.utils.ContentType;
import org.cyclos.web.controllers.InlineCacheableContentResolver;

public class ConfigurationImageContentResolver
extends InlineCacheableContentResolver {
    private static final int THUMBNAIL_JPEG_QUALITY = 95;
    private CyclosProperties cyclosProperties;
    private InternalImageService imageService;
    private ConfigurationImageVO image;
    private String extension;
    private int width;
    private int height;
    private File file;

    public ConfigurationImageContentResolver(CyclosProperties cyclosProperties, InternalImageService internalImageService, ConfigurationImageVO configurationImageVO, Integer n, Integer n2) {
        ServerImageHelper.ImageType imageType;
        this.cyclosProperties = cyclosProperties;
        this.imageService = internalImageService;
        try {
            imageType = ServerImageHelper.ImageType.getByContentType((String)configurationImageVO.getContentType());
        }
        catch (Exception exception) {
            imageType = null;
        }
        this.extension = imageType.getExtension();
        if (imageType == null || n != null && n <= 0 || n2 != null && n2 <= 0) {
            throw new EntityNotFoundException();
        }
        this.image = configurationImageVO;
        Dimension dimension = ServerImageHelper.getActualSize((Dimension)new Dimension(configurationImageVO.getWidth(), configurationImageVO.getHeight()), (Integer)n, (Integer)n2);
        this.width = (int)dimension.getWidth();
        this.height = (int)dimension.getHeight();
        this.file = this.file(this.width, this.height);
    }

    @Override
    protected ContentType resolveContentType() throws IOException {
        return ContentType.getByExtension((String)this.extension);
    }

    @Override
    protected File resolveFile() throws IOException {
        return this.file;
    }

    @Override
    protected File resolveGZipFile(File file) {
        return null;
    }

    @Override
    protected Long resolveLastModification() {
        try {
            return this.writeOriginal().lastModified();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected void writeContent(File file) throws IOException {
        File file2 = this.writeOriginal();
        if (!file2.equals(file)) {
            BufferedImage bufferedImage = ImageIO.read(file2);
            bufferedImage = ServerImageHelper.resize((BufferedImage)bufferedImage, (int)this.width, (int)this.height);
            ServerImageHelper.write((BufferedImage)bufferedImage, (ServerImageHelper.ImageType)ServerImageHelper.ImageType.getByFileName((String)file.getName()), (File)file, (int)95);
            file.setLastModified(file2.lastModified());
        }
    }

    private File file(Integer n, Integer n2) {
        Object object;
        Long l = EntityVO.id((EntityVO)this.image);
        Object object2 = object = l == null ? EntityVO.id((EntityVO)this.image.getConfiguration()) + "_" + this.image.getType().name() : l.toString();
        if (n != null && n2 != null) {
            object = (String)object + "_" + n + "x" + n2;
        }
        object = (String)object + "." + this.extension;
        return new File(this.imageDir(), (String)object);
    }

    private File imageDir() {
        File file = new File(this.cyclosProperties.getTempDir(), "images/CONFIGURATION");
        file.mkdirs();
        return file;
    }

    private File writeOriginal() throws IOException {
        Long l;
        File file = this.file(null, null);
        Long l2 = l = this.image.getLastModifiedInMillis() == null ? null : Long.valueOf(Long.parseLong(this.image.getLastModifiedInMillis()));
        if (!file.exists() || file.length() == 0L || l != null && file.lastModified() != l.longValue()) {
            SerializableInputStream serializableInputStream;
            file.getParentFile().mkdirs();
            if (this.image.getId() != null) {
                serializableInputStream = this.imageService.readContent(this.image.getId());
            } else {
                Long l3 = EntityVO.id((EntityVO)this.image.getConfiguration());
                serializableInputStream = this.imageService.readConfigurationImage(l3, this.image.getType());
            }
            IOHelper.copyAndClose((InputStream)serializableInputStream, (File)file);
            if (l != null) {
                file.setLastModified(l);
            }
        }
        return file;
    }
}

