/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.contentmanagement;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.contentmanagement.themes.ThemeImageVO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.services.system.InternalImageService;
import org.cyclos.utils.ContentType;
import org.cyclos.web.controllers.InlineCacheableContentResolver;

public class ThemeImageContentResolver
extends InlineCacheableContentResolver {
    private static final int THUMBNAIL_JPEG_QUALITY = 95;
    private CyclosProperties cyclosProperties;
    private InternalImageService imageService;
    private ThemeImageVO image;
    private String extension;
    private int width;
    private int height;
    private File file;

    public ThemeImageContentResolver(CyclosProperties cyclosProperties, InternalImageService internalImageService, ThemeImageVO themeImageVO, Integer n, Integer n2) {
        ServerImageHelper.ImageType imageType;
        this.cyclosProperties = cyclosProperties;
        this.imageService = internalImageService;
        try {
            imageType = ServerImageHelper.ImageType.getByContentType((String)themeImageVO.getContentType());
        }
        catch (Exception exception) {
            imageType = null;
        }
        this.extension = imageType.getExtension();
        if (imageType == null || n != null && n <= 0 || n2 != null && n2 <= 0) {
            throw new EntityNotFoundException();
        }
        this.image = themeImageVO;
        Dimension dimension = ServerImageHelper.getActualSize((Dimension)new Dimension(themeImageVO.getWidth(), themeImageVO.getHeight()), (Integer)n, (Integer)n2);
        this.width = (int)dimension.getWidth();
        this.height = (int)dimension.getHeight();
        this.file = this.file(this.width, this.height);
    }

    @Override
    protected ContentType resolveContentType() throws IOException {
        return ContentType.getByExtension((String)this.extension);
    }

    @Override
    protected File resolveFile() throws IOException {
        return this.file;
    }

    @Override
    protected File resolveGZipFile(File file) {
        return null;
    }

    @Override
    protected Long resolveLastModification() {
        try {
            return this.writeOriginal().lastModified();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected void writeContent(File file) throws IOException {
        File file2 = this.writeOriginal();
        if (!file2.equals(file)) {
            BufferedImage bufferedImage = ImageIO.read(file2);
            bufferedImage = ServerImageHelper.resize((BufferedImage)bufferedImage, (int)this.width, (int)this.height);
            ServerImageHelper.write((BufferedImage)bufferedImage, (ServerImageHelper.ImageType)ServerImageHelper.ImageType.getByFileName((String)file.getName()), (File)file, (int)95);
            file.setLastModified(file2.lastModified());
        }
    }

    private File file(Integer n, Integer n2) {
        Object object;
        Long l = EntityVO.id((EntityVO)this.image);
        if (l != null) {
            object = l.toString();
        } else {
            Long l2 = EntityVO.id((EntityVO)this.image.getTheme());
            object = l2 + "_" + this.image.getType().name() + "_" + this.image.isCustomized() + "_" + this.image.getName();
        }
        if (n != null && n2 != null) {
            object = (String)object + "_" + n + "x" + n2;
        }
        object = (String)object + "." + this.extension;
        return new File(this.imageDir(), (String)object);
    }

    private File imageDir() {
        File file = new File(this.cyclosProperties.getTempDir(), "images/THEME");
        file.mkdirs();
        return file;
    }

    private File writeOriginal() throws IOException {
        File file = this.file(null, null);
        if (!file.exists() || file.length() == 0L) {
            SerializableInputStream serializableInputStream;
            file.getParentFile().mkdirs();
            if (this.image.getId() != null) {
                serializableInputStream = this.imageService.readContent(this.image.getId());
            } else {
                Long l = EntityVO.id((EntityVO)this.image.getTheme());
                serializableInputStream = this.imageService.readThemeImage(l, this.image.getType(), this.image.getName());
            }
            IOHelper.copyAndClose((InputStream)serializableInputStream, (File)file);
        }
        return file;
    }
}

