/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.banking;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.banking.accounts.AccountBalanceLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryQuery;
import org.cyclos.model.banking.accounts.UserWithBalanceQuery;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.services.banking.AccountService;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AccountsController
extends BaseController {
    @Autowired
    private AccountService accountService;

    @PostMapping(value={"/content/accountHistory/export/{format:.*}"})
    public void exportAccountHistory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="format") String string, @RequestParam(value="query") String string2) throws IOException {
        AccountHistoryQuery accountHistoryQuery = (AccountHistoryQuery)this.jsonConverter.readValue(string2, AccountHistoryQuery.class);
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        FileInfo fileInfo = this.accountService.exportAccountHistory(exportFormatVO, accountHistoryQuery);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/archivedAccountHistory/export/{format:.*}"})
    public void exportArchivedAccountHistory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="format") String string, @RequestParam(value="query") String string2) throws IOException {
        ArchivedAccountHistoryQuery archivedAccountHistoryQuery = (ArchivedAccountHistoryQuery)this.jsonConverter.readValue(string2, ArchivedAccountHistoryQuery.class);
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        FileInfo fileInfo = this.accountService.exportArchivedAccountHistory(exportFormatVO, archivedAccountHistoryQuery);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/archivedTransfers/export/{id}/{format:.*}"})
    public void exportArchivedTransfer(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l, @PathVariable(value="format") String string) throws IOException {
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        FileInfo fileInfo = this.accountService.exportArchivedTransfer(exportFormatVO, l);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/accountBalanceLimitsOverview/export/{format:.*}"})
    public void exportBalanceLimitsOverview(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="format") String string, @RequestParam(value="query") String string2) throws IOException {
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        AccountBalanceLimitsOverviewQuery accountBalanceLimitsOverviewQuery = (AccountBalanceLimitsOverviewQuery)this.jsonConverter.readValue(string2, AccountBalanceLimitsOverviewQuery.class);
        FileInfo fileInfo = this.accountService.exportAccountBalanceLimitsOverview(exportFormatVO, accountBalanceLimitsOverviewQuery);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/accountHistoriesOverview/export/{format:.*}"})
    public void exportHistoriesOverview(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="format") String string, @RequestParam(value="query") String string2) throws IOException {
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        AccountHistoriesOverviewQuery accountHistoriesOverviewQuery = (AccountHistoriesOverviewQuery)this.jsonConverter.readValue(string2, AccountHistoriesOverviewQuery.class);
        FileInfo fileInfo = this.accountService.exportAccountHistoriesOverview(exportFormatVO, accountHistoriesOverviewQuery);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/accountPaymentAmountLimitsOverview/export/{format:.*}"})
    public void exportPaymentAmountLimitsOverview(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="format") String string, @RequestParam(value="query") String string2) throws IOException {
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        AccountPaymentAmountLimitsOverviewQuery accountPaymentAmountLimitsOverviewQuery = (AccountPaymentAmountLimitsOverviewQuery)this.jsonConverter.readValue(string2, AccountPaymentAmountLimitsOverviewQuery.class);
        FileInfo fileInfo = this.accountService.exportAccountPaymentAmountLimitsOverview(exportFormatVO, accountPaymentAmountLimitsOverviewQuery);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/usersWithBalances/export/{format:.*}"})
    public void exportUsersWithBalance(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="format") String string, @RequestParam(value="query") String string2) throws IOException {
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        UserWithBalanceQuery userWithBalanceQuery = (UserWithBalanceQuery)this.jsonConverter.readValue(string2, UserWithBalanceQuery.class);
        FileInfo fileInfo = this.accountService.exportUsersWithBalances(exportFormatVO, userWithBalanceQuery);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }
}

