/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.Collections;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.users.UserGroupServiceLocal;
import org.cyclos.model.access.Permission;
import org.cyclos.model.users.groups.ChangeGroupDTO;
import org.cyclos.model.users.groups.ChangeGroupData;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.UserGroupService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class UserGroupServiceSecurity
extends BaseServiceSecurity
implements UserGroupService {
    @Autowired
    private UserGroupServiceLocal userGroupService;

    public Long changeGroup(ChangeGroupDTO changeGroupDTO) {
        BasicUser basicUser = this.getUser((IUser)changeGroupDTO.getUser());
        this.permission(basicUser).user(new Permission[]{Permission.USER_GROUP_MANAGE}).check();
        return this.userGroupService.changeGroup(changeGroupDTO);
    }

    public ChangeGroupData getChangeGroupData(UserLocatorVO userLocatorVO) {
        BasicUser basicUser = this.getUser((IUser)userLocatorVO);
        this.permission(basicUser).user(new Permission[]{Permission.USER_GROUP_VIEW}).check();
        ChangeGroupData changeGroupData = this.userGroupService.getChangeGroupData(userLocatorVO);
        if (!this.permission(basicUser).user(new Permission[]{Permission.USER_GROUP_MANAGE}).granted()) {
            changeGroupData.setPossibleNewGroups(Collections.emptyList());
        }
        return changeGroupData;
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

