/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.UserPermissionCheck;
import org.cyclos.impl.users.PrivacySettingsServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.users.privacysettings.PrivacySettingsDTO;
import org.cyclos.model.users.privacysettings.PrivacySettingsData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.PrivacySettingsService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class PrivacySettingsServiceSecurity
extends BaseServiceSecurity
implements PrivacySettingsService {
    @Autowired
    private PrivacySettingsServiceLocal privacySettingsService;

    public PrivacySettingsData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        this.permission((BasicUser)user).user(new Permission[]{Permission.USER_PRIVACY_SETTINGS_VIEW}).my(new Permission[]{Permission.MY_PRIVACY_SETTINGS_VIEW}).check();
        PrivacySettingsData privacySettingsData = this.privacySettingsService.getData(userLocatorVO);
        privacySettingsData.setEditable(this.manageCheck(user).granted());
        return privacySettingsData;
    }

    public void save(PrivacySettingsDTO privacySettingsDTO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)privacySettingsDTO.getUser());
        this.manageCheck(user).check();
        this.privacySettingsService.save(privacySettingsDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private UserPermissionCheck manageCheck(User user) {
        return this.permission((BasicUser)user).user(new Permission[]{Permission.USER_PRIVACY_SETTINGS_MANAGE}).my(new Permission[]{Permission.MY_PRIVACY_SETTINGS_MANAGE});
    }
}

