/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactInfo;
import org.cyclos.entities.users.ContactInfoImage;
import org.cyclos.impl.users.ContactInfoImageServiceLocal;
import org.cyclos.model.users.contactinfos.ContactInfoVO;
import org.cyclos.security.Security;
import org.cyclos.security.system.BaseOwnedImageServiceSecurity;
import org.cyclos.security.users.ContactInfoServiceSecurity;
import org.cyclos.services.users.ContactInfoImageService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ContactInfoImageServiceSecurity
extends BaseOwnedImageServiceSecurity<ContactInfo, ContactInfoImage, ContactInfoVO>
implements ContactInfoImageService {
    @Autowired
    private ContactInfoServiceSecurity contactInfoServiceSecurity;
    @Autowired
    private ContactInfoImageServiceLocal contactInfoImageService;

    public ContactInfoImageServiceSecurity() {
        super(ContactInfoImage.class, ContactInfo.class);
    }

    @Override
    protected boolean canListImagesOf(ContactInfo contactInfo) {
        return this.getSessionData().relatesTo((BasicUser)contactInfo.getUser());
    }

    @Override
    protected boolean canManageImagesOf(ContactInfo contactInfo) {
        return this.contactInfoServiceSecurity.hasManageAccess(contactInfo);
    }

    protected ContactInfoImageServiceLocal getImplementation() {
        return this.contactInfoImageService;
    }
}

