/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import javax.validation.constraints.NotNull;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.users.BasicUserServiceLocal;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.access.LoggedOutException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.users.accesslogs.AccessLogQuery;
import org.cyclos.model.users.accesslogs.AccessLogResult;
import org.cyclos.model.users.accesslogs.AccessLogSearchData;
import org.cyclos.model.users.accesslogs.AccessLogVO;
import org.cyclos.model.users.users.AbstractUserQuery;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserActivityType;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserValidationResult;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.users.OperatorServiceSecurity;
import org.cyclos.security.users.UserServiceSecurity;
import org.cyclos.services.users.BasicUserService;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class BasicUserServiceSecurity
extends BaseServiceSecurity
implements BasicUserService {
    @Autowired
    private BasicUserServiceLocal basicUserService;
    @Autowired
    private OperatorServiceSecurity operatorServiceSecurity;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private UserServiceSecurity userServiceSecurity;

    public Page<BasicUserVO> autocomplete(UserQuery userQuery) {
        try {
            LocateUserResult locateUserResult = this.userLocatorHandler.locate(new UserLocatorVO((Property)UserLocatorVO.PRINCIPAL, (Object)userQuery.getKeywords()));
            if (locateUserResult != null) {
                return this.basicUserService.autocomplete(userQuery);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        userQuery.setLocateFirst(false);
        userQuery.setIgnoreProfileFieldsInList(true);
        if (!this.userServiceSecurity.checkQuery((AbstractUserQuery)userQuery)) {
            return PageImpl.empty();
        }
        return this.basicUserService.autocomplete(userQuery);
    }

    public AccessLogSearchData getAccessLogSearchData() {
        this.checkPermission(Permission.ACCESS_LOG_VIEW);
        return this.basicUserService.getAccessLogSearchData();
    }

    public AccessLogVO loadAccessLog(@NotNull Long l) {
        this.checkPermission(Permission.ACCESS_LOG_VIEW);
        return this.basicUserService.loadAccessLog(l);
    }

    public void manuallyValidateEmailChange(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.checkManagesUser((IUser)userLocatorVO);
        if (basicUser instanceof Operator) {
            this.checkManuallyValidateKey((Operator)basicUser);
        } else {
            boolean bl = this.profileFieldHandler.isAllowed((BasicUser)basicUser.getUser(), (ProfileField)BasicProfileField.EMAIL, ProfileFieldAction.EDIT);
            if (!bl) {
                throw new PermissionDeniedException();
            }
        }
        this.basicUserService.manuallyValidateEmailChange(userLocatorVO);
    }

    public UserValidationResult manuallyValidateRegistration(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.checkManagesUser((IUser)userLocatorVO);
        if (basicUser instanceof Operator) {
            this.checkManuallyValidateKey((Operator)basicUser);
        } else {
            this.checkPermission(Permission.PENDING_USERS_MANAGE);
        }
        return this.basicUserService.manuallyValidateRegistration(userLocatorVO);
    }

    public void resendEmailChangeMail(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        if (basicUser instanceof Operator) {
            if (!this.operatorServiceSecurity.canManageOperators(basicUser.getUser())) {
                throw new PermissionDeniedException();
            }
        } else {
            this.checkManagesUser(basicUser);
        }
        this.basicUserService.resendEmailChangeMail(userLocatorVO);
    }

    public void resendRegistrationValidationMail(UserLocatorVO userLocatorVO) {
        BasicUser basicUser = this.checkManagesUser((IUser)userLocatorVO);
        if (basicUser instanceof Operator) {
            if (!this.operatorServiceSecurity.canManageOperators(basicUser.getUser())) {
                throw new PermissionDeniedException();
            }
        } else {
            this.checkPermission(Permission.PENDING_USERS_MANAGE);
        }
        this.basicUserService.resendRegistrationValidationMail(userLocatorVO);
    }

    public Page<AccessLogResult> searchAccessLogs(@NotNull AccessLogQuery accessLogQuery) throws FrameworkException {
        this.checkPermission(Permission.ACCESS_LOG_VIEW);
        return this.basicUserService.searchAccessLogs(accessLogQuery);
    }

    public void updateUserActivity(UserActivityType userActivityType) {
        this.checkLoggedIn();
        this.basicUserService.updateUserActivity(userActivityType);
    }

    public Long validateEmailChange(String string) throws FrameworkException {
        BasicUser basicUser;
        Long l = this.basicUserService.validateEmailChange(string);
        BasicUser basicUser2 = this.getLoggedBasicUser();
        if (basicUser2 != null && !basicUser2.equals((Object)(basicUser = this.find(BasicUser.class, l)))) {
            throw new LoggedOutException();
        }
        return l;
    }

    public UserValidationResult validateRegistration(String string) {
        if (!this.isGuest()) {
            throw new LoggedOutException();
        }
        return this.basicUserService.validateRegistration(string);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private void checkManuallyValidateKey(Operator operator) {
        User user = operator.getUser();
        if (!this.operatorServiceSecurity.canManageOperators(user) || user.equals((Object)this.getLoggedUser())) {
            throw new PermissionDeniedException();
        }
    }
}

