/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanPath;
import java.util.List;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.system.CustomWizardField;
import org.cyclos.entities.system.RegistrationWizard;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.QProductMyProfileField;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.TempImageServiceLocal;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.NewTempImageParams;
import org.cyclos.model.system.images.TempImageTarget;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.security.Security;
import org.cyclos.security.system.BaseImageServiceSecurity;
import org.cyclos.security.system.RawFileServiceSecurity;
import org.cyclos.security.users.ContactInfoServiceSecurity;
import org.cyclos.services.system.TempImageService;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TempImageServiceSecurity
extends BaseImageServiceSecurity<TempImage, NewTempImageParams>
implements TempImageService {
    @Autowired
    private TempImageServiceLocal tempImageService;
    @Autowired
    private RawFileServiceSecurity tempFileServiceSecurity;
    @Autowired
    private ContactInfoServiceSecurity contactInfoServiceSecurity;

    public TempImageServiceSecurity() {
        super(TempImage.class);
    }

    @Override
    public boolean hasManageAccess(TempImage tempImage) {
        SessionData sessionData = this.getSessionData();
        if (tempImage.getByUser() != null) {
            return ObjectHelper.isOneOf((Object)tempImage.getByUser(), (Object[])new Object[]{sessionData.getLoggedUser(), InvocationContext.get().getAttribute((Object)"tempOwner")});
        }
        return sessionData.isGuest();
    }

    public List<ImageVO> list(NewTempImageParams newTempImageParams) throws FrameworkException {
        this.checkCreateNew(newTempImageParams);
        return this.tempImageService.list(newTempImageParams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void checkCreateNew(NewTempImageParams newTempImageParams) {
        this.tempImageService.preProcess(newTempImageParams);
        SessionData sessionData = this.getSessionData();
        TempImageTarget tempImageTarget = newTempImageParams.getTarget();
        if (sessionData.isGuest()) {
            if (tempImageTarget != TempImageTarget.USER_REGISTRATION && tempImageTarget != TempImageTarget.CUSTOM_VALUE && tempImageTarget != TempImageTarget.CONTACT_INFO) {
                throw new PermissionDeniedException();
            }
            ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
            int n = configurationAccessor.getMaxGuestTempImages();
            if (n <= 0) {
                throw new PermissionDeniedException();
            }
            if (tempImageTarget != TempImageTarget.CUSTOM_VALUE) return;
            CustomField customField = this.customFieldValueHandler.getCustomField(newTempImageParams.getCustomField());
            if (customField == null) throw new PermissionDeniedException();
            if (!(customField instanceof UserCustomField) && !(customField instanceof ContactInfoField)) {
                if (!(customField instanceof CustomWizardField)) throw new PermissionDeniedException();
                if (!(((CustomWizardField)customField).getWizard() instanceof RegistrationWizard)) {
                    throw new PermissionDeniedException();
                }
            }
            if (customField instanceof UserCustomField) {
                UserCustomField userCustomField = (UserCustomField)customField;
                BooleanPath booleanPath = QProductMyProfileField.productMyProfileField.editableAtRegistration;
                boolean bl = false;
                for (UserGroup userGroup2 : configurationAccessor.getPossibleInitialGroups()) {
                    ProductAccessor productAccessor = this.productsHandler.getAccessor((BasicGroup)userGroup2).product();
                    if (productAccessor.getMyProfileFields().isSet((Object)BasicProfileField.IMAGE, (Path)booleanPath)) return;
                    if (userCustomField == null || !productAccessor.getMyProfileFields().isSet((Object)userCustomField, (Path)booleanPath)) continue;
                    return;
                }
                if (bl) return;
                throw new PermissionDeniedException();
            }
            if (customField instanceof CustomWizardField) {
                CustomWizard customWizard = ((CustomWizardField)customField).getWizard();
                if (customWizard.equals((Object)configurationAccessor.getLargeScreenRegistrationWizard())) return;
                if (customWizard.equals((Object)configurationAccessor.getMediumScreenRegistrationWizard())) return;
                if (customWizard.equals((Object)configurationAccessor.getSmallScreenRegistrationWizard())) return;
                throw new PermissionDeniedException();
            }
            if (!(customField instanceof ContactInfoField)) throw new PermissionDeniedException();
            ContactInfoField contactInfoField = (ContactInfoField)customField;
            if (configurationAccessor.getPossibleInitialGroups().stream().anyMatch(userGroup -> this.productsHandler.getAccessor((BasicGroup)userGroup).member().getContactInfoFields().contains(contactInfoField))) return;
            throw new PermissionDeniedException();
        }
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent(newTempImageParams.getUser());
        switch (tempImageTarget) {
            case USER_REGISTRATION: {
                this.checkPermission(Permission.USERS_REGISTER);
                return;
            }
            case USER_PROFILE: {
                if (this.profileFieldHandler.isAllowed(basicUser, (ProfileField)BasicProfileField.IMAGE, ProfileFieldAction.EDIT)) return;
                throw new PermissionDeniedException();
            }
            case CONTACT_INFO: {
                if (this.contactInfoServiceSecurity.canManageContactInfosOf(basicUser.getUser())) return;
                throw new PermissionDeniedException();
            }
            case ADVERTISEMENT: {
                this.permission((BasicUser)basicUser.getUser()).user(new Permission[]{Permission.USER_ADS_MANAGE, Permission.USER_WEB_SHOP_MANAGE}).my(new Permission[]{Permission.MY_ADS_MANAGE, Permission.MY_WEB_SHOP_MANAGE}).check();
                return;
            }
            case CUSTOM_VALUE: {
                CustomField customField = this.customFieldValueHandler.getCustomField(newTempImageParams.getCustomField());
                this.tempFileServiceSecurity.checkPermissionForNewTemp(customField);
                return;
            }
            case AD_CATEGORY: {
                this.checkPermission(Permission.AD_CONFIGURATION_MANAGE);
                return;
            }
            case VOUCHER_TYPE: {
                this.checkPermission(Permission.VOUCHER_TYPES_MANAGE);
                return;
            }
            case OIDC_CLIENT: {
                this.checkPermission(Permission.OIDC_CLIENTS_MANAGE);
                return;
            }
            case IDENTITY_PROVIDER: {
                this.checkPermission(Permission.SYSTEM_CONFIGURATION_MANAGE);
                return;
            }
            case VOUCHER_CATEGORY: {
                this.checkPermission(Permission.VOUCHER_TYPES_MANAGE);
                return;
            }
            case DEFAULT_USER: {
                this.checkPermission(Permission.SYSTEM_CONFIGURATION_MANAGE);
            }
        }
    }

    protected TempImageServiceLocal getImplementation() {
        return this.tempImageService;
    }
}

