/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.Collections;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.User;
import org.cyclos.impl.system.NetworkServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.networks.BasicNetworkInitialDataDTO;
import org.cyclos.model.system.networks.NetworkDTO;
import org.cyclos.model.system.networks.NetworkData;
import org.cyclos.model.system.networks.NetworkInitialDataDTO;
import org.cyclos.model.system.networks.NetworkQuery;
import org.cyclos.model.system.networks.NetworkSearchData;
import org.cyclos.model.system.networks.NetworkVO;
import org.cyclos.model.system.networks.NetworkWithInitialDataData;
import org.cyclos.model.users.groups.AdminGroupVO;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.NetworkService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class NetworkServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<NetworkDTO, Network, NetworkData, Void>
implements NetworkService {
    @Autowired
    private NetworkServiceLocal networkService;

    public NetworkServiceSecurity() {
        super(Network.class);
    }

    public Long createWithData(NetworkDTO networkDTO, NetworkInitialDataDTO networkInitialDataDTO) throws FrameworkException {
        this.checkCreateNew(null);
        return this.networkService.createWithData(networkDTO, networkInitialDataDTO);
    }

    @Override
    public boolean doHasViewAccess(Network network) {
        if (this.hasPermission(Permission.GLOBAL_CONFIGURATION_VIEW)) {
            return true;
        }
        return this.permission(Permission.SPECIFIC_NETWORKS_MANAGE).value((Object)network).granted();
    }

    public NetworkWithInitialDataData getDataForNewWithData() throws FrameworkException {
        this.checkCreateNew(null);
        return this.networkService.getDataForNewWithData();
    }

    public NetworkInitialDataDTO getInitialData(BasicNetworkInitialDataDTO basicNetworkInitialDataDTO) throws FrameworkException {
        this.checkCreateNew(null);
        return this.networkService.getInitialData(basicNetworkInitialDataDTO);
    }

    public NetworkSearchData getSearchData() {
        this.checkView();
        NetworkSearchData networkSearchData = this.networkService.getSearchData();
        networkSearchData.setEditable(this.hasPermission(Permission.GLOBAL_CONFIGURATION_MANAGE, Permission.NETWORKS_REGISTER));
        return networkSearchData;
    }

    public String resolveNetworkUrl(NetworkVO networkVO) throws FrameworkException {
        AdminGroup adminGroup;
        User user = this.getLoggedUser();
        if (user == null || !user.isGlobal()) {
            throw new PermissionDeniedException();
        }
        Network network = this.networkService.findEnabled(networkVO);
        if (network != null && (adminGroup = (AdminGroup)user.getGroup()).getAdminType() == null && !adminGroup.getManagedNetworks().contains(network)) {
            throw new PermissionDeniedException();
        }
        return this.networkService.resolveNetworkUrl(networkVO);
    }

    public Page<NetworkVO> search(NetworkQuery networkQuery) {
        this.checkView();
        if (!this.isGlobalAdmin()) {
            networkQuery.setManagedByGroup(new AdminGroupVO(this.getLoggedUser().getGroup().getId()));
        } else {
            this.groupsHandler.visibles().accessibles().admins().check(Collections.singleton(networkQuery.getManagedByGroup()));
        }
        return this.networkService.search(networkQuery);
    }

    @Override
    protected void checkCreateNew(Void void_) {
        this.checkPermission(Permission.GLOBAL_CONFIGURATION_MANAGE, Permission.NETWORKS_REGISTER);
    }

    @Override
    protected void customizeData(NetworkData networkData) {
        networkData.setCanSetDefault(this.hasPermission(Permission.GLOBAL_CONFIGURATION_MANAGE));
    }

    @Override
    protected boolean doHasManageAccess(Network network) {
        if (this.hasPermission(Permission.GLOBAL_CONFIGURATION_MANAGE)) {
            return true;
        }
        if (network.isTransient()) {
            return this.hasPermission(Permission.NETWORKS_REGISTER);
        }
        return this.permission(Permission.SPECIFIC_NETWORKS_MANAGE).value((Object)network).granted();
    }

    protected NetworkServiceLocal getImplementation() {
        return this.networkService;
    }

    @Override
    protected void onBeforeSave(NetworkDTO networkDTO, Network network) {
        if (!this.hasPermission(Permission.GLOBAL_CONFIGURATION_MANAGE)) {
            networkDTO.setDefaultNetwork(network.isTransient() ? false : network.isDefaultNetwork());
        }
    }

    private void checkView() {
        this.checkPermission(Permission.GLOBAL_CONFIGURATION_MANAGE, Permission.SPECIFIC_NETWORKS_MANAGE, Permission.NETWORKS_REGISTER);
    }
}

